/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.servlet;

import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.servlet.Impressao;
import com.joseflavio.tqc.servlet.TomaraQueCaiaDesktopServlet;
import com.joseflavio.util.TextoUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;

class ControleImpressao
implements Impressao {
    ControleImpressao() {
    }

    public static void imprimir(TomaraQueCaia tqc, Writer saida) throws IOException {
        saida.write("<div align=\"left\" class=\"barraControle\">\n");
        int totalViagens = tqc.getTotalViagens();
        for (int i = 0; i < totalViagens; ++i) {
            Viagem v = tqc.getViagem(i);
            if (v.getAtual() == null) continue;
            saida.write("<input type=\"submit\" id=\"irpara_" + v.getNome() + "\" name=\"irpara_" + v.getNome() + "\" value=\"" + TextoUtil.fixarComprimento(v.getAtual().getTitulo(), 20, true) + "\"");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(null, v == tqc.getViagemAtiva() ? "botaoViagemAtiva" : "botaoViagem", saida);
            saida.write(" />");
            saida.write("<input type=\"submit\" id=\"fechar_" + v.getNome() + "\" name=\"fechar_" + v.getNome() + "\" value=\"x\"");
            TomaraQueCaiaDesktopServlet.imprimirEstilo(null, v == tqc.getViagemAtiva() ? "botaoViagemAtiva" : "botaoViagem", saida);
            saida.write(" />");
        }
        saida.write("</div>\n");
    }

    @Override
    public void imprimir(HttpServletRequest request, TomaraQueCaia tqc, Viagem viagem, Informacao informacao, Writer saida) throws IOException {
        ControleImpressao.imprimir(tqc, saida);
    }
}

