/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.molde;

import com.joseflavio.modelo.AssistenteDeAtributo;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.Molde;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.dado.Data;
import com.joseflavio.tqc.dado.Inteiro;
import com.joseflavio.tqc.dado.Marcador;
import com.joseflavio.tqc.dado.Real;
import com.joseflavio.tqc.dado.Tabela;
import com.joseflavio.tqc.dado.TabelaColuna;
import com.joseflavio.tqc.dado.TabelaColunaFim;
import com.joseflavio.tqc.dado.TabelaFim;
import com.joseflavio.tqc.dado.TabelaLinha;
import com.joseflavio.tqc.dado.TabelaLinhaFim;
import com.joseflavio.tqc.dado.Texto;
import com.joseflavio.util.ClassUtil;
import com.joseflavio.util.Conversor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ListaMolde<ELEMENTO>
implements Molde {
    private List<ListaColuna<ELEMENTO>> colunas;
    private List<ELEMENTO> lista;
    private ListaFiltro<ELEMENTO> filtro;
    private String estiloLinhaImpar = "listaLinhaImpar";
    private String estiloLinhaPar = "listaLinhaPar";
    private Marcador marcadorInicial = new Marcador();
    private Marcador marcadorFinal = new Marcador();

    @Override
    public void construir(Informacao info) throws TomaraQueCaiaException {
        if (this.colunas == null || this.lista == null) {
            throw new TomaraQueCaiaException();
        }
        info.mais(this.marcadorInicial);
        this.inserir(info, info.getTotalDados());
        info.mais(this.marcadorFinal);
    }

    private void inserir(Informacao info, int pos) throws TomaraQueCaiaException {
        ListaColuna<ELEMENTO> coluna;
        int i;
        info.mais(new Tabela(), pos++);
        info.mais(new TabelaLinha(), pos++);
        int aux1 = this.colunas.size();
        for (i = 0; i < aux1; ++i) {
            coluna = this.colunas.get(i);
            info.mais(new TabelaColuna(coluna.getEstiloColunaTitulo()), pos++);
            info.mais(new Texto("tqc_listagem_coluna_" + (i + 1), coluna.getTitulo()).setEstilo(coluna.getEstiloTitulo()), pos++);
            info.mais(new TabelaColunaFim(), pos++);
        }
        info.mais(new TabelaLinhaFim(), pos++);
        aux1 = this.lista.size();
        int aux2 = this.colunas.size();
        boolean par = true;
        for (i = 0; i < aux1; ++i) {
            ELEMENTO elemento = this.lista.get(i);
            if (this.filtro != null && !this.filtro.filtrar(elemento)) continue;
            par = !par;
            info.mais(new TabelaLinha().setEstilo(par ? this.estiloLinhaPar : this.estiloLinhaImpar), pos++);
            for (int j = 0; j < aux2; ++j) {
                coluna = this.colunas.get(j);
                info.mais(new TabelaColuna(coluna.getEstiloColunaValor()), pos++);
                List<Dado> dados = coluna.getDados(elemento);
                info.mais(new Marcador("tqc_listagem_elemento_" + (i + 1) + "_i"), pos++);
                if (dados != null) {
                    int aux3 = dados.size();
                    for (int k = 0; k < aux3; ++k) {
                        info.mais(dados.get(k), pos++);
                    }
                } else {
                    Dado dado = coluna.getDado(elemento);
                    if (dado != null) {
                        info.mais(dado, pos++);
                    }
                }
                info.mais(new Marcador("tqc_listagem_elemento_" + (i + 1) + "_f"), pos++);
                info.mais(new TabelaColunaFim(), pos++);
            }
            info.mais(new TabelaLinhaFim(), pos++);
        }
        info.mais(new TabelaFim(), pos++);
    }

    @Override
    public void atualizar(Informacao info) throws TomaraQueCaiaException {
        if (this.colunas == null || this.lista == null) {
            throw new TomaraQueCaiaException();
        }
        int i = info.getIndice(this.marcadorInicial);
        int f = info.getIndice(this.marcadorFinal);
        if (i < 0 || f < 0) {
            throw new TomaraQueCaiaException();
        }
        info.menos(++i, --f);
        this.inserir(info, i);
    }

    @Override
    public void remover(Informacao info) {
        info.menos(this.marcadorInicial, this.marcadorFinal);
    }

    @Override
    public Marcador marcadorInicial() {
        return this.marcadorInicial;
    }

    @Override
    public Molde setMarcadorInicial(String nome) {
        this.marcadorInicial.setNome(nome);
        return this;
    }

    @Override
    public Marcador marcadorFinal() {
        return this.marcadorFinal;
    }

    @Override
    public Molde setMarcadorFinal(String nome) {
        this.marcadorFinal.setNome(nome);
        return this;
    }

    public List<ListaColuna<ELEMENTO>> getColunas() {
        return this.colunas;
    }

    public ListaMolde<ELEMENTO> setColunas(List<ListaColuna<ELEMENTO>> colunas) {
        this.colunas = colunas;
        return this;
    }

    public ListaMolde<ELEMENTO> setColunas(ListaColuna<ELEMENTO> ... colunas) {
        this.colunas = new ArrayList<ListaColuna<ELEMENTO>>(colunas.length);
        for (ListaColuna<ELEMENTO> col : colunas) {
            this.colunas.add(col);
        }
        return this;
    }

    public List<ELEMENTO> getLista() {
        return this.lista;
    }

    public ListaMolde<ELEMENTO> setLista(List<ELEMENTO> lista) {
        this.lista = new ArrayList<ELEMENTO>(lista);
        return this;
    }

    public String getEstiloLinhaImpar() {
        return this.estiloLinhaImpar;
    }

    public ListaMolde<ELEMENTO> setEstiloLinhaImpar(String estiloLinhaImpar) {
        this.estiloLinhaImpar = estiloLinhaImpar;
        return this;
    }

    public String getEstiloLinhaPar() {
        return this.estiloLinhaPar;
    }

    public ListaMolde<ELEMENTO> setEstiloLinhaPar(String estiloLinhaPar) {
        this.estiloLinhaPar = estiloLinhaPar;
        return this;
    }

    public ListaMolde<ELEMENTO> inverterEstiloLinha() {
        String tmp = this.estiloLinhaImpar;
        this.estiloLinhaImpar = this.estiloLinhaPar;
        this.estiloLinhaPar = tmp;
        return this;
    }

    public ListaMolde<ELEMENTO> setFiltro(ListaFiltro<ELEMENTO> filtro) {
        this.filtro = filtro;
        return this;
    }

    public ListaFiltro<ELEMENTO> getFiltro() {
        return this.filtro;
    }

    public ListaMolde<ELEMENTO> maisColuna(ListaColuna<ELEMENTO> coluna) {
        this.colunas.add(coluna);
        return this;
    }

    public ListaMolde<ELEMENTO> maisColunaTexto(Class<? extends Object> classe, String atributo) {
        return this.maisColuna(new ListaColunaTexto(classe, atributo));
    }

    public ListaMolde<ELEMENTO> maisColunaData(Class<? extends Object> classe, String atributo) {
        return this.maisColuna(new ListaColunaData(classe, atributo));
    }

    public ListaMolde<ELEMENTO> maisColunaInteiro(Class<? extends Object> classe, String atributo) {
        return this.maisColuna(new ListaColunaInteiro(classe, atributo));
    }

    public ListaMolde<ELEMENTO> maisColunaReal(Class<? extends Object> classe, String atributo) {
        return this.maisColuna(new ListaColunaReal(classe, atributo));
    }

    public ListaMolde<ELEMENTO> maisColunaBinario(Class<? extends Object> classe, String atributo, String valorVerdadeiro, String valorFalso) {
        return this.maisColuna(new ListaColunaBinario(classe, atributo, valorVerdadeiro, valorFalso));
    }

    public ListaMolde<ELEMENTO> maisColunaConversao(Class<? extends Object> classe, String atributo, Object[] lista, String original, String convertido) {
        return this.maisColuna(new ListaColunaConversao(classe, atributo, lista, original, convertido));
    }

    public static class ListaColunaConversao<ELEMENTO>
    extends ListaColunaModelo<ELEMENTO> {
        private Conversor conversor;

        public ListaColunaConversao(Class<? extends Object> classe, String atributo, Conversor conversor) {
            super(classe, atributo);
            this.conversor = conversor;
        }

        public ListaColunaConversao(Class<? extends Object> classe, String atributo, Object[] lista, String original, String convertido) {
            this(classe, atributo, new Conversor(lista, original, convertido));
        }

        @Override
        public Dado getDado(ELEMENTO elemento) {
            return new Texto(this.conversor.converter(this.assistente.invocarGet(elemento)).toString());
        }
    }

    public static class ListaColunaReal<ELEMENTO>
    extends ListaColunaModelo<ELEMENTO> {
        public ListaColunaReal(Class<? extends Object> classe, String atributo) {
            super(classe, atributo);
        }

        @Override
        public Dado getDado(ELEMENTO elemento) {
            return new Real(null, this.assistente.getClasse(), this.assistente.getAtributo(), ((Number)this.assistente.invocarGet(elemento)).doubleValue(), (Boolean)false);
        }
    }

    public static class ListaColunaBinario<ELEMENTO>
    extends ListaColunaModelo<ELEMENTO> {
        private String valorVerdadeiro;
        private String valorFalso;

        public ListaColunaBinario(Class<? extends Object> classe, String atributo, String valorVerdadeiro, String valorFalso) {
            super(classe, atributo);
            this.valorVerdadeiro = valorVerdadeiro;
            this.valorFalso = valorFalso;
        }

        @Override
        public Dado getDado(ELEMENTO elemento) {
            Object valor = this.assistente.invocarGet(elemento);
            if (valor == null) {
                return new Texto(this.valorFalso);
            }
            boolean retorno = false;
            retorno = ClassUtil.getInvolucro(valor.getClass()) == Boolean.class ? valor != null && (Boolean)valor != false : valor != null;
            return new Texto(retorno ? this.valorVerdadeiro : this.valorFalso);
        }
    }

    public static class ListaColunaInteiro<ELEMENTO>
    extends ListaColunaModelo<ELEMENTO> {
        public ListaColunaInteiro(Class<? extends Object> classe, String atributo) {
            super(classe, atributo);
        }

        @Override
        public Dado getDado(ELEMENTO elemento) {
            return new Inteiro(null, this.assistente.getClasse(), this.assistente.getAtributo(), ((Number)this.assistente.invocarGet(elemento)).longValue(), false);
        }
    }

    public static class ListaColunaData<ELEMENTO>
    extends ListaColunaModelo<ELEMENTO> {
        public ListaColunaData(Class<? extends Object> classe, String atributo) {
            super(classe, atributo);
        }

        @Override
        public Dado getDado(ELEMENTO elemento) {
            return new Data(null, this.assistente.getClasse(), this.assistente.getAtributo(), (Date)this.assistente.invocarGet(elemento), (Boolean)false);
        }
    }

    public static class ListaColunaTexto<ELEMENTO>
    extends ListaColunaModelo<ELEMENTO> {
        public ListaColunaTexto(Class<? extends Object> classe, String atributo) {
            super(classe, atributo);
        }

        @Override
        public Dado getDado(ELEMENTO elemento) {
            Object resultado = this.assistente.invocarGet(elemento);
            return new Texto(resultado != null ? resultado.toString() : "");
        }
    }

    public static abstract class ListaColunaModelo<ELEMENTO>
    extends ListaColunaPadrao<ELEMENTO> {
        protected AssistenteDeAtributo assistente;
        private String titulo;

        public ListaColunaModelo(Class<? extends Object> classe, String atributo) {
            this.assistente = new AssistenteDeAtributo(classe, atributo);
            this.titulo = this.assistente.getJFApresentacao(true).value();
        }

        @Override
        public String getTitulo() {
            return this.titulo;
        }
    }

    public static abstract class ListaColunaPadrao<ELEMENTO>
    implements ListaColuna<ELEMENTO> {
        @Override
        public String getEstiloTitulo() {
            return "listaTitulo";
        }

        @Override
        public String getEstiloColunaTitulo() {
            return "listaColunaTitulo";
        }

        @Override
        public String getEstiloColunaValor() {
            return "listaColunaValor";
        }

        @Override
        public Dado getDado(ELEMENTO elemento) {
            return null;
        }

        @Override
        public List<Dado> getDados(ELEMENTO elemento) {
            return null;
        }
    }

    public static interface ListaColuna<ELEMENTO> {
        public String getTitulo();

        public String getEstiloTitulo();

        public String getEstiloColunaTitulo();

        public String getEstiloColunaValor();

        public Dado getDado(ELEMENTO var1);

        public List<Dado> getDados(ELEMENTO var1);
    }

    public static interface ListaFiltro<ELEMENTO> {
        public boolean filtrar(ELEMENTO var1);
    }
}

