/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.modelo.JFTexto;
import com.joseflavio.modelo.JFValidacaoNaoVazio;
import com.joseflavio.modelo.JFValidacaoTamanhoLimite;
import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.VistaTextual;
import com.joseflavio.validacao.NaoNuloValidacao;
import com.joseflavio.validacao.NaoVazioValidacao;
import com.joseflavio.validacao.TextoLimite;
import com.joseflavio.validacao.ValidacaoException;
import java.lang.reflect.Field;

public class Texto
extends ComplexoDado
implements VistaTextual {
    private String texto;
    private int larguraTextual;
    private int alturaTextual = 1;
    private boolean multiplaLinha = false;
    private boolean quebraDeLinhaAutomatica = false;

    public Texto(String nome, String texto, int larguraTextual, int alturaTextual, boolean multiplaLinha, boolean editavel) {
        super(nome, editavel);
        this.texto = texto;
        this.larguraTextual = larguraTextual;
        this.alturaTextual = alturaTextual;
        this.multiplaLinha = multiplaLinha;
    }

    public Texto(String nome, String texto, int larguraTextual, boolean editavel) {
        this(nome, texto, larguraTextual, 1, false, editavel);
    }

    public Texto(String nome, String texto) {
        this(nome, texto, 0, 1, false, false);
    }

    public Texto(String texto) {
        this(null, texto, 0, 0, true, false);
    }

    public Texto(String nome, Class<? extends Object> classe, String atributo, String texto, Boolean editavel) {
        super(nome);
        this.configurarPor(classe, atributo);
        this.texto = texto;
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public Texto(String nome, Class<? extends Object> classe, String texto, Boolean editavel) {
        this(nome, classe, nome, texto, editavel);
    }

    @Override
    public Object getConteudo() {
        return this.texto;
    }

    public Texto setTexto(String texto) {
        this.texto = texto;
        return this;
    }

    public String getTextoValidado() throws ValidacaoException {
        this.validar();
        return this.texto;
    }

    public String getTexto() {
        return this.texto;
    }

    @Override
    public int getAlturaTextual() {
        return this.alturaTextual;
    }

    @Override
    public Dado setAlturaTextual(int linhas) {
        this.alturaTextual = linhas;
        return this;
    }

    @Override
    public int getLarguraTextual() {
        return this.larguraTextual;
    }

    @Override
    public Dado setLarguraTextual(int caracs) {
        this.larguraTextual = caracs;
        return this;
    }

    @Override
    public boolean isMultiplaLinha() {
        return this.multiplaLinha;
    }

    public void setQuebraDeLinhaAutomatica(boolean quebraDeLinhaAutomatica) {
        this.quebraDeLinhaAutomatica = quebraDeLinhaAutomatica;
    }

    public boolean isQuebraDeLinhaAutomatica() {
        return this.quebraDeLinhaAutomatica;
    }

    @Override
    public boolean isVazio() {
        return this.getConteudoInvalido() == null && (this.texto == null || this.texto.length() == 0);
    }

    public Texto maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public Texto maisTextoLimite(int maxCaracteres, int tipo, String mensagem) {
        this.mais(new TextoLimite(this.getNome(), maxCaracteres, tipo, mensagem));
        return this;
    }

    public Texto maisTextoLimite(int maxCaracteres, String mensagem) {
        return this.maisTextoLimite(maxCaracteres, 3, mensagem);
    }

    public Texto maisNaoVazio(int tipo, String mensagem) {
        this.mais(new NaoVazioValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Texto maisNaoVazio(String mensagem) {
        return this.maisNaoVazio(3, mensagem);
    }

    public Texto maisNaoNulo(int tipo, String mensagem) {
        this.mais(new NaoNuloValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Texto maisNaoNulo(String mensagem) {
        return this.maisNaoNulo(3, mensagem);
    }

    @Override
    protected Dado configurarPor(Field atributo) {
        super.configurarPor(atributo);
        JFTexto jfTexto = atributo.getAnnotation(JFTexto.class);
        JFValidacaoNaoVazio jfValidacaoNaoVazio = atributo.getAnnotation(JFValidacaoNaoVazio.class);
        JFValidacaoTamanhoLimite jfValidacaoTamanhoLimite = atributo.getAnnotation(JFValidacaoTamanhoLimite.class);
        if (jfTexto == null) {
            throw new IllegalArgumentException("O atributo " + atributo.getType().getSimpleName() + "." + atributo.getName() + " n\u00e3o cont\u00e9m " + JFTexto.class.getName());
        }
        this.larguraTextual = jfTexto.largura();
        this.alturaTextual = jfTexto.altura();
        this.multiplaLinha = jfTexto.variasLinhas();
        this.quebraDeLinhaAutomatica = jfTexto.quebraDeLinhaAutomatica();
        if (jfValidacaoNaoVazio != null) {
            this.maisNaoVazio(jfValidacaoNaoVazio.erro());
        }
        if (jfValidacaoTamanhoLimite != null) {
            this.maisTextoLimite(jfTexto.max(), jfValidacaoTamanhoLimite.erro());
        }
        return this;
    }
}

