/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.modelo.JFTexto;
import com.joseflavio.modelo.JFValidacaoNaoVazio;
import com.joseflavio.modelo.JFValidacaoTamanhoLimite;
import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.VistaTextual;
import com.joseflavio.validacao.NaoNuloValidacao;
import com.joseflavio.validacao.NaoVazioValidacao;
import com.joseflavio.validacao.TextoLimite;
import com.joseflavio.validacao.ValidacaoException;
import java.lang.reflect.Field;

public class Senha
extends ComplexoDado
implements VistaTextual {
    private String senha;
    private int larguraTextual;

    public Senha(String nome, String senha, int larguraTextual, boolean editavel) {
        super(nome, editavel);
        this.senha = senha;
        this.larguraTextual = larguraTextual;
    }

    public Senha(String senha) {
        this(null, senha, 0, false);
    }

    public Senha(String nome, Class<? extends Object> classe, String atributo, String senha, Boolean editavel) {
        super(nome);
        this.configurarPor(classe, atributo);
        this.senha = senha;
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public Senha(String nome, Class<? extends Object> classe, String senha, Boolean editavel) {
        this(nome, classe, nome, senha, editavel);
    }

    @Override
    public Object getConteudo() {
        return this.senha;
    }

    public Senha setSenha(String senha) {
        this.senha = senha;
        return this;
    }

    public String getSenhaValidada() throws ValidacaoException {
        this.validar();
        return this.senha;
    }

    public String getSenha() {
        return this.senha;
    }

    @Override
    public int getAlturaTextual() {
        return 1;
    }

    @Override
    public Dado setAlturaTextual(int linhas) {
        return this;
    }

    @Override
    public int getLarguraTextual() {
        return this.larguraTextual;
    }

    @Override
    public Dado setLarguraTextual(int caracs) {
        this.larguraTextual = caracs;
        return this;
    }

    @Override
    public boolean isMultiplaLinha() {
        return false;
    }

    @Override
    public boolean isVazio() {
        return this.getConteudoInvalido() == null && (this.senha == null || this.senha.length() == 0);
    }

    public Senha maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public Senha maisTextoLimite(int maxCaracteres, int tipo, String mensagem) {
        this.mais(new TextoLimite(this.getNome(), maxCaracteres, tipo, mensagem));
        return this;
    }

    public Senha maisTextoLimite(int maxCaracteres, String mensagem) {
        return this.maisTextoLimite(maxCaracteres, 3, mensagem);
    }

    public Senha maisNaoVazio(int tipo, String mensagem) {
        this.mais(new NaoVazioValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Senha maisNaoVazio(String mensagem) {
        return this.maisNaoVazio(3, mensagem);
    }

    public Senha maisNaoNulo(int tipo, String mensagem) {
        this.mais(new NaoNuloValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Senha maisNaoNulo(String mensagem) {
        return this.maisNaoNulo(3, mensagem);
    }

    @Override
    protected Dado configurarPor(Field atributo) {
        super.configurarPor(atributo);
        JFTexto jfTexto = atributo.getAnnotation(JFTexto.class);
        JFValidacaoNaoVazio jfValidacaoNaoVazio = atributo.getAnnotation(JFValidacaoNaoVazio.class);
        JFValidacaoTamanhoLimite jfValidacaoTamanhoLimite = atributo.getAnnotation(JFValidacaoTamanhoLimite.class);
        if (jfTexto == null) {
            throw new IllegalArgumentException("O atributo " + atributo.getType().getSimpleName() + "." + atributo.getName() + " n\u00e3o cont\u00e9m " + JFTexto.class.getName());
        }
        this.larguraTextual = jfTexto.largura();
        if (jfValidacaoNaoVazio != null) {
            this.maisNaoVazio(jfValidacaoNaoVazio.erro());
        }
        if (jfValidacaoTamanhoLimite != null) {
            this.maisTextoLimite(jfTexto.max(), jfValidacaoTamanhoLimite.erro());
        }
        return this;
    }
}

