/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.cultura.Transformacao;
import com.joseflavio.modelo.JFTexto;
import com.joseflavio.modelo.JFValidacaoNaoVazio;
import com.joseflavio.modelo.JFValidacaoTamanhoLimite;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.VistaTextual;
import com.joseflavio.tqc.dado.Opcoes;
import com.joseflavio.util.Lista;
import com.joseflavio.validacao.NaoNuloValidacao;
import com.joseflavio.validacao.NaoVazioValidacao;
import com.joseflavio.validacao.TextoLimite;
import com.joseflavio.validacao.TransformacaoValidacao;
import com.joseflavio.validacao.ValidacaoException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

public class SelecionavelTexto
extends Opcoes<String>
implements VistaTextual {
    private String texto;
    private int larguraTextual;
    private List<String> opcoes;

    public SelecionavelTexto(String nome, String texto, int larguraTextual, List<String> opcoes, boolean editavel) {
        super(nome, editavel);
        this.texto = texto;
        this.larguraTextual = larguraTextual;
        this.opcoes = opcoes != null ? opcoes : new Lista();
    }

    public SelecionavelTexto(String nome, String texto, int larguraTextual, String[] opcoes, boolean editavel) {
        this(nome, texto, larguraTextual, new Lista<String>(opcoes), editavel);
    }

    public SelecionavelTexto(String nome, Class<? extends Object> classe, String atributo, String texto, List<String> opcoes, Boolean editavel) {
        super(nome);
        this.texto = texto;
        this.opcoes = opcoes != null ? opcoes : new Lista();
        this.configurarPor(classe, atributo);
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public SelecionavelTexto(String nome, Class<? extends Object> classe, String texto, List<String> opcoes, Boolean editavel) {
        this(nome, classe, nome, texto, opcoes, editavel);
    }

    public SelecionavelTexto(String nome, Class<? extends Object> classe, String texto, String[] opcoes, Boolean editavel) {
        this(nome, classe, nome, texto, new Lista<String>(opcoes), editavel);
    }

    public SelecionavelTexto setOpcoes(List<String> opcoes) {
        this.opcoes = opcoes != null ? opcoes : new Lista();
        return this;
    }

    public SelecionavelTexto setOpcoes(String cabeca, String ... cauda) {
        return this.setOpcoes((List)new Lista<String>(cabeca, cauda));
    }

    public SelecionavelTexto setOpcoes(String cabeca, List<String> cauda) {
        return this.setOpcoes((List)new Lista<String>(cabeca, (Collection<String>)cauda));
    }

    @Override
    public List<String> getOpcoes() {
        return this.opcoes;
    }

    @Override
    public int getTotalOpcoes() {
        return this.opcoes.size();
    }

    @Override
    public String getOpcao(int indice) {
        return this.opcoes.get(indice);
    }

    @Override
    public Object getConteudo() {
        return this.texto;
    }

    public SelecionavelTexto setTexto(String texto) {
        this.texto = texto;
        return this;
    }

    public String getTextoValidado() throws ValidacaoException {
        this.validar();
        return this.texto;
    }

    public String getTexto() {
        return this.texto;
    }

    @Override
    public int getAlturaTextual() {
        return 1;
    }

    @Override
    public Dado setAlturaTextual(int linhas) {
        return this;
    }

    @Override
    public int getLarguraTextual() {
        return this.larguraTextual;
    }

    @Override
    public Dado setLarguraTextual(int caracs) {
        this.larguraTextual = caracs;
        return this;
    }

    @Override
    public boolean isMultiplaLinha() {
        return false;
    }

    public SelecionavelTexto maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public SelecionavelTexto maisTextoLimite(int maxCaracteres, int tipo, String mensagem) {
        this.mais(new TextoLimite(this.getNome(), maxCaracteres, tipo, mensagem));
        return this;
    }

    public SelecionavelTexto maisTextoLimite(int maxCaracteres, String mensagem) {
        return this.maisTextoLimite(maxCaracteres, 3, mensagem);
    }

    public SelecionavelTexto maisNaoVazio(int tipo, String mensagem) {
        this.mais(new NaoVazioValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public SelecionavelTexto maisNaoVazio(String mensagem) {
        return this.maisNaoVazio(3, mensagem);
    }

    public SelecionavelTexto maisNaoNulo(int tipo, String mensagem) {
        this.mais(new NaoNuloValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public SelecionavelTexto maisNaoNulo(String mensagem) {
        return this.maisNaoNulo(3, mensagem);
    }

    public SelecionavelTexto maisTransformacao(Transformacao transformacao, int tipo, String mensagem) {
        this.mais(new TransformacaoValidacao(this.getNome(), transformacao, tipo, mensagem));
        return this;
    }

    public SelecionavelTexto maisTransformacao(Transformacao transformacao, String mensagem) {
        return this.maisTransformacao(transformacao, 3, mensagem);
    }

    @Override
    protected Dado configurarPor(Field atributo) {
        super.configurarPor(atributo);
        JFTexto jfTexto = atributo.getAnnotation(JFTexto.class);
        JFValidacaoNaoVazio jfValidacaoNaoVazio = atributo.getAnnotation(JFValidacaoNaoVazio.class);
        JFValidacaoTamanhoLimite jfValidacaoTamanhoLimite = atributo.getAnnotation(JFValidacaoTamanhoLimite.class);
        if (jfTexto == null) {
            throw new IllegalArgumentException("O atributo " + atributo.getType().getSimpleName() + "." + atributo.getName() + " n\u00e3o cont\u00e9m " + JFTexto.class.getName());
        }
        this.larguraTextual = jfTexto.largura();
        if (jfValidacaoNaoVazio != null) {
            this.maisNaoVazio(jfValidacaoNaoVazio.erro());
        }
        if (jfValidacaoTamanhoLimite != null) {
            this.maisTextoLimite(jfTexto.max(), jfValidacaoTamanhoLimite.erro());
        }
        return this;
    }
}

