/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.modelo.JFValidacaoNaoVazio;
import com.joseflavio.tqc.Aparencia;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.dado.Opcoes;
import com.joseflavio.util.Lista;
import com.joseflavio.validacao.NaoVazioValidacao;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;

public class SelecaoMultipla<T>
extends Opcoes<T> {
    private List<T> opcoes;
    private List<T> selecionados;
    private Aparencia<T> aparencia;
    private boolean disposicaoHorizontal = false;
    private transient boolean selecionadosValidados = false;

    public SelecaoMultipla(String nome, List<T> opcoes, boolean editavel) {
        super(nome, editavel);
        this.setOpcoes((List)opcoes);
        this.setSelecionados(null);
    }

    public SelecaoMultipla(String nome, T[] opcoes, boolean editavel) {
        this(nome, new Lista<T>(opcoes), editavel);
    }

    public SelecaoMultipla(String nome, List<T> opcoes) {
        this(nome, opcoes, true);
    }

    public SelecaoMultipla(String nome, T[] opcoes) {
        this(nome, new Lista<T>(opcoes));
    }

    public SelecaoMultipla(List<T> opcoes) {
        this(null, opcoes, true);
    }

    public SelecaoMultipla(T[] opcoes) {
        this(new Lista<T>(opcoes));
    }

    public SelecaoMultipla(String nome, List<T> opcoes, List<T> selecaoInicial, boolean editavel) {
        this(nome, opcoes, editavel);
        this.setSelecionados(selecaoInicial);
    }

    public SelecaoMultipla(String nome, List<T> opcoes, List<T> selecaoInicial) {
        this(nome, opcoes, selecaoInicial, true);
    }

    public SelecaoMultipla(String nome, T[] opcoes, List<T> selecaoInicial) {
        this(nome, new Lista<T>(opcoes), selecaoInicial);
    }

    public SelecaoMultipla(String nome, T[] opcoes, List<T> selecaoInicial, boolean editavel) {
        this(nome, new Lista<T>(opcoes), selecaoInicial, editavel);
    }

    public SelecaoMultipla(String nome, Class<? extends Object> classe, String atributo, List<T> opcoes, List<T> selecaoInicial, Boolean editavel) {
        super(nome);
        this.setOpcoes((List)opcoes);
        this.setSelecionados(selecaoInicial);
        this.configurarPor(classe, atributo);
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public SelecaoMultipla(String nome, Class<? extends Object> classe, List<T> opcoes, List<T> selecaoInicial, Boolean editavel) {
        this(nome, classe, nome, opcoes, selecaoInicial, editavel);
    }

    public SelecaoMultipla(String nome, Class<? extends Object> classe, T[] opcoes, List<T> selecaoInicial, Boolean editavel) {
        this(nome, classe, nome, new Lista<T>(opcoes), selecaoInicial, editavel);
    }

    public SelecaoMultipla(String nome, Class<? extends Object> classe, String atributo, List<T> opcoes, Boolean editavel) {
        this(nome, classe, atributo, opcoes, null, editavel);
    }

    public SelecaoMultipla(String nome, Class<? extends Object> classe, List<T> opcoes, Boolean editavel) {
        this(nome, classe, nome, opcoes, null, editavel);
    }

    public SelecaoMultipla(String nome, Class<? extends Object> classe, T[] opcoes, Boolean editavel) {
        this(nome, classe, nome, new Lista<T>(opcoes), null, editavel);
    }

    @Override
    public Object getConteudo() {
        return this.getSelecionados();
    }

    public List<T> getSelecionados() {
        if (!this.selecionadosValidados) {
            this.validarSelecionados();
        }
        return this.selecionados;
    }

    public void setSelecionados(List<T> selecionados) {
        this.selecionados = selecionados != null ? selecionados : new Lista();
        this.selecionadosValidados = false;
    }

    private void validarSelecionados() {
        Iterator<T> i = this.selecionados.iterator();
        while (i.hasNext()) {
            T t = i.next();
            if (this.opcoes.contains(t)) continue;
            i.remove();
        }
        this.selecionadosValidados = true;
    }

    public boolean isSelecionado(int indice) {
        return this.getSelecionados().contains(this.opcoes.get(indice));
    }

    @Override
    public SelecaoMultipla<T> setOpcoes(List<T> opcoes) {
        this.opcoes = opcoes != null ? opcoes : new Lista();
        this.selecionadosValidados = false;
        return this;
    }

    @Override
    public SelecaoMultipla<T> setOpcoes(T cabeca, T ... cauda) {
        return this.setOpcoes((List)new Lista<T>(cabeca, cauda));
    }

    @Override
    public SelecaoMultipla<T> setOpcoes(T cabeca, List<T> cauda) {
        return this.setOpcoes((List)new Lista<T>(cabeca, cauda));
    }

    @Override
    public List<T> getOpcoes() {
        return this.opcoes;
    }

    @Override
    public int getTotalOpcoes() {
        return this.opcoes.size();
    }

    @Override
    public T getOpcao(int indice) {
        return this.opcoes.get(indice);
    }

    public String getTexto(int indice) {
        T obj = this.opcoes.get(indice);
        return this.aparencia != null ? this.aparencia.texto(obj) : (obj != null ? obj.toString() : "");
    }

    public String getImagem(int indice) {
        return this.aparencia != null ? this.aparencia.imagem(this.opcoes.get(indice)) : null;
    }

    public Aparencia<T> getAparencia() {
        return this.aparencia;
    }

    public SelecaoMultipla<T> setAparencia(Aparencia<T> aparencia) {
        this.aparencia = aparencia;
        return this;
    }

    public void setDisposicaoHorizontal(boolean disposicaoHorizontal) {
        this.disposicaoHorizontal = disposicaoHorizontal;
    }

    public boolean isDisposicaoHorizontal() {
        return this.disposicaoHorizontal;
    }

    public SelecaoMultipla<T> maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public SelecaoMultipla<T> maisNaoVazio(int tipo, String mensagem) {
        this.mais(new NaoVazioValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public SelecaoMultipla<T> maisNaoVazio(String mensagem) {
        return this.maisNaoVazio(3, mensagem);
    }

    @Override
    protected Dado configurarPor(Field atributo) {
        super.configurarPor(atributo);
        JFValidacaoNaoVazio jfValidacaoNaoVazio = atributo.getAnnotation(JFValidacaoNaoVazio.class);
        if (jfValidacaoNaoVazio != null) {
            this.maisNaoVazio(jfValidacaoNaoVazio.erro());
        }
        return this;
    }
}

