/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.tqc.Aparencia;
import com.joseflavio.tqc.dado.Opcoes;
import com.joseflavio.util.Lista;
import com.joseflavio.validacao.NaoNuloValidacao;
import java.util.List;

public class Selecao<T>
extends Opcoes<T> {
    private static final int SEL_NULO = -1;
    private static final int SEL_INDEFINIDO = -2;
    private List<T> opcoes;
    private T selecionado;
    private int selecionadoIndice = -2;
    private Aparencia<T> aparencia;

    public Selecao(String nome, List<T> opcoes, boolean editavel) {
        super(nome, editavel);
        this.opcoes = opcoes != null ? opcoes : new Lista();
    }

    public Selecao(String nome, T[] opcoes, boolean editavel) {
        this(nome, (List<boolean>)new Lista<T>(opcoes), editavel);
    }

    public Selecao(String nome, List<T> opcoes) {
        this(nome, (List<boolean>)opcoes, true);
    }

    public Selecao(String nome, T[] opcoes) {
        this(nome, new Lista<T>(opcoes));
    }

    public Selecao(List<T> opcoes) {
        this((String)null, (List<boolean>)opcoes, true);
    }

    public Selecao(T[] opcoes) {
        this(new Lista<T>(opcoes));
    }

    public Selecao(String nome, List<T> opcoes, T selecaoInicial) {
        this(nome, opcoes, selecaoInicial, true);
    }

    public Selecao(String nome, T[] opcoes, T selecaoInicial) {
        this(nome, new Lista<T>(opcoes), selecaoInicial);
    }

    public Selecao(String nome, List<T> opcoes, T selecaoInicial, boolean editavel) {
        this(nome, (List<boolean>)opcoes, editavel);
        this.setIndiceSelecionado(opcoes.indexOf(selecaoInicial));
    }

    public Selecao(String nome, T[] opcoes, T selecaoInicial, boolean editavel) {
        this(nome, new Lista<T>(opcoes), selecaoInicial, editavel);
    }

    public Selecao(String nome, Class<? extends Object> classe, String atributo, List<T> opcoes, T selecaoInicial, Boolean editavel) {
        super(nome);
        this.opcoes = opcoes != null ? opcoes : new Lista();
        this.selecionado = selecaoInicial;
        this.configurarPor(classe, atributo);
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public Selecao(String nome, Class<? extends Object> classe, List<T> opcoes, T selecaoInicial, Boolean editavel) {
        this(nome, classe, nome, opcoes, selecaoInicial, editavel);
    }

    public Selecao(String nome, Class<? extends Object> classe, T[] opcoes, T selecaoInicial, Boolean editavel) {
        this(nome, classe, nome, new Lista<T>(opcoes), selecaoInicial, editavel);
    }

    public Selecao(String nome, Class<? extends Object> classe, String atributo, List<T> opcoes, Boolean editavel) {
        this(nome, classe, atributo, opcoes, null, editavel);
    }

    public Selecao(String nome, Class<? extends Object> classe, List<T> opcoes, Boolean editavel) {
        this(nome, classe, nome, opcoes, null, editavel);
    }

    public Selecao(String nome, Class<? extends Object> classe, T[] opcoes, Boolean editavel) {
        this(nome, classe, nome, new Lista<T>(opcoes), null, editavel);
    }

    @Override
    public Object getConteudo() {
        return this.getSelecionado();
    }

    public T getSelecionado() {
        if (this.selecionadoIndice == -2) {
            this.getIndiceSelecionado();
        }
        return this.selecionado;
    }

    public void setSelecionado(T selecionado) {
        this.selecionado = selecionado;
        this.selecionadoIndice = -2;
    }

    public int getIndiceSelecionado() {
        if (this.selecionado == null) {
            this.selecionadoIndice = -1;
            return -1;
        }
        if (this.selecionadoIndice == -2) {
            this.selecionadoIndice = this.opcoes.indexOf(this.selecionado);
            if (this.selecionadoIndice == -1) {
                this.selecionado = null;
            }
        }
        return this.selecionadoIndice;
    }

    public Selecao<T> setIndiceSelecionado(int indice) {
        if (indice < -1 || indice >= this.opcoes.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.selecionado = indice != -1 ? this.opcoes.get(indice) : null;
        this.selecionadoIndice = indice;
        return this;
    }

    @Override
    public Selecao<T> setOpcoes(List<T> opcoes) {
        this.opcoes = opcoes != null ? opcoes : new Lista();
        this.setSelecionado(this.selecionado);
        return this;
    }

    @Override
    public Selecao<T> setOpcoes(T cabeca, T ... cauda) {
        return this.setOpcoes((List)new Lista<T>(cabeca, cauda));
    }

    @Override
    public Selecao<T> setOpcoes(T cabeca, List<T> cauda) {
        return this.setOpcoes((List)new Lista<T>(cabeca, cauda));
    }

    @Override
    public List<T> getOpcoes() {
        return this.opcoes;
    }

    @Override
    public int getTotalOpcoes() {
        return this.opcoes.size();
    }

    @Override
    public T getOpcao(int indice) {
        if (indice == this.selecionadoIndice) {
            return this.selecionado;
        }
        return this.opcoes.get(indice);
    }

    public String getTexto(int indice) {
        T obj;
        T t = obj = indice == this.selecionadoIndice ? this.selecionado : this.opcoes.get(indice);
        return this.aparencia != null ? this.aparencia.texto(obj) : (obj != null ? obj.toString() : "");
    }

    public String getImagem(int indice) {
        return this.aparencia != null ? this.aparencia.imagem(indice == this.selecionadoIndice ? this.selecionado : this.opcoes.get(indice)) : null;
    }

    public Aparencia<T> getAparencia() {
        return this.aparencia;
    }

    public Selecao<T> setAparencia(Aparencia<T> aparencia) {
        this.aparencia = aparencia;
        return this;
    }

    public Selecao<T> maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public Selecao<T> maisNaoNulo(int tipo, String mensagem) {
        this.mais(new NaoNuloValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Selecao<T> maisNaoNulo(String mensagem) {
        return this.maisNaoNulo(3, mensagem);
    }
}

