/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.modelo.JFReal;
import com.joseflavio.modelo.JFTexto;
import com.joseflavio.modelo.JFValidacaoTamanhoLimite;
import com.joseflavio.modelo.JFValidacaoValorLimite;
import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.VistaTextual;
import com.joseflavio.validacao.NaoNuloValidacao;
import com.joseflavio.validacao.RealLimiteValidacao;
import com.joseflavio.validacao.TextoLimite;
import com.joseflavio.validacao.ValidacaoException;
import java.lang.reflect.Field;

public class Real
extends ComplexoDado
implements VistaTextual {
    private Double numero;
    private int larguraTextual;
    private int digitosNaFracao;

    public Real(String nome, Double numero, int digitosNaFracao, int larguraTextual, boolean editavel) {
        super(nome, editavel);
        this.numero = numero;
        this.digitosNaFracao = digitosNaFracao;
        this.larguraTextual = larguraTextual;
    }

    public Real(String nome, double numero, int digitosNaFracao, int larguraTextual, boolean editavel) {
        this(nome, new Double(numero), digitosNaFracao, larguraTextual, editavel);
    }

    public Real(String nome, Double numero, int larguraTextual, boolean editavel) {
        this(nome, numero, -1, larguraTextual, editavel);
    }

    public Real(String nome, double numero, int larguraTextual, boolean editavel) {
        this(nome, new Double(numero), -1, larguraTextual, editavel);
    }

    public Real(double numero) {
        this((String)null, new Double(numero), -1, 0, false);
    }

    public Real(String nome, Class<? extends Object> classe, String atributo, Double numero, Boolean editavel) {
        super(nome);
        this.configurarPor(classe, atributo);
        this.numero = numero;
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public Real(String nome, Class<? extends Object> classe, Double numero, Boolean editavel) {
        this(nome, classe, nome, numero, editavel);
    }

    @Override
    public Object getConteudo() {
        return this.numero;
    }

    public Real setNumero(Double numero) {
        this.numero = numero;
        return this;
    }

    public Real setNumero(double numero) {
        this.numero = new Double(numero);
        return this;
    }

    public Double getNumeroValidado() throws ValidacaoException {
        this.validar();
        return this.numero;
    }

    public Double getNumero() {
        return this.numero;
    }

    @Override
    public int getAlturaTextual() {
        return 1;
    }

    @Override
    public Dado setAlturaTextual(int linhas) {
        return this;
    }

    @Override
    public int getLarguraTextual() {
        return this.larguraTextual;
    }

    @Override
    public Dado setLarguraTextual(int caracs) {
        this.larguraTextual = caracs;
        return this;
    }

    @Override
    public boolean isMultiplaLinha() {
        return false;
    }

    public int getDigitosNaFracao() {
        return this.digitosNaFracao;
    }

    public Real setDigitosNaFracao(int digitosNaFracao) {
        this.digitosNaFracao = digitosNaFracao;
        return this;
    }

    public Real maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public Real maisTextoLimite(int maxCaracteres, int tipo, String mensagem) {
        this.mais(new TextoLimite(this.getNome(), maxCaracteres, tipo, mensagem));
        return this;
    }

    public Real maisTextoLimite(int maxCaracteres, String mensagem) {
        return this.maisTextoLimite(maxCaracteres, 3, mensagem);
    }

    public Real maisNaoNulo(int tipo, String mensagem) {
        this.mais(new NaoNuloValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Real maisNaoNulo(String mensagem) {
        return this.maisNaoNulo(3, mensagem);
    }

    public Real maisRealLimite(double min, double max, int tipo, String mensagem) {
        this.mais(new RealLimiteValidacao(this.getNome(), min, max, tipo, mensagem));
        return this;
    }

    public Real maisRealLimite(double min, double max, String mensagem) {
        return this.maisRealLimite(min, max, 3, mensagem);
    }

    @Override
    protected Dado configurarPor(Field atributo) {
        super.configurarPor(atributo);
        JFReal jfReal = atributo.getAnnotation(JFReal.class);
        JFTexto jfTexto = atributo.getAnnotation(JFTexto.class);
        JFValidacaoValorLimite jfValidacaoValorLimite = atributo.getAnnotation(JFValidacaoValorLimite.class);
        JFValidacaoTamanhoLimite jfValidacaoTamanhoLimite = atributo.getAnnotation(JFValidacaoTamanhoLimite.class);
        if (jfReal == null) {
            throw new IllegalArgumentException("O atributo " + atributo.getType().getSimpleName() + "." + atributo.getName() + " n\u00e3o cont\u00e9m " + JFReal.class.getName());
        }
        this.digitosNaFracao = jfReal.maxFracao();
        if (jfTexto != null) {
            this.larguraTextual = jfTexto.largura();
            if (jfValidacaoTamanhoLimite != null) {
                this.maisTextoLimite(jfTexto.max(), jfValidacaoTamanhoLimite.erro());
            }
        }
        if (jfValidacaoValorLimite != null) {
            this.maisRealLimite(jfReal.min(), jfReal.max(), jfValidacaoValorLimite.erro());
        }
        return this;
    }
}

