/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.anotacao.TQCOpcoes;
import com.joseflavio.util.ClassUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class Opcoes<T>
extends ComplexoDado {
    private GeradorDeOpcoes<T> geradorDeOpcoes;
    private Method tqcOpcoes;

    public Opcoes(String nome, boolean editavel) {
        super(nome, editavel);
    }

    public Opcoes(String nome) {
        super(nome);
    }

    public abstract Opcoes<T> setOpcoes(List<T> var1);

    public abstract Opcoes<T> setOpcoes(T var1, T ... var2);

    public abstract Opcoes<T> setOpcoes(T var1, List<T> var2);

    public abstract List<T> getOpcoes();

    public abstract int getTotalOpcoes();

    public abstract T getOpcao(int var1);

    public void setGeradorDeOpcoes(GeradorDeOpcoes<T> geradorDeOpcoes) {
        this.geradorDeOpcoes = geradorDeOpcoes;
    }

    public GeradorDeOpcoes<T> getGeradorDeOpcoes() {
        return this.geradorDeOpcoes;
    }

    public final Opcoes<T> atualizarOpcoes() throws IllegalAccessException, InvocationTargetException {
        GeradorDeOpcoes<T> go = this.getGeradorDeOpcoes();
        if (go != null) {
            return this.setOpcoes(go.gerar());
        }
        if (this.tqcOpcoes == null) {
            return this;
        }
        Object lista = this.tqcOpcoes.invoke((Object)this.getInformacao(), new Object[0]);
        if (lista != null && !(lista instanceof List)) {
            throw new IllegalAccessException("TQCOpcoes incompat\u00edvel.");
        }
        return this.setOpcoes((List)lista);
    }

    @Override
    public void setInformacao(Informacao informacao) {
        super.setInformacao(informacao);
        if (informacao == null) {
            this.tqcOpcoes = null;
            return;
        }
        String nome = this.getNome();
        if (nome == null) {
            return;
        }
        for (Method m : ClassUtil.listarMetodos(informacao.getClass())) {
            String dado;
            TQCOpcoes anotacao = m.getAnnotation(TQCOpcoes.class);
            if (anotacao == null || (dado = anotacao.dado()) == null || !dado.equals(nome)) continue;
            this.tqcOpcoes = m;
            break;
        }
        try {
            this.atualizarOpcoes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface GeradorDeOpcoes<T> {
        public List<T> gerar();
    }
}

