/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.modelo.JFInteiro;
import com.joseflavio.modelo.JFTexto;
import com.joseflavio.modelo.JFValidacaoTamanhoLimite;
import com.joseflavio.modelo.JFValidacaoValorLimite;
import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.VistaTextual;
import com.joseflavio.validacao.InteiroLimiteValidacao;
import com.joseflavio.validacao.NaoNuloValidacao;
import com.joseflavio.validacao.TextoLimite;
import com.joseflavio.validacao.ValidacaoException;
import java.lang.reflect.Field;

public class Inteiro
extends ComplexoDado
implements VistaTextual {
    private Long numero;
    private int larguraTextual;

    public Inteiro(String nome, Long numero, int larguraTextual, boolean editavel) {
        super(nome, editavel);
        this.numero = numero;
        this.larguraTextual = larguraTextual;
    }

    public Inteiro(String nome, long numero, int larguraTextual, boolean editavel) {
        this(nome, new Long(numero), larguraTextual, editavel);
    }

    public Inteiro(String nome, Class<? extends Object> classe, String atributo, Long numero, Boolean editavel) {
        super(nome);
        this.configurarPor(classe, atributo);
        this.numero = numero;
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public Inteiro(String nome, Class<? extends Object> classe, Long numero, Boolean editavel) {
        this(nome, classe, nome, numero, editavel);
    }

    @Override
    public Object getConteudo() {
        return this.numero;
    }

    public Inteiro setNumero(Long numero) {
        this.numero = numero;
        return this;
    }

    public Inteiro setNumero(long numero) {
        this.numero = new Long(numero);
        return this;
    }

    public Long getNumeroValidado() throws ValidacaoException {
        this.validar();
        return this.numero;
    }

    public Long getNumero() {
        return this.numero;
    }

    @Override
    public int getAlturaTextual() {
        return 1;
    }

    @Override
    public Dado setAlturaTextual(int linhas) {
        return this;
    }

    @Override
    public int getLarguraTextual() {
        return this.larguraTextual;
    }

    @Override
    public Dado setLarguraTextual(int caracs) {
        this.larguraTextual = caracs;
        return this;
    }

    @Override
    public boolean isMultiplaLinha() {
        return false;
    }

    public Inteiro maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public Inteiro maisTextoLimite(int maxCaracteres, int tipo, String mensagem) {
        this.mais(new TextoLimite(this.getNome(), maxCaracteres, tipo, mensagem));
        return this;
    }

    public Inteiro maisTextoLimite(int maxCaracteres, String mensagem) {
        return this.maisTextoLimite(maxCaracteres, 3, mensagem);
    }

    public Inteiro maisNaoNulo(int tipo, String mensagem) {
        this.mais(new NaoNuloValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Inteiro maisNaoNulo(String mensagem) {
        return this.maisNaoNulo(3, mensagem);
    }

    public Inteiro maisInteiroLimite(long min, long max, int tipo, String mensagem) {
        this.mais(new InteiroLimiteValidacao(this.getNome(), min, max, tipo, mensagem));
        return this;
    }

    public Inteiro maisInteiroLimite(long min, long max, String mensagem) {
        return this.maisInteiroLimite(min, max, 3, mensagem);
    }

    @Override
    protected Dado configurarPor(Field atributo) {
        super.configurarPor(atributo);
        JFInteiro jfInteiro = atributo.getAnnotation(JFInteiro.class);
        JFTexto jfTexto = atributo.getAnnotation(JFTexto.class);
        JFValidacaoValorLimite jfValidacaoValorLimite = atributo.getAnnotation(JFValidacaoValorLimite.class);
        JFValidacaoTamanhoLimite jfValidacaoTamanhoLimite = atributo.getAnnotation(JFValidacaoTamanhoLimite.class);
        if (jfInteiro == null) {
            throw new IllegalArgumentException("O atributo " + atributo.getType().getSimpleName() + "." + atributo.getName() + " n\u00e3o cont\u00e9m " + JFInteiro.class.getName());
        }
        if (jfTexto != null) {
            this.larguraTextual = jfTexto.largura();
            if (jfValidacaoTamanhoLimite != null) {
                this.maisTextoLimite(jfTexto.max(), jfValidacaoTamanhoLimite.erro());
            }
        }
        if (jfValidacaoValorLimite != null) {
            this.maisInteiroLimite(jfInteiro.min(), jfInteiro.max(), jfValidacaoValorLimite.erro());
        }
        return this;
    }
}

