/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.modelo.JFData;
import com.joseflavio.modelo.JFTexto;
import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.VistaTextual;
import com.joseflavio.validacao.NaoNuloValidacao;
import com.joseflavio.validacao.ValidacaoException;
import java.lang.reflect.Field;
import java.util.Date;

public class Data
extends ComplexoDado
implements VistaTextual {
    private Date data;
    private DataTipo tipo;
    private int larguraTextual;

    public Data(String nome, Date data, DataTipo tipo, int larguraTextual, boolean editavel) {
        super(nome, editavel);
        this.data = data;
        this.tipo = tipo;
        this.larguraTextual = larguraTextual;
    }

    public Data(String nome, Date data, DataTipo tipo, boolean editavel) {
        this(nome, data, tipo, 0, editavel);
    }

    public Data(Date data, DataTipo tipo) {
        this(null, data, tipo, 0, false);
    }

    public Data(String nome, Class<? extends Object> classe, String atributo, Date data, Boolean editavel) {
        super(nome);
        this.configurarPor(classe, atributo);
        this.data = data;
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public Data(String nome, Class<? extends Object> classe, Date data, Boolean editavel) {
        this(nome, classe, nome, data, editavel);
    }

    @Override
    public Object getConteudo() {
        return this.data;
    }

    public DataTipo getTipo() {
        return this.tipo;
    }

    public Data setTipo(DataTipo tipo) {
        this.tipo = tipo;
        return this;
    }

    public Date getDataValidada() throws ValidacaoException {
        this.validar();
        return this.data;
    }

    public Date getData() {
        return this.data;
    }

    public Data setData(Date data) {
        this.data = data;
        return this;
    }

    @Override
    public int getAlturaTextual() {
        return 1;
    }

    @Override
    public Dado setAlturaTextual(int linhas) {
        return this;
    }

    @Override
    public int getLarguraTextual() {
        return this.larguraTextual;
    }

    @Override
    public Dado setLarguraTextual(int caracs) {
        this.larguraTextual = caracs;
        return this;
    }

    @Override
    public boolean isMultiplaLinha() {
        return false;
    }

    public Data maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public Data maisNaoNulo(int tipo, String mensagem) {
        this.mais(new NaoNuloValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Data maisNaoNulo(String mensagem) {
        return this.maisNaoNulo(3, mensagem);
    }

    @Override
    protected Dado configurarPor(Field atributo) {
        super.configurarPor(atributo);
        JFData jfData = atributo.getAnnotation(JFData.class);
        JFTexto jfTexto = atributo.getAnnotation(JFTexto.class);
        if (jfData == null) {
            throw new IllegalArgumentException("O atributo " + atributo.getType().getSimpleName() + "." + atributo.getName() + " n\u00e3o cont\u00e9m " + JFData.class.getName());
        }
        if (jfData.tipo() == JFData.DataTipo.DATA_HORA) {
            this.tipo = DataTipo.DATA_HORA;
        } else if (jfData.tipo() == JFData.DataTipo.DATA) {
            this.tipo = DataTipo.DATA;
        } else if (jfData.tipo() == JFData.DataTipo.HORA) {
            this.tipo = DataTipo.HORA;
        }
        if (jfTexto != null) {
            this.larguraTextual = jfTexto.largura();
        }
        return this;
    }

    public static enum DataTipo {
        DATA,
        HORA,
        DATA_HORA;

    }
}

