/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.EspacoLateral;
import com.joseflavio.tqc.Identificacao;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.OpcaoDeMenu;
import com.joseflavio.tqc.SimplesDado;
import com.joseflavio.tqc.dado.ComandoPorMetodo;

public class Comando
extends SimplesDado
implements Identificacao,
OpcaoDeMenu,
EspacoLateral {
    public static final int NORMAL = Funcao.GERAL.getValor();
    public static final int OK = Funcao.CONFIRMAR.getValor();
    public static final int CANCELAMENTO = Funcao.CANCELAR.getValor();
    public static final int SUCESSAO = Funcao.AVANCAR.getValor();
    public static final int ANTECESSAO = Funcao.VOLTAR.getValor();
    private String nome;
    private String rotulo;
    private String imagem;
    private Funcao funcao = Funcao.GERAL;
    private boolean espacoTextualPosterior = false;

    public Comando(String nome, String rotulo, String imagem, Funcao funcao) {
        this.nome = nome;
        this.rotulo = rotulo;
        this.imagem = imagem;
        this.funcao = funcao;
    }

    public Comando(String nome, String rotulo, String imagem, int funcao) {
        this(nome, rotulo, imagem, Funcao.getFuncao(funcao));
    }

    public Comando(String nome, String rotulo, Funcao funcao) {
        this(nome, rotulo, null, funcao);
    }

    public Comando(String nome, String rotulo, int funcao) {
        this(nome, rotulo, null, funcao);
    }

    public Comando(String nome, String rotulo) {
        this(nome, rotulo, null, NORMAL);
    }

    public Comando(String rotulo) {
        this(null, rotulo, null, NORMAL);
    }

    public int hashCode() {
        return (this.nome != null ? this.nome.hashCode() : 0) + (this.rotulo != null ? this.rotulo.hashCode() : 0) + (this.imagem != null ? this.imagem.hashCode() : 0) + (this.funcao != null ? this.funcao.getValor() : 0);
    }

    @Override
    public String getNome() {
        return this.nome;
    }

    @Override
    public Dado setNome(String nome) {
        this.nome = nome;
        return this;
    }

    @Override
    public Object getConteudo() {
        return this.rotulo;
    }

    @Override
    public String getIdentificacao() {
        return this.nome;
    }

    @Override
    public String getRotulo() {
        return this.rotulo;
    }

    public Comando setRotulo(String rotulo) {
        this.rotulo = rotulo;
        return this;
    }

    @Override
    public String getImagem() {
        return this.imagem;
    }

    public Comando setImagem(String imagem) {
        this.imagem = imagem;
        return this;
    }

    public Funcao getFuncaoTipo() {
        return this.funcao;
    }

    public int getFuncao() {
        return this.funcao.getValor();
    }

    public Comando setFuncao(Funcao funcao) {
        this.funcao = funcao;
        return this;
    }

    public Comando setFuncao(int funcao) {
        this.funcao = Funcao.getFuncao(funcao);
        return this;
    }

    @Override
    public boolean isEspacoTextualPosterior() {
        return this.espacoTextualPosterior;
    }

    @Override
    public Dado setEspacoTextualPosterior(boolean sim) {
        this.espacoTextualPosterior = sim;
        return this;
    }

    public static Comando getComando(Informacao informacao, String nome) {
        if (informacao instanceof ComandoPorMetodo) {
            try {
                return ((ComandoPorMetodo)((Object)informacao)).getComando(nome);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        Object dado = informacao.getDado(nome);
        if (dado instanceof Comando) {
            return (Comando)dado;
        }
        return null;
    }

    public static enum Funcao {
        GERAL(1),
        CONFIRMAR(2),
        CANCELAR(3),
        AVANCAR(4),
        VOLTAR(5);

        private int valor;

        private Funcao(int valor) {
            this.valor = valor;
        }

        public int getValor() {
            return this.valor;
        }

        public static Funcao getFuncao(int valor) {
            switch (valor) {
                case 1: {
                    return GERAL;
                }
                case 2: {
                    return CONFIRMAR;
                }
                case 3: {
                    return CANCELAR;
                }
                case 4: {
                    return AVANCAR;
                }
                case 5: {
                    return VOLTAR;
                }
            }
            throw new IllegalArgumentException("" + valor);
        }
    }
}

