/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.tqc.Aparencia;
import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.validacao.NaoNuloValidacao;
import com.joseflavio.validacao.ValidacaoException;

public class Bruto
extends ComplexoDado {
    private byte[] valor;
    private String valorRotulo;
    private Aparencia<Bruto> aparencia;

    public Bruto(String nome, byte[] valor, String valorRotulo, boolean editavel) {
        super(nome, editavel);
        this.valor = valor;
        this.valorRotulo = valorRotulo;
    }

    public Bruto(String nome, Class<? extends Object> classe, String atributo, byte[] valor, String valorRotulo, Boolean editavel) {
        super(nome);
        this.configurarPor(classe, atributo);
        this.valor = valor;
        this.valorRotulo = valorRotulo;
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public Bruto(String nome, Class<? extends Object> classe, byte[] valor, String valorRotulo, Boolean editavel) {
        this(nome, classe, nome, valor, valorRotulo, editavel);
    }

    @Override
    public Object getConteudo() {
        return this.valor;
    }

    public byte[] getValorValidado() throws ValidacaoException {
        this.validar();
        return this.valor;
    }

    public byte[] getValor() {
        return this.valor;
    }

    public Bruto setValor(byte[] valor) {
        this.valor = valor;
        return this;
    }

    public String getValorRotulo() {
        return this.valorRotulo;
    }

    public Bruto setValorRotulo(String valorRotulo) {
        this.valorRotulo = valorRotulo;
        return this;
    }

    public Aparencia<Bruto> getAparencia() {
        return this.aparencia;
    }

    public Bruto setAparencia(Aparencia<Bruto> aparencia) {
        this.aparencia = aparencia;
        return this;
    }

    public Bruto maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public Bruto maisNaoNulo(int tipo, String mensagem) {
        this.mais(new NaoNuloValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Bruto maisNaoNulo(String mensagem) {
        return this.maisNaoNulo(3, mensagem);
    }
}

