/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.modelo.JFApresentacao;
import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.tqc.Dado;
import com.joseflavio.validacao.NaoNuloValidacao;
import com.joseflavio.validacao.ValidacaoException;
import java.lang.reflect.Field;

public class Binario
extends ComplexoDado {
    private String rotulo;
    private Boolean valor;

    public Binario(String nome, String rotulo, Boolean valor, boolean editavel) {
        super(nome, editavel);
        this.rotulo = rotulo;
        this.valor = valor;
    }

    public Binario(String nome, Class<? extends Object> classe, String atributo, Boolean valor, Boolean editavel) {
        super(nome);
        this.configurarPor(classe, atributo);
        this.valor = valor;
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public Binario(String nome, Class<? extends Object> classe, Boolean valor, Boolean editavel) {
        this(nome, classe, nome, valor, editavel);
    }

    @Override
    public Object getConteudo() {
        return this.valor;
    }

    public Boolean getValorValidado() throws ValidacaoException {
        this.validar();
        return this.valor;
    }

    public Boolean getValor() {
        return this.valor;
    }

    public Binario setValor(Boolean valor) {
        this.valor = valor;
        return this;
    }

    public boolean isVerdadeiro() {
        return this.valor != null && this.valor == true;
    }

    public String getRotulo() {
        return this.rotulo;
    }

    public Binario setRotulo(String rotulo) {
        this.rotulo = rotulo;
        return this;
    }

    public Binario maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public Binario maisNaoNulo(int tipo, String mensagem) {
        this.mais(new NaoNuloValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Binario maisNaoNulo(String mensagem) {
        return this.maisNaoNulo(3, mensagem);
    }

    @Override
    protected Dado configurarPor(Field atributo) {
        super.configurarPor(atributo);
        JFApresentacao jfApresentacao = atributo.getAnnotation(JFApresentacao.class);
        if (jfApresentacao != null) {
            this.rotulo = jfApresentacao.value();
        }
        return this;
    }
}

