/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.dado;

import com.joseflavio.tqc.Aparencia;
import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.validacao.NaoNuloValidacao;
import com.joseflavio.validacao.ValidacaoException;
import java.io.File;

public class Arquivo
extends ComplexoDado {
    private File localPreferido;
    private File arquivo;
    private Aparencia<Arquivo> aparencia;

    public Arquivo(String nome, File arquivo, File localPreferido, boolean editavel) {
        super(nome, editavel);
        this.arquivo = arquivo;
        this.localPreferido = localPreferido;
    }

    public Arquivo(File arquivo) {
        this(null, arquivo, null, false);
    }

    public Arquivo(String nome, Class<? extends Object> classe, String atributo, File arquivo, File localPreferido, Boolean editavel) {
        super(nome);
        this.configurarPor(classe, atributo);
        this.arquivo = arquivo;
        this.localPreferido = localPreferido;
        if (editavel != null) {
            this.setEditavel(editavel);
        }
    }

    public Arquivo(String nome, Class<? extends Object> classe, File arquivo, File localPreferido, Boolean editavel) {
        this(nome, classe, nome, arquivo, localPreferido, editavel);
    }

    @Override
    public Object getConteudo() {
        return this.arquivo;
    }

    public File getArquivoValidado() throws ValidacaoException {
        this.validar();
        return this.arquivo;
    }

    public File getArquivo() {
        return this.arquivo;
    }

    public Arquivo setArquivo(File arquivo) {
        this.arquivo = arquivo;
        return this;
    }

    public File getLocalPreferido() {
        return this.localPreferido;
    }

    public Arquivo setLocalPreferido(File localPreferido) {
        this.localPreferido = localPreferido;
        return this;
    }

    public Aparencia<Arquivo> getAparencia() {
        return this.aparencia;
    }

    public Arquivo setAparencia(Aparencia<Arquivo> aparencia) {
        this.aparencia = aparencia;
        return this;
    }

    public Arquivo maisValidacaoPrimitiva(String mensagem) {
        this.setMensagemValidacaoPrimitiva(mensagem);
        return this;
    }

    public Arquivo maisNaoNulo(int tipo, String mensagem) {
        this.mais(new NaoNuloValidacao(this.getNome(), tipo, mensagem));
        return this;
    }

    public Arquivo maisNaoNulo(String mensagem) {
        return this.maisNaoNulo(3, mensagem);
    }
}

