/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.console;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.tqc.console.Console;
import com.joseflavio.tqc.console.Cor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Formatter;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SwingConsole
extends Console {
    private Caractere[][] cadeia;
    private int linhas;
    private int colunas;
    private JFrame janela;
    private Fundo fundo;
    private Font fonte;
    private int fonteLargura;
    private int fonteAltura;
    private int fonteDesc;
    private Cor corTexto = Cor.BRANCA;
    private Cor corTextoFundo = Cor.PRETA;
    private Entrada entrada = new Entrada();
    private int cursorL = 0;
    private int cursorC = 0;

    public SwingConsole(Cultura cultura, String titulo, int tamanhoFonte, int linhas, int colunas, boolean sairAoFechar) {
        super(cultura);
        this.cadeia = new Caractere[linhas][colunas];
        this.linhas = linhas;
        this.colunas = colunas;
        this.janela = new JFrame(titulo);
        this.fonte = new Font("Monospaced", 1, tamanhoFonte);
        FontMetrics metrica = this.janela.getFontMetrics(this.fonte);
        this.fonteLargura = metrica.charWidth('O') + 1;
        this.fonteAltura = metrica.getMaxAscent() + metrica.getMaxDescent();
        this.fonteDesc = metrica.getMaxDescent();
        this.fundo = new Fundo(colunas * this.fonteLargura, linhas * this.fonteAltura);
        for (int i = 0; i < linhas; ++i) {
            for (int j = 0; j < colunas; ++j) {
                this.cadeia[i][j] = new Caractere();
            }
        }
        this.janela.getContentPane().add(new JScrollPane(this.fundo));
        this.janela.addKeyListener(this.entrada);
        this.janela.setDefaultCloseOperation(sairAoFechar ? 3 : 2);
        this.janela.pack();
        this.janela.setVisible(true);
    }

    public SwingConsole(Cultura cultura, String titulo, int tamanhoFonte, int linhas, int colunas) {
        this(cultura, titulo, tamanhoFonte, linhas, colunas, true);
    }

    public SwingConsole(Cultura cultura, String titulo) {
        this(cultura, titulo, 12, 30, 80, true);
    }

    public SwingConsole(String titulo, boolean sairAoFechar) {
        this(Cultura.getPadrao(), titulo, 12, 30, 80, sairAoFechar);
    }

    public SwingConsole(String titulo) {
        this(Cultura.getPadrao(), titulo, 12, 30, 80, true);
    }

    public JFrame getJanela() {
        return this.janela;
    }

    @Override
    public int getTotalColunas() {
        return this.colunas;
    }

    @Override
    public int getTotalLinhas() {
        return this.linhas;
    }

    @Override
    public synchronized void setCorTexto(int cor) {
        this.corTexto = Cor.getCor(cor);
    }

    @Override
    public synchronized int getCorTexto() {
        return this.corTexto.getCor();
    }

    @Override
    public synchronized void setCorTextoFundo(int cor) {
        this.corTextoFundo = Cor.getCor(cor);
    }

    @Override
    public synchronized int getCorTextoFundo() {
        return this.corTextoFundo.getCor();
    }

    @Override
    public synchronized void limpar() {
        for (int i = 0; i < this.linhas; ++i) {
            for (int j = 0; j < this.colunas; ++j) {
                this.cadeia[i][j].limpar();
            }
        }
        this.cursorC = 0;
        this.cursorL = 0;
        this.fundo.repintar();
    }

    @Override
    public char esperar(boolean mostrar) throws IOException {
        return this.entrada.esperar(mostrar);
    }

    @Override
    public synchronized void setTelaCheia(boolean cheia) {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        gd.setFullScreenWindow(cheia ? this.janela : null);
    }

    @Override
    public String receber() throws IOException {
        return this.entrada.receber();
    }

    @Override
    public synchronized void enviar(String texto) {
        int total = texto.length();
        for (int i = 0; i < total; ++i) {
            char ch = texto.charAt(i);
            if (ch == '\n') {
                this.saltarUmaLinha();
                continue;
            }
            Caractere c = this.cadeia[this.cursorL][this.cursorC];
            c.letra = ch;
            c.corLetra = this.corTexto;
            c.corFundo = this.corTextoFundo;
            this.avancarCursor();
        }
        this.fundo.repintar();
    }

    @Override
    public void enviarln(String texto) {
        this.enviar(texto + "\n");
    }

    @Override
    public void enviarln() {
        this.enviar("\n");
    }

    @Override
    public void enviar(String formato, Object ... args) {
        Formatter formatter = new Formatter();
        this.enviar(formatter.format(formato, args).toString());
        formatter.close();
    }

    private void deslocarLinhasParaCima() {
        int j;
        int i;
        for (i = 0; i < this.linhas - 1; ++i) {
            for (j = 0; j < this.colunas; ++j) {
                this.cadeia[i][j].copiar(this.cadeia[i + 1][j]);
            }
        }
        i = this.linhas - 1;
        for (j = 0; j < this.colunas; ++j) {
            this.cadeia[i][j].limpar();
        }
    }

    private void avancarCursor() {
        ++this.cursorC;
        if (this.cursorC == this.colunas) {
            this.saltarUmaLinha();
        }
    }

    private void recuarCursor() {
        if (this.cursorC == 0 && this.cursorL == 0) {
            return;
        }
        --this.cursorC;
        if (this.cursorC == -1) {
            this.cursorC = this.colunas - 1;
            --this.cursorL;
        }
    }

    private void saltarUmaLinha() {
        ++this.cursorL;
        this.cursorC = 0;
        if (this.cursorL == this.linhas) {
            this.deslocarLinhasParaCima();
            --this.cursorL;
        }
    }

    private void deslocarCursor() {
        int j;
        int i;
        for (i = this.linhas - 1; i > this.cursorL; --i) {
            for (j = this.colunas - 1; j > 0; --j) {
                this.cadeia[i][j].copiar(this.cadeia[i][j - 1]);
            }
            this.cadeia[i][0].copiar(this.cadeia[i - 1][this.colunas - 1]);
        }
        i = this.cursorL;
        for (j = this.colunas - 1; j > this.cursorC; --j) {
            this.cadeia[i][j].copiar(this.cadeia[i][j - 1]);
        }
        this.cadeia[this.cursorL][this.cursorC].letra = ' ';
    }

    private void apagarCursor() {
        for (int i = this.cursorL; i < this.linhas; ++i) {
            int j;
            int n = j = i == this.cursorL ? this.cursorC : 0;
            while (j < this.colunas - 1) {
                this.cadeia[i][j].copiar(this.cadeia[i][j + 1]);
                ++j;
            }
            if (i >= this.linhas - 1) continue;
            this.cadeia[i][this.colunas - 1].copiar(this.cadeia[i + 1][0]);
        }
        this.cadeia[this.linhas - 1][this.colunas - 1].letra = ' ';
    }

    private static enum Cursor {
        NAO_MOSTRAR,
        NORMAL,
        SUBSTITUICAO;

    }

    private class RelogioCursor
    extends TimerTask {
        private Entrada entrada;

        public RelogioCursor(Entrada entrada) {
            this.entrada = entrada;
        }

        @Override
        public void run() {
            SwingConsole.this.fundo.cursor = SwingConsole.this.fundo.cursor == Cursor.NAO_MOSTRAR ? (this.entrada.insert ? Cursor.NORMAL : Cursor.SUBSTITUICAO) : Cursor.NAO_MOSTRAR;
            SwingConsole.this.fundo.repintarCursor();
        }
    }

    private class Entrada
    extends KeyAdapter {
        private StringBuilder buffer = new StringBuilder(50);
        private int bufferIndice;
        private boolean iniciada = false;
        private boolean finalizada;
        private boolean capturarApenas1 = false;
        private boolean insert;
        private Timer timerCursor;

        private Entrada() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!this.iniciada) {
                return;
            }
            switch (e.getKeyCode()) {
                case 37: {
                    if (this.bufferIndice <= 0) break;
                    --this.bufferIndice;
                    SwingConsole.this.recuarCursor();
                    SwingConsole.this.fundo.repintar();
                    break;
                }
                case 39: {
                    if (this.bufferIndice >= this.buffer.length()) break;
                    ++this.bufferIndice;
                    SwingConsole.this.avancarCursor();
                    SwingConsole.this.fundo.repintar();
                    break;
                }
                case 36: {
                    while (this.bufferIndice > 0) {
                        --this.bufferIndice;
                        SwingConsole.this.recuarCursor();
                    }
                    SwingConsole.this.fundo.repintar();
                    break;
                }
                case 35: {
                    while (this.bufferIndice < this.buffer.length()) {
                        ++this.bufferIndice;
                        SwingConsole.this.avancarCursor();
                    }
                    SwingConsole.this.fundo.repintar();
                    break;
                }
                case 155: {
                    this.insert = !this.insert;
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this.capturarApenas1) {
                this.buffer.append(e.getKeyChar());
                this.capturarApenas1 = false;
                return;
            }
            if (!this.iniciada) {
                return;
            }
            char ch = e.getKeyChar();
            switch (ch) {
                case '\n': {
                    this.pararDePiscarCursor();
                    while (this.bufferIndice < this.buffer.length()) {
                        ++this.bufferIndice;
                        SwingConsole.this.avancarCursor();
                    }
                    SwingConsole.this.saltarUmaLinha();
                    SwingConsole.this.fundo.repintar();
                    this.finalizada = true;
                    break;
                }
                case '\b': {
                    if (this.bufferIndice <= 0) break;
                    --this.bufferIndice;
                    this.buffer.delete(this.bufferIndice, this.bufferIndice + 1);
                    SwingConsole.this.recuarCursor();
                    SwingConsole.this.apagarCursor();
                    SwingConsole.this.fundo.repintar();
                    break;
                }
                case '\u007f': {
                    if (this.bufferIndice >= this.buffer.length()) break;
                    this.buffer.delete(this.bufferIndice, this.bufferIndice + 1);
                    SwingConsole.this.apagarCursor();
                    SwingConsole.this.fundo.repintar();
                    break;
                }
                case '\u001b': {
                    break;
                }
                default: {
                    Caractere c = SwingConsole.this.cadeia[SwingConsole.this.cursorL][SwingConsole.this.cursorC];
                    if (this.insert) {
                        this.buffer.insert(this.bufferIndice, ch);
                        SwingConsole.this.deslocarCursor();
                    } else if (this.bufferIndice == this.buffer.length()) {
                        this.buffer.append(ch);
                    } else {
                        this.buffer.setCharAt(this.bufferIndice, ch);
                    }
                    c.letra = ch;
                    c.corLetra = SwingConsole.this.corTexto;
                    c.corFundo = SwingConsole.this.corTextoFundo;
                    ++this.bufferIndice;
                    SwingConsole.this.avancarCursor();
                    SwingConsole.this.fundo.repintar();
                }
            }
        }

        public synchronized String receber() throws IOException {
            this.buffer.delete(0, this.buffer.length());
            this.bufferIndice = 0;
            this.insert = true;
            this.finalizada = false;
            this.iniciada = true;
            this.piscarCursor();
            while (!this.finalizada) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            this.iniciada = false;
            return this.buffer.toString();
        }

        public synchronized char esperar(boolean mostrar) throws IOException {
            this.buffer.delete(0, this.buffer.length());
            this.insert = true;
            this.capturarApenas1 = true;
            this.piscarCursor();
            while (this.capturarApenas1) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            this.pararDePiscarCursor();
            char ch = this.buffer.charAt(0);
            if (mostrar) {
                Caractere c = SwingConsole.this.cadeia[SwingConsole.this.cursorL][SwingConsole.this.cursorC];
                c.letra = ch;
                c.corLetra = SwingConsole.this.corTexto;
                c.corFundo = SwingConsole.this.corTextoFundo;
                SwingConsole.this.avancarCursor();
            }
            SwingConsole.this.fundo.repintar();
            return ch;
        }

        private void piscarCursor() {
            if (this.timerCursor == null) {
                this.timerCursor = new Timer();
                this.timerCursor.schedule((TimerTask)new RelogioCursor(this), 500L, 500L);
            }
        }

        private void pararDePiscarCursor() {
            if (this.timerCursor != null) {
                this.timerCursor.cancel();
                this.timerCursor = null;
                SwingConsole.this.fundo.cursor = Cursor.NAO_MOSTRAR;
            }
        }
    }

    private class Fundo
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private BufferedImage buffer;
        private Cursor cursor = Cursor.NAO_MOSTRAR;

        public Fundo(int largura, int altura) {
            this.buffer = new BufferedImage(largura, altura, 1);
            Dimension dimensao = new Dimension(largura, altura);
            this.setPreferredSize(dimensao);
            this.setSize(dimensao);
        }

        private void pintar() {
            Graphics g = this.buffer.getGraphics();
            g.setFont(SwingConsole.this.fonte);
            g.setColor(SwingConsole.this.corTextoFundo.getColor());
            g.fillRect(0, 0, this.buffer.getWidth(), this.buffer.getHeight());
            char[] letra = new char[1];
            for (int i = 0; i < SwingConsole.this.linhas; ++i) {
                for (int j = 0; j < SwingConsole.this.colunas; ++j) {
                    Caractere c = SwingConsole.this.cadeia[i][j];
                    letra[0] = c.letra;
                    g.setColor(c.corFundo.getColor());
                    g.fillRect(j * SwingConsole.this.fonteLargura, i * SwingConsole.this.fonteAltura, SwingConsole.this.fonteLargura, SwingConsole.this.fonteAltura);
                    g.setColor(c.corLetra.getColor());
                    g.drawChars(letra, 0, 1, j * SwingConsole.this.fonteLargura, (i + 1) * SwingConsole.this.fonteAltura - SwingConsole.this.fonteDesc);
                }
            }
        }

        private void pintarApenasCursor() {
            Graphics g = this.buffer.getGraphics();
            g.setFont(SwingConsole.this.fonte);
            Caractere c = SwingConsole.this.cadeia[SwingConsole.this.cursorL][SwingConsole.this.cursorC];
            char[] letra = new char[]{c.letra};
            g.setColor(c.corFundo.getColor());
            g.fillRect(SwingConsole.this.cursorC * SwingConsole.this.fonteLargura, SwingConsole.this.cursorL * SwingConsole.this.fonteAltura, SwingConsole.this.fonteLargura, SwingConsole.this.fonteAltura);
            g.setColor(c.corLetra.getColor());
            g.drawChars(letra, 0, 1, SwingConsole.this.cursorC * SwingConsole.this.fonteLargura, (SwingConsole.this.cursorL + 1) * SwingConsole.this.fonteAltura - SwingConsole.this.fonteDesc);
            int x = SwingConsole.this.cursorC * SwingConsole.this.fonteLargura;
            int y = SwingConsole.this.cursorL * SwingConsole.this.fonteAltura;
            g.setColor(SwingConsole.this.corTexto.getColor());
            switch (this.cursor) {
                case NORMAL: {
                    g.drawLine(x, y, x, y + SwingConsole.this.fonteAltura - 1);
                    break;
                }
                case SUBSTITUICAO: {
                    g.drawRect(x, y, SwingConsole.this.fonteLargura - 1, SwingConsole.this.fonteAltura - 1);
                    break;
                }
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(SwingConsole.this.corTextoFundo.getColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.buffer, 0, 0, null);
        }

        private synchronized void repintar0(boolean apenasCursor) {
            if (apenasCursor) {
                this.pintarApenasCursor();
            } else {
                this.pintar();
            }
            this.repaint();
        }

        public void repintar() {
            this.repintar0(false);
        }

        public void repintarCursor() {
            this.repintar0(true);
        }
    }

    private class Caractere {
        private char letra;
        private Cor corLetra;
        private Cor corFundo;

        public Caractere(char letra, Cor corLetra, Cor corFundo) {
            this.letra = letra;
            this.corLetra = corLetra;
            this.corFundo = corFundo;
        }

        public Caractere() {
            this(' ', swingConsole.corTexto, swingConsole.corTextoFundo);
        }

        public void limpar() {
            this.letra = (char)32;
            this.corLetra = SwingConsole.this.corTexto;
            this.corFundo = SwingConsole.this.corTextoFundo;
        }

        public void copiar(Caractere c) {
            this.letra = c.letra;
            this.corLetra = c.corLetra;
            this.corFundo = c.corFundo;
        }
    }
}

