/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.console;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.tqc.console.GenericoConsole;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NativoConsole
extends GenericoConsole {
    private static boolean normal = false;

    public NativoConsole(Cultura cultura) throws IOException {
        super(cultura);
        if (!normal) {
            try {
                boolean windows = System.getProperty("os.name").toLowerCase().contains("windows");
                boolean x64 = System.getProperty("os.arch").toLowerCase().contains("64");
                String nome = NativoConsole.class.getName().replaceAll("\\.", "_") + (x64 ? "_64" : "_32") + (windows ? ".dll" : ".so");
                File arquivo = new File(System.getProperty("user.home") + File.separator + nome);
                if (!arquivo.exists()) {
                    int ch;
                    arquivo.createNewFile();
                    InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream(nome);
                    FileOutputStream out = new FileOutputStream(arquivo);
                    while ((ch = in.read()) != -1) {
                        ((OutputStream)out).write(ch);
                    }
                    in.close();
                    out.flush();
                    ((OutputStream)out).close();
                }
                System.load(arquivo.getAbsolutePath());
                normal = true;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    @Override
    public native int getTotalColunas();

    @Override
    public native int getTotalLinhas();

    @Override
    public native void setCorTexto(int var1);

    @Override
    public native int getCorTexto();

    @Override
    public native void setCorTextoFundo(int var1);

    @Override
    public native int getCorTextoFundo();

    @Override
    public native void limpar();

    @Override
    public native char esperar(boolean var1) throws IOException;

    @Override
    public native void setTelaCheia(boolean var1);
}

