/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.console;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.tqc.console.Console;
import java.io.IOException;
import java.util.Formatter;
import java.util.Scanner;

public class GenericoConsole
extends Console {
    private java.io.Console console = System.console();
    private Scanner scanner = new Scanner(System.in);
    private Formatter formatter = new Formatter(System.out);
    private int corTexto = 15;
    private int corTextoFundo = 0;

    public GenericoConsole(Cultura cultura) {
        super(cultura);
    }

    @Override
    public int getTotalColunas() {
        return 80;
    }

    @Override
    public int getTotalLinhas() {
        return 50;
    }

    @Override
    public void setCorTexto(int cor) {
        this.corTexto = cor;
    }

    @Override
    public int getCorTexto() {
        return this.corTexto;
    }

    @Override
    public void setCorTextoFundo(int cor) {
        this.corTextoFundo = cor;
    }

    @Override
    public int getCorTextoFundo() {
        return this.corTextoFundo;
    }

    @Override
    public void limpar() {
    }

    @Override
    public char esperar(boolean mostrar) throws IOException {
        Object s;
        if (this.console != null) {
            if (mostrar) {
                while ((s = this.console.readLine()) != null && ((String)s).length() == 0) {
                }
                if (s != null) {
                    return ((String)s).charAt(0);
                }
            } else {
                while ((s = (Object)this.console.readPassword()) != null && ((Object)s).length == 0) {
                }
                if (s != null) {
                    return (char)s[0];
                }
            }
        }
        while ((s = this.scanner.nextLine()) != null && ((String)s).length() == 0) {
        }
        if (s != null) {
            return ((String)s).charAt(0);
        }
        throw new IOException("Recurso indispon\u00edvel");
    }

    @Override
    public void setTelaCheia(boolean cheia) {
    }

    @Override
    public String receber() throws IOException {
        String s;
        if (this.console != null && (s = this.console.readLine()) != null) {
            return s;
        }
        s = this.scanner.nextLine();
        if (s != null) {
            return s;
        }
        throw new IOException("Recurso indispon\u00edvel");
    }

    @Override
    public void enviar(String texto) {
        System.out.print(texto);
    }

    @Override
    public void enviarln(String texto) {
        System.out.println(texto);
    }

    @Override
    public void enviarln() {
        System.out.println();
    }

    @Override
    public void enviar(String formato, Object ... args) {
        this.formatter.format(formato, args);
    }
}

