/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.console;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.cultura.DataTransformacao;
import com.joseflavio.cultura.NumeroTransformacao;
import com.joseflavio.cultura.TransformacaoException;
import com.joseflavio.tqc.console.Cor;
import com.joseflavio.tqc.console.GenericoConsole;
import com.joseflavio.tqc.console.NativoConsole;
import java.io.IOException;
import java.util.Date;
import java.util.Stack;

public abstract class Console {
    public static final int COR_PRETA = 0;
    public static final int COR_AZUL = 1;
    public static final int COR_VERDE = 2;
    public static final int COR_CIANO = 3;
    public static final int COR_VERMELHA = 4;
    public static final int COR_MAGENTA = 5;
    public static final int COR_MARRON = 6;
    public static final int COR_CINZA_INTENSA = 7;
    public static final int COR_CINZA_ESCURA = 8;
    public static final int COR_AZUL_INTENSA = 9;
    public static final int COR_VERDE_INTENSA = 10;
    public static final int COR_CIANO_INTENSA = 11;
    public static final int COR_VERMELHA_INTENSA = 12;
    public static final int COR_MAGENTA_INTENSA = 13;
    public static final int COR_AMARELA = 14;
    public static final int COR_BRANCA = 15;
    private Cultura cultura;
    private NumeroTransformacao realTransformacao;
    private NumeroTransformacao inteiroTransformacao;
    private DataTransformacao dataTransformacao;
    private int corTextoVocativo = -1;
    private Stack<Cores> pilhaCores = new Stack();

    public Console(Cultura cultura) {
        this.cultura = cultura != null ? cultura : Cultura.getPadrao();
        this.realTransformacao = cultura.novaRealTransformacao();
        this.inteiroTransformacao = cultura.novaInteiroTransformacao();
        this.dataTransformacao = cultura.novaDataTransformacao();
    }

    public abstract int getTotalColunas();

    public abstract int getTotalLinhas();

    public abstract void setCorTexto(int var1);

    public final void setCorTexto(Cor cor) {
        this.setCorTexto(cor.getCor());
    }

    public abstract int getCorTexto();

    public final Cor getCorTexto2() {
        return Cor.getCor(this.getCorTexto());
    }

    public abstract void setCorTextoFundo(int var1);

    public final void setCorTextoFundo(Cor cor) {
        this.setCorTextoFundo(cor.getCor());
    }

    public abstract int getCorTextoFundo();

    public final Cor getCorTextoFundo2() {
        return Cor.getCor(this.getCorTextoFundo());
    }

    public abstract void limpar();

    public void limpar(int corFundo) {
        this.setCorTextoFundo(corFundo);
        this.limpar();
    }

    public final void limpar(Cor corFundo) {
        this.limpar(corFundo.getCor());
    }

    public abstract char esperar(boolean var1) throws IOException;

    public final char esperar(String vocativo, boolean mostrar) throws IOException {
        this.enviarVocativo(vocativo);
        return this.esperar(mostrar);
    }

    public abstract void setTelaCheia(boolean var1);

    public abstract String receber() throws IOException;

    public abstract void enviar(String var1);

    public final void enviar(Cor corTexto, String texto) {
        int cor = this.getCorTexto();
        this.setCorTexto(corTexto);
        this.enviar(texto);
        this.setCorTexto(cor);
    }

    public abstract void enviarln(String var1);

    public final void enviarln(Cor corTexto, String texto) {
        int cor = this.getCorTexto();
        this.setCorTexto(corTexto);
        this.enviarln(texto);
        this.setCorTexto(cor);
    }

    public final void enviarCentralizado(Cor corTexto, String texto) {
        int cor = this.getCorTexto();
        this.setCorTexto(corTexto);
        this.enviarCentralizado(texto);
        this.setCorTexto(cor);
    }

    public final void enviarCentralizado(String texto) {
        int totalEspacos;
        int totalColunas = this.getTotalColunas();
        int textoTamanho = texto.length();
        if (textoTamanho > totalColunas) {
            throw new IllegalArgumentException("Tamanho excessivo: " + textoTamanho);
        }
        StringBuilder sb = new StringBuilder(totalColunas);
        for (totalEspacos = (totalColunas - textoTamanho) / 2; totalEspacos > 0; --totalEspacos) {
            sb.append(' ');
        }
        sb.append(texto);
        for (totalEspacos = totalColunas - sb.length(); totalEspacos > 0; --totalEspacos) {
            sb.append(' ');
        }
        this.enviar(sb.toString());
    }

    public abstract void enviarln();

    public abstract void enviar(String var1, Object ... var2);

    public final void enviar(Cor corTexto, String formato, Object ... args) {
        int cor = this.getCorTexto();
        this.setCorTexto(corTexto);
        this.enviar(formato, args);
        this.setCorTexto(cor);
    }

    public Cultura getCultura() {
        return this.cultura;
    }

    public void setRealTransformacao(NumeroTransformacao realTransformacao) {
        this.realTransformacao = realTransformacao;
    }

    public void setInteiroTransformacao(NumeroTransformacao inteiroTransformacao) {
        this.inteiroTransformacao = inteiroTransformacao;
    }

    public void setDataTransformacao(DataTransformacao dataTransformacao) {
        this.dataTransformacao = dataTransformacao;
    }

    public static Console novoConsole(Cultura cultura) {
        GenericoConsole c;
        try {
            c = new NativoConsole(cultura);
        }
        catch (Throwable e) {
            c = new GenericoConsole(cultura);
        }
        return c;
    }

    public static Console novoConsole() {
        return Console.novoConsole(Cultura.getPadrao());
    }

    public void setCorTextoVocativo(int corTextoVocativo) {
        this.corTextoVocativo = corTextoVocativo;
    }

    public final void setCorTextoVocativo(Cor cor) {
        this.setCorTextoVocativo(cor.getCor());
    }

    public int getCorTextoVocativo() {
        return this.corTextoVocativo;
    }

    private void enviarVocativo(String vocativo) {
        if (this.corTextoVocativo != -1) {
            int corTexto = this.getCorTexto();
            this.setCorTexto(this.corTextoVocativo);
            this.enviar(vocativo);
            this.setCorTexto(corTexto);
        } else {
            this.enviar(vocativo);
        }
    }

    public String receber(String vocativo) throws IOException {
        this.enviarVocativo(vocativo);
        return this.receber();
    }

    public Double receberReal(NumeroTransformacao realTransformacao) throws IOException, TransformacaoException {
        String str = this.receber();
        if (str.length() == 0) {
            return null;
        }
        return realTransformacao.transformarReal(str);
    }

    public Double receberReal() throws IOException, TransformacaoException {
        return this.receberReal(this.realTransformacao);
    }

    public Double receberReal(String vocativo, String mensagemErro) throws IOException {
        while (true) {
            try {
                this.enviarVocativo(vocativo);
                return this.receberReal();
            }
            catch (TransformacaoException e) {
                int corTexto = this.getCorTexto();
                this.setCorTexto(12);
                this.enviarln(mensagemErro != null ? mensagemErro : "Valor incorreto.");
                this.setCorTexto(corTexto);
                continue;
            }
            break;
        }
    }

    public Long receberInteiro(NumeroTransformacao inteiroTransformacao) throws IOException, TransformacaoException {
        String str = this.receber();
        if (str.length() == 0) {
            return null;
        }
        return inteiroTransformacao.transformarInteiro(str);
    }

    public Long receberInteiro() throws IOException, TransformacaoException {
        return this.receberInteiro(this.inteiroTransformacao);
    }

    public Long receberInteiro(String vocativo, String mensagemErro) throws IOException {
        while (true) {
            try {
                this.enviarVocativo(vocativo);
                return this.receberInteiro();
            }
            catch (TransformacaoException e) {
                int corTexto = this.getCorTexto();
                this.setCorTexto(12);
                this.enviarln(mensagemErro != null ? mensagemErro : "Valor incorreto.");
                this.setCorTexto(corTexto);
                continue;
            }
            break;
        }
    }

    public Date receberData(DataTransformacao dataTransformacao) throws IOException, TransformacaoException {
        String str = this.receber();
        if (str.length() == 0) {
            return null;
        }
        return dataTransformacao.transformarData(str);
    }

    public Date receberData() throws IOException, TransformacaoException {
        return this.receberData(this.dataTransformacao);
    }

    public Date receberData(String vocativo, String mensagemErro) throws IOException {
        while (true) {
            try {
                this.enviarVocativo(vocativo);
                return this.receberData();
            }
            catch (TransformacaoException e) {
                int corTexto = this.getCorTexto();
                this.setCorTexto(12);
                this.enviarln(mensagemErro != null ? mensagemErro : "Valor incorreto.");
                this.setCorTexto(corTexto);
                continue;
            }
            break;
        }
    }

    public Date receberHora(DataTransformacao dataTransformacao) throws IOException, TransformacaoException {
        String str = this.receber();
        if (str.length() == 0) {
            return null;
        }
        return dataTransformacao.transformarHora(str);
    }

    public Date receberHora() throws IOException, TransformacaoException {
        return this.receberHora(this.dataTransformacao);
    }

    public Date receberHora(String vocativo, String mensagemErro) throws IOException {
        while (true) {
            try {
                this.enviarVocativo(vocativo);
                return this.receberHora();
            }
            catch (TransformacaoException e) {
                int corTexto = this.getCorTexto();
                this.setCorTexto(12);
                this.enviarln(mensagemErro != null ? mensagemErro : "Valor incorreto.");
                this.setCorTexto(corTexto);
                continue;
            }
            break;
        }
    }

    public Date receberDataHora(DataTransformacao dataTransformacao) throws IOException, TransformacaoException {
        String str = this.receber();
        if (str.length() == 0) {
            return null;
        }
        return dataTransformacao.transformarDataHora(str);
    }

    public Date receberDataHora() throws IOException, TransformacaoException {
        return this.receberDataHora(this.dataTransformacao);
    }

    public Date receberDataHora(String vocativo, String mensagemErro) throws IOException {
        while (true) {
            try {
                this.enviarVocativo(vocativo);
                return this.receberDataHora();
            }
            catch (TransformacaoException e) {
                int corTexto = this.getCorTexto();
                this.setCorTexto(12);
                this.enviarln(mensagemErro != null ? mensagemErro : "Valor incorreto.");
                this.setCorTexto(corTexto);
                continue;
            }
            break;
        }
    }

    public void guardarCores() {
        this.pilhaCores.push(new Cores());
    }

    public void guardarCores(int novaCorTexto, int novaCorTextoFundo) {
        this.guardarCores();
        this.setCorTexto(novaCorTexto);
        this.setCorTextoFundo(novaCorTextoFundo);
    }

    public void guardarCores(int novaCorTexto) {
        this.guardarCores();
        this.setCorTexto(novaCorTexto);
    }

    public final void guardarCores(Cor novaCorTexto, Cor novaCorTextoFundo) {
        this.guardarCores(novaCorTexto.getCor(), novaCorTextoFundo.getCor());
    }

    public final void guardarCores(Cor novaCorTexto) {
        this.guardarCores(novaCorTexto.getCor());
    }

    public void restaurarCores() {
        this.pilhaCores.pop().restaurar();
    }

    private class Cores {
        private int corTexto;
        private int corTextoFundo;
        private int corTextoVocativo;

        public Cores() {
            this.corTexto = Console.this.getCorTexto();
            this.corTextoFundo = Console.this.getCorTextoFundo();
            this.corTextoVocativo = Console.this.getCorTextoVocativo();
        }

        public void restaurar() {
            Console.this.setCorTexto(this.corTexto);
            Console.this.setCorTextoFundo(this.corTextoFundo);
            Console.this.setCorTextoVocativo(this.corTextoVocativo);
        }
    }
}

