/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.console;

import com.joseflavio.tqc.console.Argumentos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChaveadosArgumentos
implements Argumentos {
    private String[] args;
    private Map<String, Chave> chaves = new HashMap<String, Chave>();
    private Map<String, List<Argumento>> argumentos = new HashMap<String, List<Argumento>>();

    public ChaveadosArgumentos(String[] args, List<Chave> chaves) {
        this.args = args;
        for (Chave c : chaves) {
            String k = c.getToken();
            this.chaves.put(k, c);
            this.argumentos.put(k, new ArrayList());
        }
        this.argumentos.put(null, new ArrayList());
        this.interpretar();
    }

    public ChaveadosArgumentos(String[] args, Chave ... chaves) {
        this.args = args;
        for (Chave c : chaves) {
            String k = c.getToken();
            this.chaves.put(k, c);
            this.argumentos.put(k, new ArrayList());
        }
        this.argumentos.put(null, new ArrayList());
        this.interpretar();
    }

    private void interpretar() {
        int total = this.args.length;
        for (int i = 0; i < total; ++i) {
            String token = this.args[i];
            String valor = null;
            Chave chave = this.chaves.get(token);
            if (chave == null) {
                valor = token;
                token = null;
            } else if (chave.requerValor) {
                valor = ++i < total ? this.args[i] : null;
            }
            this.argumentos.get(token).add(new Argumento(chave, valor));
        }
    }

    public List<Argumento> getArgumentos(String chave) {
        return this.argumentos.get(chave);
    }

    public List<Argumento> getArgumentos() {
        Collection<List<Argumento>> listas = this.argumentos.values();
        ArrayList<Argumento> todos = new ArrayList<Argumento>(listas.size());
        for (List<Argumento> lista : listas) {
            for (Argumento arg : lista) {
                todos.add(arg);
            }
        }
        return todos;
    }

    public int getTotalArgumentos(String chave) {
        return this.argumentos.get(chave).size();
    }

    public int getTotalArgumentos() {
        int total = 0;
        for (List<Argumento> lista : this.argumentos.values()) {
            total += lista.size();
        }
        return total;
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    public ChaveadosArgumentos processarArgumentos(ArgumentoProcessador argumentoSemChave) throws IllegalArgumentException {
        for (List<Argumento> lista : this.argumentos.values()) {
            for (Argumento arg : lista) {
                Chave chave = arg.chave;
                ArgumentoProcessador proc = chave != null ? chave.processador : argumentoSemChave;
                if (proc == null) continue;
                proc.processar(arg);
            }
        }
        return this;
    }

    public static abstract class AdaptadoArgumentoProcessador
    implements ArgumentoProcessador {
        @Override
        public final void processar(Argumento arg) throws IllegalArgumentException {
            this.processar(arg.chave, arg.valor);
        }

        public abstract void processar(Chave var1, String var2) throws IllegalArgumentException;
    }

    public static interface ArgumentoProcessador {
        public void processar(Argumento var1) throws IllegalArgumentException;
    }

    public static class Argumento {
        private Chave chave;
        private String valor;

        Argumento(Chave chave, String valor) {
            this.chave = chave;
            this.valor = valor;
        }

        public Chave getChave() {
            return this.chave;
        }

        public String getValor() {
            return this.valor;
        }
    }

    public static class Chave {
        private String token;
        private boolean requerValor;
        private ArgumentoProcessador processador;
        private String explicacao;

        public Chave(String token, boolean requerValor, ArgumentoProcessador processador, String explicacao) {
            if (token == null) {
                throw new IllegalArgumentException("token == null");
            }
            this.token = token;
            this.requerValor = requerValor;
            this.processador = processador;
            this.explicacao = explicacao;
        }

        public Chave(String token, boolean requerValor, ArgumentoProcessador processador) {
            this(token, requerValor, processador, null);
        }

        public Chave(String token, boolean requerValor) {
            this(token, requerValor, null, null);
        }

        public String getToken() {
            return this.token;
        }

        public boolean isRequerValor() {
            return this.requerValor;
        }

        public ArgumentoProcessador getProcessador() {
            return this.processador;
        }

        public String getExplicacao() {
            return this.explicacao;
        }
    }
}

