/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.console;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.tqc.console.Argumentos;
import com.joseflavio.tqc.console.Console;
import java.io.IOException;

public abstract class AplicacaoConsole
extends Console {
    private Console console;
    private Argumentos argumentos;
    private int corTextoInicial;
    private int corTextoFundoInicial;

    protected AplicacaoConsole(Console console) {
        super(console != null ? console.getCultura() : Cultura.getPadrao());
        this.console = console != null ? console : Console.novoConsole();
    }

    protected AplicacaoConsole(Cultura cultura) {
        this(Console.novoConsole(cultura));
    }

    protected AplicacaoConsole() {
        this((Console)null);
    }

    public final void inicio(String[] args) {
        this.corTextoInicial = this.getCorTexto();
        this.corTextoFundoInicial = this.getCorTextoFundo();
        Runtime.getRuntime().addShutdownHook(new SaidaThread());
        this.argumentos = this.processarArgumentos(args);
        if (this.argumentos == null) {
            throw new IllegalArgumentException("Argumentos == null");
        }
        this.principal();
    }

    protected abstract Argumentos processarArgumentos(String[] var1);

    protected abstract void principal();

    protected abstract void fim();

    public void setConsole(Console console) {
        this.console = console;
    }

    public Console getConsole() {
        return this.console;
    }

    public Argumentos getArgumentos() {
        return this.argumentos;
    }

    @Override
    public int getTotalColunas() {
        return this.console.getTotalColunas();
    }

    @Override
    public int getTotalLinhas() {
        return this.console.getTotalLinhas();
    }

    @Override
    public void setCorTexto(int cor) {
        this.console.setCorTexto(cor);
    }

    @Override
    public int getCorTexto() {
        return this.console.getCorTexto();
    }

    @Override
    public void setCorTextoFundo(int cor) {
        this.console.setCorTextoFundo(cor);
    }

    @Override
    public int getCorTextoFundo() {
        return this.console.getCorTextoFundo();
    }

    @Override
    public void limpar() {
        this.console.limpar();
    }

    @Override
    public char esperar(boolean mostrar) throws IOException {
        return this.console.esperar(mostrar);
    }

    @Override
    public void setTelaCheia(boolean cheia) {
        this.console.setTelaCheia(cheia);
    }

    @Override
    public String receber() throws IOException {
        return this.console.receber();
    }

    @Override
    public void enviar(String texto) {
        this.console.enviar(texto);
    }

    @Override
    public void enviarln(String texto) {
        this.console.enviarln(texto);
    }

    @Override
    public void enviarln() {
        this.console.enviarln();
    }

    @Override
    public void enviar(String formato, Object ... args) {
        this.console.enviar(formato, args);
    }

    private class SaidaThread
    extends Thread {
        private SaidaThread() {
        }

        @Override
        public void run() {
            AplicacaoConsole.this.setCorTexto(AplicacaoConsole.this.corTextoInicial);
            AplicacaoConsole.this.setCorTextoFundo(AplicacaoConsole.this.corTextoFundoInicial);
            AplicacaoConsole.this.fim();
        }
    }
}

