/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.aplicacao;

import com.joseflavio.modelo.AssistenteDeAtributo;
import com.joseflavio.modelo.JFData;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.aplicacao.AplicacaoTQC;
import com.joseflavio.tqc.aplicacao.BaseInformacao;
import com.joseflavio.tqc.aplicacao.Formulario;
import com.joseflavio.tqc.dado.Comando;
import com.joseflavio.tqc.dado.Data;
import com.joseflavio.tqc.dado.Inteiro;
import com.joseflavio.tqc.dado.Real;
import com.joseflavio.tqc.dado.Tabela;
import com.joseflavio.tqc.dado.TabelaColuna;
import com.joseflavio.tqc.dado.TabelaColunaFim;
import com.joseflavio.tqc.dado.TabelaFim;
import com.joseflavio.tqc.dado.TabelaLinha;
import com.joseflavio.tqc.dado.TabelaLinhaFim;
import com.joseflavio.tqc.dado.Texto;
import com.joseflavio.validacao.ValidacaoException;
import java.util.Date;

public abstract class Relatorio<TQC extends AplicacaoTQC>
extends BaseInformacao<TQC> {
    private String tituloRelatorio;

    public Relatorio(TQC aplicacao, String tituloInformacao, String banner, String tituloRelatorio) throws TomaraQueCaiaException {
        super(aplicacao, tituloInformacao, banner, null);
        this.tituloRelatorio = tituloRelatorio;
    }

    public Relatorio(TQC aplicacao, String tituloInformacao, String tituloRelatorio) throws TomaraQueCaiaException {
        this(aplicacao, tituloInformacao, (String)null, tituloRelatorio);
    }

    @Override
    protected void construir() throws TomaraQueCaiaException {
        super.construir();
        if (this.tituloRelatorio != null) {
            this.maisQuebraDeLinha();
            this.maisLinhaCentral();
            this.mais(new Texto(this.tituloRelatorio).setEstilo("relatorioTitulo"));
            this.maisLinhaFim();
        }
        this.maisMarcador("tqc_relatorio_corpo_i");
        this.corpo();
        this.maisMarcador("tqc_relatorio_corpo_f");
    }

    public String getTituloRelatorio() {
        return this.tituloRelatorio;
    }

    protected abstract void corpo() throws TomaraQueCaiaException;

    @Override
    protected void acao(Viagem viagem, Comando comando) throws ValidacaoException, TomaraQueCaiaException {
    }

    protected void abrirSessao() {
        this.mais(new Tabela("relatorioSessao"));
        this.mais(new TabelaLinha());
        this.mais(new TabelaColuna());
        this.maisMarcador("tqc_relatorio_sessao_i");
    }

    protected void fecharSessao() {
        this.maisMarcador("tqc_relatorio_sessao_f");
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaLinhaFim());
        this.mais(new TabelaFim());
    }

    protected Texto normal(String texto) {
        return (Texto)new Texto(texto).setEstilo("relatorioNormal");
    }

    protected Texto negrito(String texto) {
        return (Texto)new Texto(texto).setEstilo("relatorioNegrito");
    }

    protected void maisNormal(String texto) {
        this.maisTexto(texto).setEstilo("relatorioNormal");
    }

    protected void maisNegrito(String texto) {
        this.maisTexto(texto).setEstilo("relatorioNegrito");
    }

    protected void abrirListaDeAtributos() {
        this.mais(new Tabela("largura100Porc"));
        this.maisMarcador("tqc_relatorio_lista_i");
    }

    protected void fecharListaDeAtributos() {
        this.maisMarcador("tqc_relatorio_lista_f");
        this.mais(new TabelaFim());
    }

    protected void maisAtributo(String rotulo, String valor) {
        this.mais(new TabelaLinha());
        this.mais(new TabelaColuna("relatorioColunaRotulo"));
        this.maisMarcador("tqc_relatorio_lista_rotulo_i");
        this.maisNormal(rotulo);
        this.maisMarcador("tqc_relatorio_lista_rotulo_f");
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaColuna("relatorioColunaValor"));
        this.maisMarcador("tqc_relatorio_lista_valor_i");
        this.maisNegrito(valor);
        this.maisMarcador("tqc_relatorio_lista_valor_f");
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaLinhaFim());
    }

    protected void maisAtributo(String rotulo, Dado valor) {
        this.mais(new TabelaLinha());
        this.mais(new TabelaColuna("relatorioColunaRotulo"));
        this.maisMarcador("tqc_relatorio_lista_rotulo_i");
        this.maisNormal(rotulo);
        this.maisMarcador("tqc_relatorio_lista_rotulo_f");
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaColuna("relatorioColunaValor"));
        this.maisMarcador("tqc_relatorio_lista_valor_i");
        this.mais(valor);
        this.maisMarcador("tqc_relatorio_lista_valor_f");
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaLinhaFim());
    }

    protected void maisAtributoTexto(Class<? extends Object> classe, String atributo, String valor) {
        this.maisAtributo(Formulario.getRotulo(classe, atributo), new Texto(null, classe, atributo, valor, false).setEstilo("relatorioNegrito"));
    }

    protected void maisAtributoObjeto(Class<? extends Object> classe, String atributo, Object valor) {
        this.maisAtributo(Formulario.getRotulo(classe, atributo), valor != null ? valor.toString() : "");
    }

    protected void maisAtributoData(Class<? extends Object> classe, String atributo, Date valor) {
        switch (AssistenteDeAtributo.getAnotacao(classe, atributo, JFData.class, true).tipo()) {
            case DATA: {
                this.maisAtributo(Formulario.getRotulo(classe, atributo), new Data(valor, Data.DataTipo.DATA).setEstilo("relatorioNegrito"));
                break;
            }
            case HORA: {
                this.maisAtributo(Formulario.getRotulo(classe, atributo), new Data(valor, Data.DataTipo.HORA).setEstilo("relatorioNegrito"));
                break;
            }
            default: {
                this.maisAtributo(Formulario.getRotulo(classe, atributo), new Data(valor, Data.DataTipo.DATA_HORA).setEstilo("relatorioNegrito"));
            }
        }
    }

    protected void maisAtributoInteiro(Class<? extends Object> classe, String atributo, Long valor) {
        this.maisAtributo(Formulario.getRotulo(classe, atributo), new Inteiro(null, classe, atributo, valor, false).setEstilo("relatorioNegrito"));
    }

    protected void maisAtributoReal(Class<? extends Object> classe, String atributo, Double valor) {
        this.maisAtributo(Formulario.getRotulo(classe, atributo), new Real(null, classe, atributo, valor, (Boolean)false).setEstilo("relatorioNegrito"));
    }

    protected void maisAtributoBinario(Class<? extends Object> classe, String atributo, Boolean valor, String valorVerdadeiro, String valorFalso) {
        this.maisAtributo(Formulario.getRotulo(classe, atributo), valor != null && valor != false ? valorVerdadeiro : valorFalso);
    }
}

