/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.aplicacao;

import com.joseflavio.CapturaDeExcecao;
import com.joseflavio.tqc.AcionamentoDeComando;
import com.joseflavio.tqc.EspacoTextual;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.aplicacao.AplicacaoTQC;
import com.joseflavio.tqc.aplicacao.BaseInformacao;
import com.joseflavio.tqc.dado.Comando;
import com.joseflavio.tqc.dado.Linha;
import com.joseflavio.tqc.dado.LinhaFim;
import com.joseflavio.tqc.dado.Marcador;
import com.joseflavio.tqc.dado.Texto;
import com.joseflavio.validacao.ValidacaoException;

public class Questionamento<T extends AplicacaoTQC>
extends BaseInformacao<T> {
    private AcionamentoDeComando questionador;
    private CapturaDeExcecao capturaDeExcecao;
    private Marcador marcadorMensagem = new Marcador();
    private Marcador marcadorResposta = new Marcador();
    private boolean primeiraResposta = true;

    public Questionamento(T aplicacao, String titulo, String banner, AcionamentoDeComando questionador, CapturaDeExcecao capturaDeExcecao) throws TomaraQueCaiaException {
        super(aplicacao, titulo, banner, null);
        this.questionador = questionador;
        this.capturaDeExcecao = capturaDeExcecao;
        this.construir();
        this.maisQuebraDeLinha();
        this.maisLinhaCentral();
        this.mais(this.marcadorMensagem);
        this.maisLinhaFim();
        this.maisQuebraDeLinha();
        this.maisLinhaCentral();
        this.mais(this.marcadorResposta);
        this.maisLinhaFim();
    }

    public Questionamento(T aplicacao, String titulo, String banner, AcionamentoDeComando questionador) throws TomaraQueCaiaException {
        this(aplicacao, titulo, null, questionador, null);
    }

    public Questionamento(T aplicacao, String titulo, AcionamentoDeComando questionador, CapturaDeExcecao capturaDeExcecao) throws TomaraQueCaiaException {
        this(aplicacao, titulo, null, questionador, capturaDeExcecao);
    }

    public Questionamento(T aplicacao, String titulo, AcionamentoDeComando questionador) throws TomaraQueCaiaException {
        this(aplicacao, titulo, questionador, null);
    }

    public Questionamento<T> maisMensagem(String texto) {
        int pos = this.getIndice(this.marcadorMensagem);
        this.mais(new Linha("centroH"), pos++);
        this.mais(new Texto(texto).setEstilo("questMensagem"), pos++);
        this.mais(new LinhaFim(), pos++);
        return this;
    }

    public Questionamento<T> maisResposta(Comando comando) {
        if (comando.getEstilo() == null) {
            comando.setEstilo("questComandoResposta");
        }
        int pos = this.getIndice(this.marcadorResposta);
        if (!this.primeiraResposta) {
            this.mais(new EspacoTextual(1), pos++);
        }
        this.mais(comando, pos);
        this.primeiraResposta = false;
        return this;
    }

    @Override
    protected void acao(Viagem viagem, Comando comando) throws ValidacaoException, TomaraQueCaiaException {
        try {
            if (this.questionador != null) {
                this.questionador.acao(this.aplicacao, viagem, comando);
            }
        }
        catch (TomaraQueCaiaException e) {
            if (this.capturaDeExcecao != null) {
                this.capturaDeExcecao.capturar(e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.capturaDeExcecao != null) {
                this.capturaDeExcecao.capturar(e);
            }
            if (e instanceof ValidacaoException) {
                throw (ValidacaoException)e;
            }
            throw new TomaraQueCaiaException(e);
        }
    }
}

