/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.aplicacao;

import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.aplicacao.AplicacaoTQC;
import com.joseflavio.tqc.aplicacao.BaseInformacao;
import com.joseflavio.tqc.aplicacao.Rodape;
import com.joseflavio.tqc.dado.Comando;
import com.joseflavio.tqc.molde.ListaMolde;
import java.util.ArrayList;
import java.util.List;

public abstract class Listagem<TQC extends AplicacaoTQC, ELEMENTO>
extends BaseInformacao<TQC>
implements Rodape {
    private ListaMolde<ELEMENTO> listaMolde = new ListaMolde();
    private boolean primeiraAmostragem = true;
    private boolean autoAtualizar = true;
    private int totalDeComandos = 0;

    public Listagem(TQC aplicacao, String titulo, String banner, String subtitulo, boolean subtituloCentral) throws TomaraQueCaiaException {
        super(aplicacao, titulo, banner, subtitulo, subtituloCentral);
        this.listaMolde.setMarcadorInicial("tqc_listagem_i").setMarcadorFinal("tqc_listagem_f");
        this.listaMolde.setColunas(new ArrayList());
        this.listaMolde.setLista(new ArrayList());
    }

    public Listagem(TQC aplicacao, String titulo, String subtitulo, boolean subtituloCentral) throws TomaraQueCaiaException {
        this(aplicacao, titulo, (String)null, subtitulo, subtituloCentral);
    }

    public Listagem(TQC aplicacao, String titulo, String banner, String subtitulo) throws TomaraQueCaiaException {
        this(aplicacao, titulo, banner, subtitulo, false);
    }

    public Listagem(TQC aplicacao, String titulo, String subtitulo) throws TomaraQueCaiaException {
        this(aplicacao, titulo, (String)null, subtitulo, false);
    }

    @Override
    protected void construir() throws TomaraQueCaiaException {
        super.construir();
        this.listaMolde.getColunas().clear();
        this.colunas();
        this.listaMolde.getLista().clear();
        this.objetos(this.listaMolde.getLista());
        this.listaMolde.construir(this);
        this.maisQuebraDeLinha();
        this.comandosPrincipais();
        this.maisQuebraDeLinha();
        this.rodapeDaInformacao();
    }

    protected abstract void colunas() throws TomaraQueCaiaException;

    protected abstract void objetos(List<ELEMENTO> var1) throws TomaraQueCaiaException;

    @Override
    public final void rodapeDaInformacao() throws TomaraQueCaiaException {
        this.maisMarcador("tqc_rodape_i");
        this.rodape();
        this.maisMarcador("tqc_rodape_f");
    }

    protected void rodape() throws TomaraQueCaiaException {
    }

    protected final Listagem<TQC, ELEMENTO> maisColuna(ListaMolde.ListaColuna<ELEMENTO> coluna) {
        this.listaMolde.maisColuna(coluna);
        return this;
    }

    protected final Listagem<TQC, ELEMENTO> maisColunaTexto(Class<? extends Object> classe, String atributo) {
        this.listaMolde.maisColunaTexto(classe, atributo);
        return this;
    }

    protected final Listagem<TQC, ELEMENTO> maisColunaData(Class<? extends Object> classe, String atributo) {
        this.listaMolde.maisColunaData(classe, atributo);
        return this;
    }

    protected final Listagem<TQC, ELEMENTO> maisColunaInteiro(Class<? extends Object> classe, String atributo) {
        this.listaMolde.maisColunaInteiro(classe, atributo);
        return this;
    }

    protected final Listagem<TQC, ELEMENTO> maisColunaReal(Class<? extends Object> classe, String atributo) {
        this.listaMolde.maisColunaReal(classe, atributo);
        return this;
    }

    protected final Listagem<TQC, ELEMENTO> maisColunaBinario(Class<? extends Object> classe, String atributo, String valorVerdadeiro, String valorFalso) {
        this.listaMolde.maisColunaBinario(classe, atributo, valorVerdadeiro, valorFalso);
        return this;
    }

    protected final Listagem<TQC, ELEMENTO> maisColunaConversao(Class<? extends Object> classe, String atributo, Object[] lista, String original, String convertido) {
        this.listaMolde.maisColunaConversao(classe, atributo, lista, original, convertido);
        return this;
    }

    protected final Listagem<TQC, ELEMENTO> mais(Comando comando) {
        ++this.totalDeComandos;
        comando.setEspacoTextualPosterior(false);
        this.maisMarcador("tqc_comando_" + this.totalDeComandos + "_i");
        this.mais(comando);
        this.maisMarcador("tqc_comando_" + this.totalDeComandos + "_f");
        return this;
    }

    public void atualizar() throws TomaraQueCaiaException {
        this.listaMolde.getColunas().clear();
        this.colunas();
        this.listaMolde.getLista().clear();
        this.objetos(this.listaMolde.getLista());
        this.listaMolde.atualizar(this);
    }

    public ELEMENTO getElemento(int indice) {
        return this.listaMolde.getLista().get(indice);
    }

    public Listagem<TQC, ELEMENTO> setFiltro(ListaMolde.ListaFiltro<ELEMENTO> filtro) {
        this.listaMolde.setFiltro(filtro);
        return this;
    }

    public int getTotalDeLinhas() {
        return this.listaMolde.getLista().size();
    }

    @Override
    protected final void antesDeMostrar(Viagem viagem) throws TomaraQueCaiaException {
        if (this.primeiraAmostragem) {
            this.primeiraAmostragem = false;
        } else if (this.autoAtualizar) {
            this.atualizar();
        }
        this.antesDeMostrarListagem(viagem);
    }

    protected void antesDeMostrarListagem(Viagem viagem) throws TomaraQueCaiaException {
    }

    public void setAutoAtualizar(boolean autoAtualizar) {
        this.autoAtualizar = autoAtualizar;
    }

    public boolean isAutoAtualizar() {
        return this.autoAtualizar;
    }
}

