/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.aplicacao;

import com.joseflavio.modelo.AssistenteDeAtributo;
import com.joseflavio.modelo.JFApresentacao;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.aplicacao.AplicacaoTQC;
import com.joseflavio.tqc.aplicacao.BaseInformacao;
import com.joseflavio.tqc.aplicacao.Rodape;
import com.joseflavio.tqc.dado.Arquivo;
import com.joseflavio.tqc.dado.Binario;
import com.joseflavio.tqc.dado.Bruto;
import com.joseflavio.tqc.dado.Comando;
import com.joseflavio.tqc.dado.Data;
import com.joseflavio.tqc.dado.Inteiro;
import com.joseflavio.tqc.dado.Real;
import com.joseflavio.tqc.dado.Selecao;
import com.joseflavio.tqc.dado.SelecaoMultipla;
import com.joseflavio.tqc.dado.SelecionavelTexto;
import com.joseflavio.tqc.dado.Senha;
import com.joseflavio.tqc.dado.Tabela;
import com.joseflavio.tqc.dado.TabelaColuna;
import com.joseflavio.tqc.dado.TabelaColunaFim;
import com.joseflavio.tqc.dado.TabelaFim;
import com.joseflavio.tqc.dado.TabelaLinha;
import com.joseflavio.tqc.dado.TabelaLinhaFim;
import com.joseflavio.tqc.dado.Texto;
import com.joseflavio.util.Lista;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public abstract class Formulario<TQC extends AplicacaoTQC>
extends BaseInformacao<TQC>
implements Rodape {
    private int totalDeCampos = 0;

    public Formulario(TQC aplicacao, String titulo, String banner, String subtitulo, boolean subtituloCentral) throws TomaraQueCaiaException {
        super(aplicacao, titulo, banner, subtitulo, subtituloCentral);
        this.setAutoValidarTudo(false);
    }

    public Formulario(TQC aplicacao, String titulo, String subtitulo, boolean subtituloCentral) throws TomaraQueCaiaException {
        this(aplicacao, titulo, (String)null, subtitulo, subtituloCentral);
    }

    public Formulario(TQC aplicacao, String titulo, String banner, String subtitulo) throws TomaraQueCaiaException {
        this(aplicacao, titulo, banner, subtitulo, false);
    }

    public Formulario(TQC aplicacao, String titulo, String subtitulo) throws TomaraQueCaiaException {
        this(aplicacao, titulo, (String)null, subtitulo, false);
    }

    public Formulario(TQC aplicacao, String titulo_subtitulo) throws TomaraQueCaiaException {
        this(aplicacao, titulo_subtitulo, (String)null, titulo_subtitulo, false);
    }

    @Override
    protected void construir() throws TomaraQueCaiaException {
        super.construir();
        this.mais(new Tabela());
        this.maisMarcador("tqc_formulario_campos_i");
        this.campos();
        this.maisMarcador("tqc_formulario_campos_f");
        this.mais(new TabelaLinha());
        this.mais(new TabelaColuna());
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaColuna());
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaLinhaFim());
        this.mais(new TabelaLinha());
        this.mais(new TabelaColuna());
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaColuna("esquerda"));
        this.comandosPrincipais();
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaLinhaFim());
        this.mais(new TabelaFim());
        this.rodapeDaInformacao();
    }

    protected abstract void campos() throws TomaraQueCaiaException;

    @Override
    public final void rodapeDaInformacao() throws TomaraQueCaiaException {
        this.maisMarcador("tqc_rodape_i");
        this.rodape();
        this.maisMarcador("tqc_rodape_f");
    }

    protected void rodape() throws TomaraQueCaiaException {
    }

    public int getTotalDeCampos() {
        return this.totalDeCampos;
    }

    public int getTotalDeCamposVisiveis() {
        int total = 0;
        for (Dado dado : this.getDadosPuros()) {
            String nome;
            if (!dado.isVisivel() || !(dado instanceof Texto) || (nome = ((Texto)dado).getNome()) == null || !nome.startsWith("tqc_formulario_rotulo_")) continue;
            ++total;
        }
        return total;
    }

    protected final Formulario<TQC> maisCampo(String rotulo, Dado campo) {
        ++this.totalDeCampos;
        this.mais(new TabelaLinha());
        this.mais(new TabelaColuna("formColunaRotulo"));
        this.mais(new Texto("tqc_formulario_rotulo_" + this.totalDeCampos, rotulo).setEstilo("formRotulo"));
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaColuna("formColunaValor"));
        this.maisMarcador("tqc_formulario_campo_" + this.totalDeCampos + "_i");
        this.mais(campo);
        this.maisMarcador("tqc_formulario_campo_" + this.totalDeCampos + "_f");
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaLinhaFim());
        return this;
    }

    protected final Formulario<TQC> maisCampo(String rotulo, Dado ... dadosDoCampo) {
        ++this.totalDeCampos;
        this.mais(new TabelaLinha());
        this.mais(new TabelaColuna("formColunaRotulo"));
        this.mais(new Texto("tqc_formulario_rotulo_" + this.totalDeCampos, rotulo).setEstilo("formRotulo"));
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaColuna("formColunaValor"));
        this.maisMarcador("tqc_formulario_campo_" + this.totalDeCampos + "_i");
        for (Dado d : dadosDoCampo) {
            this.mais(d);
        }
        this.maisMarcador("tqc_formulario_campo_" + this.totalDeCampos + "_f");
        this.mais(new TabelaColunaFim());
        this.mais(new TabelaLinhaFim());
        return this;
    }

    protected final Formulario<TQC> maisComando(Comando comando) {
        comando.setEspacoTextualPosterior(false);
        this.mais(comando);
        return this;
    }

    protected final Formulario<TQC> maisCampo(String rotulo, List<? extends Dado> dadosDoCampo) {
        return this.maisCampo(rotulo, dadosDoCampo.toArray(new Dado[dadosDoCampo.size()]));
    }

    protected final Formulario<TQC> maisCampo(String rotulo, String valor) {
        return this.maisCampo(rotulo, (Dado)new Texto(valor));
    }

    public static String getApresentacao(Class<? extends Object> classe, String atributo) {
        JFApresentacao jfApresentacao = AssistenteDeAtributo.getAnotacao(classe, atributo, JFApresentacao.class, false);
        return jfApresentacao != null ? jfApresentacao.value() : atributo;
    }

    public static String getRotulo(Class<? extends Object> classe, String atributo) {
        JFApresentacao jfApresentacao = AssistenteDeAtributo.getAnotacao(classe, atributo, JFApresentacao.class, false);
        return (jfApresentacao != null ? jfApresentacao.value() : atributo) + ":";
    }

    public static Texto getRotuloFormatado(Class<? extends Object> classe, String atributo) {
        return (Texto)new Texto(Formulario.getRotulo(classe, atributo)).setEstilo("formRotulo");
    }

    public static Texto getRotulo(String texto) {
        return (Texto)new Texto(texto).setEstilo("formRotulo");
    }

    protected Texto maisCampoTexto(String nome, Class<? extends Object> classe, String atributo, String texto, Boolean editavel) {
        Texto dado = new Texto(nome, classe, atributo, texto, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    @Override
    public Texto maisTexto(String nome, Class<? extends Object> classe, String atributo, String texto, Boolean editavel) {
        Texto dado = new Texto(nome, classe, atributo, texto, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    protected Texto maisCampoTexto(String nome, Class<? extends Object> classe, String texto, Boolean editavel) {
        return this.maisCampoTexto(nome, classe, nome, texto, editavel);
    }

    protected Senha maisCampoSenha(String nome, Class<? extends Object> classe, String atributo, String senha, Boolean editavel) {
        Senha dado = new Senha(nome, classe, atributo, senha, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    @Override
    public Senha maisSenha(String nome, Class<? extends Object> classe, String atributo, String senha, Boolean editavel) {
        Senha dado = new Senha(nome, classe, atributo, senha, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    protected Senha maisCampoSenha(String nome, Class<? extends Object> classe, String senha, Boolean editavel) {
        return this.maisCampoSenha(nome, classe, nome, senha, editavel);
    }

    protected Data maisCampoData(String nome, Class<? extends Object> classe, String atributo, Date data, Boolean editavel) {
        Data dado = new Data(nome, classe, atributo, data, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    @Override
    public Data maisData(String nome, Class<? extends Object> classe, String atributo, Date data, Boolean editavel) {
        Data dado = new Data(nome, classe, atributo, data, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    protected Data maisCampoData(String nome, Class<? extends Object> classe, Date data, Boolean editavel) {
        return this.maisCampoData(nome, classe, nome, data, editavel);
    }

    protected Real maisCampoReal(String nome, Class<? extends Object> classe, String atributo, Double numero, Boolean editavel) {
        Real dado = new Real(nome, classe, atributo, numero, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    @Override
    public Real maisReal(String nome, Class<? extends Object> classe, String atributo, Double numero, Boolean editavel) {
        Real dado = new Real(nome, classe, atributo, numero, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    protected Real maisCampoReal(String nome, Class<? extends Object> classe, Double numero, Boolean editavel) {
        return this.maisCampoReal(nome, classe, nome, numero, editavel);
    }

    protected Inteiro maisCampoInteiro(String nome, Class<? extends Object> classe, String atributo, Long numero, Boolean editavel) {
        Inteiro dado = new Inteiro(nome, classe, atributo, numero, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    @Override
    public Inteiro maisInteiro(String nome, Class<? extends Object> classe, String atributo, Long numero, Boolean editavel) {
        Inteiro dado = new Inteiro(nome, classe, atributo, numero, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    protected Inteiro maisCampoInteiro(String nome, Class<? extends Object> classe, Long numero, Boolean editavel) {
        return this.maisCampoInteiro(nome, classe, nome, numero, editavel);
    }

    protected Inteiro maisCampoInteiro(String nome, Class<? extends Object> classe, Integer numero, Boolean editavel) {
        return this.maisCampoInteiro(nome, classe, nome, numero != null ? new Long(numero.longValue()) : null, editavel);
    }

    protected <T> Selecao<T> maisCampoSelecao(String nome, Class<? extends Object> classe, String atributo, List<T> opcoes, T selecaoInicial, Boolean editavel) {
        Selecao<T> dado = new Selecao<T>(nome, classe, atributo, opcoes, selecaoInicial, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    @Override
    public <T> Selecao<T> maisSelecao(String nome, Class<? extends Object> classe, String atributo, List<T> opcoes, T selecaoInicial, Boolean editavel) {
        Selecao<T> dado = new Selecao<T>(nome, classe, atributo, opcoes, selecaoInicial, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    protected <T> Selecao<T> maisCampoSelecao(String nome, Class<? extends Object> classe, List<T> opcoes, T selecaoInicial, Boolean editavel) {
        return this.maisCampoSelecao(nome, classe, nome, opcoes, selecaoInicial, editavel);
    }

    protected <T> Selecao<T> maisCampoSelecao(String nome, Class<? extends Object> classe, List<T> opcoes, Boolean editavel) {
        return this.maisCampoSelecao(nome, classe, nome, opcoes, null, editavel);
    }

    protected <T> Selecao<T> maisCampoSelecao(String nome, Class<? extends Object> classe, Boolean editavel) {
        return this.maisCampoSelecao(nome, classe, nome, (List)null, null, editavel);
    }

    protected <T> Selecao<T> maisCampoSelecao(String nome, Class<? extends Object> classe, T selecaoInicial, Boolean editavel) {
        return this.maisCampoSelecao(nome, classe, nome, (List)null, selecaoInicial, editavel);
    }

    protected <T> Selecao<T> maisCampoSelecao(String nome, Class<? extends Object> classe, String atributo, T[] opcoes, T selecaoInicial, Boolean editavel) {
        return this.maisCampoSelecao(nome, classe, atributo, Arrays.asList(opcoes), selecaoInicial, editavel);
    }

    protected <T> Selecao<T> maisCampoSelecao(String nome, Class<? extends Object> classe, T[] opcoes, T selecaoInicial, Boolean editavel) {
        return this.maisCampoSelecao(nome, classe, nome, Arrays.asList(opcoes), selecaoInicial, editavel);
    }

    protected <T> Selecao<T> maisCampoSelecao(String nome, Class<? extends Object> classe, T[] opcoes, Boolean editavel) {
        return this.maisCampoSelecao(nome, classe, nome, Arrays.asList(opcoes), null, editavel);
    }

    protected <T> SelecaoMultipla<T> maisCampoSelecaoMultipla(String nome, Class<? extends Object> classe, String atributo, List<T> opcoes, List<T> selecaoInicial, Boolean editavel) {
        SelecaoMultipla<T> dado = new SelecaoMultipla<T>(nome, classe, atributo, opcoes, selecaoInicial, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    @Override
    public <T> SelecaoMultipla<T> maisSelecaoMultipla(String nome, Class<? extends Object> classe, String atributo, List<T> opcoes, List<T> selecaoInicial, Boolean editavel) {
        SelecaoMultipla<T> dado = new SelecaoMultipla<T>(nome, classe, atributo, opcoes, selecaoInicial, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    protected <T> SelecaoMultipla<T> maisCampoSelecaoMultipla(String nome, Class<? extends Object> classe, List<T> opcoes, List<T> selecaoInicial, Boolean editavel) {
        return this.maisCampoSelecaoMultipla(nome, classe, nome, opcoes, selecaoInicial, editavel);
    }

    protected <T> SelecaoMultipla<T> maisCampoSelecaoMultipla(String nome, Class<? extends Object> classe, T[] opcoes, T[] selecaoInicial, Boolean editavel) {
        return this.maisCampoSelecaoMultipla(nome, classe, nome, new Lista<T>(opcoes), new Lista<T>(selecaoInicial), editavel);
    }

    protected <T> SelecaoMultipla<T> maisCampoSelecaoMultipla(String nome, Class<? extends Object> classe, Boolean editavel) {
        return this.maisCampoSelecaoMultipla(nome, classe, nome, null, null, editavel);
    }

    protected SelecionavelTexto maisCampoSelecionavelTexto(String nome, Class<? extends Object> classe, String atributo, String texto, List<String> opcoes, Boolean editavel) {
        SelecionavelTexto dado = new SelecionavelTexto(nome, classe, atributo, texto, opcoes, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    @Override
    public SelecionavelTexto maisSelecionavelTexto(String nome, Class<? extends Object> classe, String atributo, String texto, List<String> opcoes, Boolean editavel) {
        SelecionavelTexto dado = new SelecionavelTexto(nome, classe, atributo, texto, opcoes, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    protected SelecionavelTexto maisCampoSelecionavelTexto(String nome, Class<? extends Object> classe, String atributo, String texto, String[] opcoes, Boolean editavel) {
        return this.maisCampoSelecionavelTexto(nome, classe, atributo, texto, Arrays.asList(opcoes), editavel);
    }

    protected SelecionavelTexto maisCampoSelecionavelTexto(String nome, Class<? extends Object> classe, String texto, List<String> opcoes, Boolean editavel) {
        return this.maisCampoSelecionavelTexto(nome, classe, nome, texto, opcoes, editavel);
    }

    protected SelecionavelTexto maisCampoSelecionavelTexto(String nome, Class<? extends Object> classe, String texto, String[] opcoes, Boolean editavel) {
        return this.maisCampoSelecionavelTexto(nome, classe, nome, texto, Arrays.asList(opcoes), editavel);
    }

    protected Bruto maisCampoBruto(String nome, Class<? extends Object> classe, String atributo, byte[] valor, String valorRotulo, Boolean editavel) {
        Bruto dado = new Bruto(nome, classe, atributo, valor, valorRotulo, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    @Override
    public Bruto maisBruto(String nome, Class<? extends Object> classe, String atributo, byte[] valor, String valorRotulo, Boolean editavel) {
        Bruto dado = new Bruto(nome, classe, atributo, valor, valorRotulo, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    protected Bruto maisCampoBruto(String nome, Class<? extends Object> classe, byte[] valor, String valorRotulo, Boolean editavel) {
        return this.maisCampoBruto(nome, classe, nome, valor, valorRotulo, editavel);
    }

    protected Arquivo maisCampoArquivo(String nome, Class<? extends Object> classe, String atributo, File arquivo, File localPreferido, Boolean editavel) {
        Arquivo dado = new Arquivo(nome, classe, atributo, arquivo, localPreferido, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    @Override
    public Arquivo maisArquivo(String nome, Class<? extends Object> classe, String atributo, File arquivo, File localPreferido, Boolean editavel) {
        Arquivo dado = new Arquivo(nome, classe, atributo, arquivo, localPreferido, editavel);
        this.maisCampo(Formulario.getRotulo(classe, atributo), (Dado)dado);
        return dado;
    }

    protected Arquivo maisCampoArquivo(String nome, Class<? extends Object> classe, File arquivo, File localPreferido, Boolean editavel) {
        return this.maisCampoArquivo(nome, classe, nome, arquivo, localPreferido, editavel);
    }

    protected Binario maisCampoBinario(String nome, Class<? extends Object> classe, String atributo, Boolean valor, Boolean editavel) {
        Binario dado = new Binario(nome, classe, atributo, valor, editavel);
        this.maisCampo((String)null, (Dado)dado);
        return dado;
    }

    @Override
    public Binario maisBinario(String nome, Class<? extends Object> classe, String atributo, Boolean valor, Boolean editavel) {
        Binario dado = new Binario(nome, classe, atributo, valor, editavel);
        this.maisCampo((String)null, (Dado)dado);
        return dado;
    }

    protected Binario maisCampoBinario(String nome, Class<? extends Object> classe, Boolean valor, Boolean editavel) {
        return this.maisCampoBinario(nome, classe, nome, valor, editavel);
    }
}

