/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.aplicacao;

import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.aplicacao.ComandoImplementado;
import com.joseflavio.util.Instanciador;
import com.joseflavio.validacao.ValidacaoException;
import java.lang.reflect.InvocationTargetException;

public class ComandoVisitar
extends ComandoImplementado {
    private Instanciador<Informacao> instanciador;
    private boolean novaViagem;

    public ComandoVisitar(String nome, String rotulo, boolean novaViagem, Class<? extends Informacao> destino, Object ... parametros) {
        super(nome, rotulo);
        this.novaViagem = novaViagem;
        this.instanciador = new Instanciador<Informacao>(destino, parametros);
    }

    public ComandoVisitar(String rotulo, boolean novaViagem, Class<? extends Informacao> destino, Object ... parametros) {
        this(null, rotulo, novaViagem, destino, parametros);
    }

    public ComandoVisitar(String rotulo, Class<? extends Informacao> destino, Object ... parametros) {
        this(rotulo, false, destino, parametros);
    }

    @Override
    public void acao(Viagem viagem) throws ValidacaoException, TomaraQueCaiaException {
        try {
            if (this.novaViagem) {
                viagem.getTomaraQueCaia().novaViagem().visitar(this.instanciador.instanciar()).ativar();
            } else {
                viagem.visitar(this.instanciador.instanciar());
            }
        }
        catch (IllegalArgumentException e) {
            throw new TomaraQueCaiaException(e);
        }
        catch (InstantiationException e) {
            throw new TomaraQueCaiaException(e);
        }
        catch (IllegalAccessException e) {
            throw new TomaraQueCaiaException(e);
        }
        catch (InvocationTargetException e) {
            throw new TomaraQueCaiaException(e);
        }
    }
}

