/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.aplicacao;

import com.joseflavio.CapturaDeExcecao;
import com.joseflavio.tqc.AcionamentoDeComando;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.aplicacao.AplicacaoTQC;
import com.joseflavio.tqc.aplicacao.ComandoImplementado;
import com.joseflavio.tqc.aplicacao.Questionamento;
import com.joseflavio.tqc.dado.Comando;
import com.joseflavio.validacao.ValidacaoException;

public abstract class ComandoQuestionamento<T extends AplicacaoTQC>
extends ComandoImplementado
implements AcionamentoDeComando {
    private T aplicacao;
    private Comando cmdSim;
    private Comando cmdNao;
    private String pergunta;

    public ComandoQuestionamento(T aplicacao, String nome, String rotulo, String rotuloSim, String rotuloNao, String pergunta) {
        super(nome, rotulo);
        this.aplicacao = aplicacao;
        this.cmdSim = new Comando(rotuloSim);
        this.cmdNao = new Comando(rotuloNao);
        this.pergunta = pergunta;
    }

    public ComandoQuestionamento(T aplicacao, String rotulo, String rotuloSim, String rotuloNao, String pergunta) {
        this(aplicacao, null, rotulo, rotuloSim, rotuloNao, pergunta);
    }

    public ComandoQuestionamento(T aplicacao, String rotulo, String pergunta) {
        this(aplicacao, null, rotulo, "Sim", "N\u00e3o", pergunta);
    }

    @Override
    public final void acao(Viagem viagem) throws ValidacaoException, TomaraQueCaiaException {
        CapturaDeExcecao capturaDeExcecao = viagem.getAtual() instanceof CapturaDeExcecao ? (CapturaDeExcecao)((Object)viagem.getAtual()) : null;
        viagem.visitar(new Questionamento<T>(this.aplicacao, ((TomaraQueCaia)this.aplicacao).getTitulo(), null, this, capturaDeExcecao).maisMensagem(this.pergunta).maisResposta(this.cmdSim).maisResposta(this.cmdNao));
    }

    @Override
    public final void acao(TomaraQueCaia tqc, Viagem viagem, Comando comando) throws TomaraQueCaiaException {
        viagem.voltar();
        if (comando == this.cmdSim) {
            this.sim(this.aplicacao, viagem);
        } else if (comando == this.cmdNao) {
            this.nao(this.aplicacao, viagem);
        }
    }

    public abstract void sim(T var1, Viagem var2) throws TomaraQueCaiaException;

    public void nao(T aplicacao, Viagem viagem) throws TomaraQueCaiaException {
    }

    public String getPergunta() {
        return this.pergunta;
    }

    public void setPergunta(String pergunta) {
        this.pergunta = pergunta;
    }
}

