/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.aplicacao;

import com.joseflavio.CapturaDeExcecao;
import com.joseflavio.modelo.JFDica;
import com.joseflavio.tqc.Alerta;
import com.joseflavio.tqc.AnexoDica;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.Menu;
import com.joseflavio.tqc.OpcaoDeMenu;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.anotacao.TQCComando;
import com.joseflavio.tqc.aplicacao.AplicacaoTQC;
import com.joseflavio.tqc.aplicacao.BancoDeDadosException;
import com.joseflavio.tqc.aplicacao.Cabecalho;
import com.joseflavio.tqc.aplicacao.ComandoImplementado;
import com.joseflavio.tqc.aplicacao.ComandoPrincipal;
import com.joseflavio.tqc.dado.Comando;
import com.joseflavio.tqc.dado.ComandoPorMetodo;
import com.joseflavio.tqc.dado.Opcoes;
import com.joseflavio.util.ClassUtil;
import com.joseflavio.validacao.ValidacaoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseInformacao<A extends AplicacaoTQC>
extends Informacao
implements Cabecalho,
ComandoPrincipal,
ComandoPorMetodo,
CapturaDeExcecao {
    public static final String ESTILO_SUBTITULO = "formSubtitulo";
    public static final String ESTILO_MENSAGEM_ERRO = "formMensagemErro";
    public static final String ESTILO_MENSAGEM_INFORMACAO = "formMensagemInformacao";
    protected A aplicacao;
    private String banner;
    private String subtitulo;
    private boolean autoRetirarMensagens = true;
    private boolean autoValidarTudo = false;
    private boolean autoCriarAlerta = false;
    private boolean alertaMostrado = false;
    private boolean subtituloCentral = false;
    private Map<String, Method> metodosComandados = new HashMap<String, Method>();

    public BaseInformacao(A aplicacao, String titulo, String banner, String subtitulo, boolean subtituloCentral) throws TomaraQueCaiaException {
        super(titulo);
        this.aplicacao = aplicacao;
        this.subtitulo = subtitulo;
        this.subtituloCentral = subtituloCentral;
        this.banner = banner != null ? banner : ((AplicacaoTQC)aplicacao).getBanner();
        this.retirarMensagens();
        for (Method metodo : this.getMetodosComandados()) {
            TQCComando anotacao = metodo.getAnnotation(TQCComando.class);
            String nome = anotacao.nome();
            if (nome == null || nome.length() <= 0) continue;
            this.metodosComandados.put(nome, metodo);
        }
    }

    public BaseInformacao(A aplicacao, String titulo, String banner, String subtitulo) throws TomaraQueCaiaException {
        this(aplicacao, titulo, banner, subtitulo, false);
    }

    public BaseInformacao(A aplicacao, String titulo, String subtitulo, boolean subtituloCentral) throws TomaraQueCaiaException {
        this(aplicacao, titulo, null, subtitulo, subtituloCentral);
    }

    public BaseInformacao(A aplicacao, String titulo, String subtitulo) throws TomaraQueCaiaException {
        this(aplicacao, titulo, null, subtitulo, false);
    }

    protected void construir() throws TomaraQueCaiaException {
        this.cabecalhoDaInformacao();
    }

    @Override
    public final void cabecalhoDaInformacao() throws TomaraQueCaiaException {
        this.maisMarcador("tqc_cabecalho_i");
        this.cabecalho();
        this.maisMarcador("tqc_cabecalho_f");
    }

    protected void cabecalho() throws TomaraQueCaiaException {
    }

    @Override
    public final void comandosPrincipais() throws TomaraQueCaiaException {
        this.maisMarcador("tqc_comandos_i");
        this.comandos();
        Method[] metodosComandados = this.getMetodosComandados();
        Arrays.sort(metodosComandados, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int ordem2;
                int ordem1 = o1.getAnnotation(TQCComando.class).ordem();
                return ordem1 < (ordem2 = o2.getAnnotation(TQCComando.class).ordem()) ? -1 : (ordem1 > ordem2 ? 1 : 0);
            }
        });
        for (Method metodo : metodosComandados) {
            TQCComando anotacao = metodo.getAnnotation(TQCComando.class);
            if (!anotacao.adicionar()) continue;
            this.mais(this.getComando(metodo));
        }
        this.maisMarcador("tqc_comandos_f");
    }

    @Override
    public Method[] getMetodosComandados() {
        Class<?> classe = this.getClass();
        ArrayList<Method> metodosComandados = new ArrayList<Method>();
        HashMap<String, Boolean> mapaDeInsercao = new HashMap<String, Boolean>();
        for (Method metodo : ClassUtil.listarMetodos(classe)) {
            Class<?>[] parametros;
            Boolean inserido;
            TQCComando anotacao = metodo.getAnnotation(TQCComando.class);
            if (anotacao == null || (inserido = (Boolean)mapaDeInsercao.get(anotacao.nome())) != null && inserido.booleanValue() || (parametros = metodo.getParameterTypes()).length != 2 || parametros[0] != Viagem.class || parametros[1] != Comando.class) continue;
            metodosComandados.add(metodo);
            mapaDeInsercao.put(anotacao.nome(), true);
        }
        return metodosComandados.toArray(new Method[metodosComandados.size()]);
    }

    @Override
    public Comando getComando(Method metodoComandado) {
        TQCComando anotacao = metodoComandado.getAnnotation(TQCComando.class);
        if (anotacao == null) {
            throw new IllegalArgumentException("TQCComando ausente.");
        }
        String nome = anotacao.nome();
        if (nome == null || nome.length() == 0) {
            throw new IllegalArgumentException("TQCComando: nome inv\u00e1lido.");
        }
        Object dado = this.getDado(nome);
        if (dado != null && dado instanceof Comando) {
            return (Comando)dado;
        }
        String rotulo = anotacao.rotulo();
        String imagem = anotacao.imagem();
        Comando.Funcao funcao = anotacao.funcao();
        Comando comando = new Comando(nome, rotulo, imagem, funcao);
        JFDica jfDica = metodoComandado.getAnnotation(JFDica.class);
        if (jfDica != null) {
            comando.mais(new AnexoDica(jfDica.value()));
        }
        return comando;
    }

    @Override
    public Comando getComando(String nome) {
        Object dado = this.getDado(nome);
        if (dado != null && dado instanceof Comando) {
            return (Comando)dado;
        }
        Method metodo = this.metodosComandados.get(nome);
        if (metodo != null) {
            return this.getComando(metodo);
        }
        throw new IllegalArgumentException(nome);
    }

    protected void menu() throws TomaraQueCaiaException {
    }

    public BaseInformacao<A> maisOpcaoDeMenu(OpcaoDeMenu opcao) {
        Menu menu = this.getMenu();
        if (menu == null) {
            menu = new Menu("Menu");
            this.setMenu(menu);
        }
        menu.mais(opcao);
        return this;
    }

    protected void comandos() throws TomaraQueCaiaException {
    }

    @Override
    public final void antesDeMostrar(TomaraQueCaia tqc, Viagem viagem) throws TomaraQueCaiaException {
        if (this.getMenu() == null) {
            this.setMenu(new Menu("Menu"));
        }
        if (this.getMenu().getTotal() == 0) {
            this.menu();
        }
        for (Opcoes opcoes : this.getDados(Opcoes.class)) {
            try {
                opcoes.atualizarOpcoes();
            }
            catch (Exception e) {
                throw new TomaraQueCaiaException(e);
            }
        }
        this.antesDeMostrar(viagem);
        if (this.autoCriarAlerta && !this.alertaMostrado) {
            this.alertaMostrado = true;
            Alerta alerta = this.criarAlerta();
            if (alerta != null) {
                viagem.mostrar(alerta);
            }
        }
    }

    protected void antesDeMostrar(Viagem viagem) throws TomaraQueCaiaException {
    }

    @Override
    public final void acao(TomaraQueCaia tqc, Viagem viagem, Comando comando) throws TomaraQueCaiaException {
        if (this.autoRetirarMensagens) {
            this.retirarMensagens();
        }
        try {
            block15: {
                if (this.autoValidarTudo) {
                    this.validarTudo();
                }
                String comandoNome = comando.getNome();
                if (comando instanceof ComandoImplementado) {
                    ((ComandoImplementado)comando).acao(viagem);
                }
                try {
                    Method metodoAnotado = this.metodosComandados.get(comandoNome);
                    if (metodoAnotado != null) {
                        metodoAnotado.invoke((Object)this, viagem, comando);
                    }
                    if (metodoAnotado == null || !metodoAnotado.getName().equals(comandoNome)) {
                        try {
                            Method metodoHomonimo = this.getClass().getDeclaredMethod(comandoNome, Viagem.class, Comando.class);
                            metodoHomonimo.invoke((Object)this, viagem, comando);
                        }
                        catch (NoSuchMethodException e) {}
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getCause();
                    if (t == null) break block15;
                    throw (Exception)t;
                }
            }
            this.acao(viagem, comando);
        }
        catch (ValidacaoException e) {
            this.processarValidacaoException(e);
        }
        catch (TomaraQueCaiaException e) {
            if (e.getCause() instanceof ValidacaoException) {
                this.processarValidacaoException((ValidacaoException)e.getCause());
            }
            throw e;
        }
        catch (BancoDeDadosException e) {
            e.printStackTrace();
            this.setMensagemErro("Erro de Banco de Dados: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setMensagemErro("Erro desconhecido: " + e.getMessage());
        }
    }

    protected void acao(Viagem viagem, Comando comando) throws ValidacaoException, TomaraQueCaiaException {
    }

    private void processarValidacaoException(ValidacaoException e) {
        switch (e.getTipo()) {
            case 1: {
                this.setMensagemInformacao(e.getMensagem());
                break;
            }
            case 2: {
                this.setMensagemAtencao(e.getMensagem());
                break;
            }
            default: {
                this.setMensagemErro(e.getMensagem());
            }
        }
    }

    @Override
    public void capturar(Exception e) {
        if (e instanceof ValidacaoException) {
            this.processarValidacaoException((ValidacaoException)e);
        } else if (e.getCause() instanceof ValidacaoException) {
            this.processarValidacaoException((ValidacaoException)e.getCause());
        } else {
            this.setMensagemErro(e.getMessage());
        }
    }

    public void setSubtitulo(String subtitulo) {
        this.subtitulo = subtitulo;
    }

    public String getSubtitulo() {
        return this.subtitulo;
    }

    public boolean isSubtituloCentral() {
        return this.subtituloCentral;
    }

    public void setSubtituloCentral(boolean subtituloCentral) {
        this.subtituloCentral = subtituloCentral;
    }

    public void setBanner(String imagem) {
        this.banner = imagem;
    }

    public String getBanner() {
        return this.banner;
    }

    @Override
    public Informacao setMensagemErro(String mensagem) {
        this.alertaMostrado = false;
        return super.setMensagemErro(mensagem);
    }

    @Override
    public Informacao setMensagemAtencao(String mensagem) {
        this.alertaMostrado = false;
        return super.setMensagemAtencao(mensagem);
    }

    @Override
    public Informacao setMensagemInformacao(String mensagem) {
        this.alertaMostrado = false;
        return super.setMensagemInformacao(mensagem);
    }

    public boolean isAutoRetirarMensagens() {
        return this.autoRetirarMensagens;
    }

    public void setAutoRetirarMensagens(boolean autoRetirarMensagens) {
        this.autoRetirarMensagens = autoRetirarMensagens;
    }

    public boolean isAutoValidarTudo() {
        return this.autoValidarTudo;
    }

    public void setAutoValidarTudo(boolean autoValidarTudo) {
        this.autoValidarTudo = autoValidarTudo;
    }

    public boolean isAutoCriarAlerta() {
        return this.autoCriarAlerta;
    }

    public void setAutoCriarAlerta(boolean autoCriarAlerta) {
        this.autoCriarAlerta = autoCriarAlerta;
    }

    public Alerta criarAlerta() {
        if (this.getMensagemErro() != null) {
            return Alerta.novoErro(this.getTitulo(), this.getMensagemErro());
        }
        if (this.getMensagemAtencao() != null) {
            return Alerta.novaAtencao(this.getTitulo(), this.getMensagemAtencao());
        }
        if (this.getMensagemInformacao() != null) {
            return Alerta.novaInformacao(this.getTitulo(), this.getMensagemInformacao());
        }
        return null;
    }

    @Override
    public final Informacao criarAjuda(TomaraQueCaia tqc) throws TomaraQueCaiaException {
        return this.criarAjuda(this.aplicacao);
    }

    public BaseInformacao<A> criarAjuda(A aplicacao) throws TomaraQueCaiaException {
        return null;
    }
}

