/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc.aplicacao;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.jpa.JPAUtil;
import com.joseflavio.jpa.PersistenceUnit;
import com.joseflavio.jpa.PersistenceXML;
import com.joseflavio.tqc.EstiloFonte;
import com.joseflavio.tqc.aplicacao.AplicacaoTQC;
import com.joseflavio.tqc.aplicacao.BancoDeDadosException;
import com.joseflavio.validacao.ValidacaoException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

public abstract class AplicacaoTQC_JPA
extends AplicacaoTQC {
    private String persistenceUnitName;
    private PersistenceUnit persistenceUnit;
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private boolean autoAtualizar = false;
    private boolean autoDestacar = false;

    public AplicacaoTQC_JPA(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public AplicacaoTQC_JPA(String titulo, String persistenceUnitName, Cultura cultura, EstiloFonte estiloFonte) {
        super(titulo, cultura, estiloFonte);
        this.persistenceUnitName = persistenceUnitName;
    }

    public AplicacaoTQC_JPA(String titulo, String persistenceUnitName, Cultura cultura) {
        this(titulo, persistenceUnitName, cultura, null);
    }

    public synchronized PersistenceUnit getPersistenceUnit() throws BancoDeDadosException {
        try {
            if (this.persistenceUnit == null) {
                this.persistenceUnit = new PersistenceXML().getPersistenceUnit(this.persistenceUnitName);
            }
            return this.persistenceUnit;
        }
        catch (Exception e) {
            throw new BancoDeDadosException(e);
        }
    }

    public synchronized EntityManagerFactory getEntityManagerFactory() throws BancoDeDadosException {
        try {
            if (this.entityManagerFactory == null) {
                this.entityManagerFactory = Persistence.createEntityManagerFactory((String)this.persistenceUnitName);
            }
            return this.entityManagerFactory;
        }
        catch (Exception e) {
            throw new BancoDeDadosException(e);
        }
    }

    public synchronized EntityManager getEntityManager() throws BancoDeDadosException {
        try {
            EntityTransaction entityTransaction;
            if (this.entityManager == null || !this.entityManager.isOpen()) {
                this.entityManager = this.getEntityManagerFactory().createEntityManager();
            }
            if ((entityTransaction = this.entityManager.getTransaction()) != null && !entityTransaction.isActive()) {
                entityTransaction.begin();
            }
            return this.entityManager;
        }
        catch (BancoDeDadosException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BancoDeDadosException(e);
        }
    }

    @Override
    public synchronized void persistirPendencias() throws BancoDeDadosException {
        try {
            EntityTransaction entityTransaction = this.entityManager.getTransaction();
            if (entityTransaction != null && entityTransaction.isActive()) {
                entityTransaction.commit();
            }
            if (entityTransaction != null && !entityTransaction.isActive()) {
                entityTransaction.begin();
            }
        }
        catch (Exception e) {
            throw new BancoDeDadosException(e);
        }
    }

    public synchronized void cancelarPendencias() throws BancoDeDadosException {
        try {
            EntityTransaction entityTransaction = this.entityManager.getTransaction();
            if (entityTransaction != null && entityTransaction.isActive()) {
                entityTransaction.rollback();
            }
            if (entityTransaction != null && !entityTransaction.isActive()) {
                entityTransaction.begin();
            }
        }
        catch (Exception e) {
            throw new BancoDeDadosException(e);
        }
    }

    public synchronized void fecharEntityManagerFactory() {
        try {
            if (this.entityManagerFactory != null && this.entityManagerFactory.isOpen()) {
                this.entityManagerFactory.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.entityManagerFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fecharEntityManager() {
        EntityTransaction entityTransaction = this.entityManager.getTransaction();
        try {
            if (entityTransaction != null && entityTransaction.isActive()) {
                entityTransaction.commit();
            }
        }
        catch (Exception e) {
        }
        finally {
            entityTransaction = null;
        }
        try {
            if (this.entityManager != null && this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.entityManager = null;
        }
    }

    public synchronized void fecharBancoDeDados() {
        this.fecharEntityManager();
        this.fecharEntityManagerFactory();
    }

    @Override
    public void fim() {
        this.fecharBancoDeDados();
    }

    public <T> T persistir(T obj) {
        EntityManager em = this.getEntityManager();
        if (this.autoDestacar) {
            obj = em.merge(obj);
            this.persistirPendencias();
            em.detach(obj);
            return obj;
        }
        em.persist(obj);
        return obj;
    }

    public <T> T atualizar(T obj) {
        EntityManager em = this.getEntityManager();
        if (this.autoDestacar) {
            obj = em.merge(obj);
            em.refresh(obj);
            em.detach(obj);
            return obj;
        }
        em.refresh(obj);
        return obj;
    }

    public void remover(Object obj, String msgDependencia, boolean persistirPendencias) throws ValidacaoException, BancoDeDadosException {
        EntityManager em = this.getEntityManager();
        if (this.autoDestacar) {
            obj = em.merge(obj);
        }
        if (this.getPersistenceUnit().temReferencia(em, obj)) {
            throw ValidacaoException.novaAtencao(msgDependencia);
        }
        em.remove(obj);
        if (persistirPendencias) {
            this.persistirPendencias();
        }
    }

    public <T> List<T> listarLimitada(String query, int resultadoInicial, int maximoResultados, Object ... parametros) {
        List lista = JPAUtil.listarLimitada(this, query, resultadoInicial, maximoResultados, parametros);
        if (lista != null) {
            EntityManager em = this.getEntityManager();
            if (this.autoAtualizar) {
                lista = JPAUtil.atualizar(em, lista);
            }
            if (this.autoDestacar) {
                lista = JPAUtil.destacar(em, lista);
            }
        }
        return lista;
    }

    public <T> List<T> listar(String query, int resultadoInicial, int maximoResultados, Object ... parametros) {
        return this.listarLimitada(query, resultadoInicial, maximoResultados, parametros);
    }

    public <T> List<T> listarLimitada(String query, int resultadoInicial, int maximoResultados) {
        return this.listarLimitada(query, resultadoInicial, maximoResultados, null);
    }

    public <T> List<T> listar(String query, Object ... parametros) {
        List lista = JPAUtil.listar(this, query, parametros);
        if (lista != null) {
            EntityManager em = this.getEntityManager();
            if (this.autoAtualizar) {
                lista = JPAUtil.atualizar(em, lista);
            }
            if (this.autoDestacar) {
                lista = JPAUtil.destacar(em, lista);
            }
        }
        return lista;
    }

    public <T> T obter(String query, Object ... parametros) {
        Object obj = JPAUtil.obter(this, query, parametros);
        if (obj != null) {
            EntityManager em = this.getEntityManager();
            if (this.autoAtualizar) {
                em.refresh(obj);
            }
            if (this.autoDestacar) {
                em.detach(obj);
            }
        }
        return obj;
    }

    public long obterQuantidade(String query, Object ... parametros) {
        return JPAUtil.obterQuantidade(this, query, parametros);
    }

    public Number obterNumero(String query, Object ... parametros) {
        return JPAUtil.obterNumero(this, query, parametros);
    }

    public void setAutoAtualizar(boolean autoAtualizar) {
        this.autoAtualizar = autoAtualizar;
    }

    public boolean isAutoAtualizar() {
        return this.autoAtualizar;
    }

    public void setAutoDestacar(boolean autoDestacar) {
        this.autoDestacar = autoDestacar;
    }

    public boolean isAutoDestacar() {
        return this.autoDestacar;
    }
}

