/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc;

import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.Viagem;

public interface Viajante {
    public void viajar(TomaraQueCaia var1, Viagem var2) throws TomaraQueCaiaException;

    public static class VoltarSair
    implements Viajante {
        @Override
        public void viajar(TomaraQueCaia tqc, Viagem viagem) throws TomaraQueCaiaException {
            viagem.voltar();
            if (viagem.isEncerrada()) {
                return;
            }
            Informacao info = viagem.getAtual();
            if (info != null) {
                info.sair(viagem);
            }
        }
    }

    public static class Sair
    implements Viajante {
        @Override
        public void viajar(TomaraQueCaia tqc, Viagem viagem) throws TomaraQueCaiaException {
            Informacao info = viagem.getAtual();
            if (info != null) {
                info.sair(viagem);
            }
        }
    }

    public static class Encerrar
    implements Viajante {
        @Override
        public void viajar(TomaraQueCaia tqc, Viagem viagem) throws TomaraQueCaiaException {
            viagem.encerrar();
        }
    }

    public static class Voltar
    implements Viajante {
        @Override
        public void viajar(TomaraQueCaia tqc, Viagem viagem) throws TomaraQueCaiaException {
            viagem.voltar();
        }
    }
}

