/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc;

import com.joseflavio.tqc.Alerta;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.util.ListaUtil;
import java.util.ArrayList;
import java.util.List;

public final class Viagem {
    private TomaraQueCaia tqc;
    private String nome;
    private List<Informacao> lista = new ArrayList<Informacao>();
    private Alerta alerta;
    private long passo = 0L;

    Viagem(TomaraQueCaia tqc, String nome) {
        this.tqc = tqc;
        this.nome = nome;
    }

    public Viagem visitar(Informacao informacao) {
        if (informacao == null) {
            throw new IllegalArgumentException();
        }
        this.lista.add(informacao);
        ++this.passo;
        return this;
    }

    public Viagem voltar() {
        ListaUtil.menosUltimo(this.lista);
        if (this.lista.size() == 0) {
            this.encerrar();
        }
        ++this.passo;
        return this;
    }

    public Informacao getAtual() {
        return ListaUtil.getUltimo(this.lista);
    }

    public Informacao getAnterior() {
        if (this.lista == null || this.lista.size() <= 1) {
            return null;
        }
        return this.lista.get(this.lista.size() - 2);
    }

    public boolean isVazia() {
        return this.getAtual() == null;
    }

    public Viagem limpar() {
        this.lista.clear();
        this.alerta = null;
        ++this.passo;
        return this;
    }

    public Viagem mostrar(Alerta alerta) {
        this.alerta = alerta;
        return this;
    }

    public Alerta alerta() {
        return this.alerta;
    }

    public Alerta removerAlerta() {
        Alerta a = this.alerta;
        this.alerta = null;
        return a;
    }

    public Viagem ativar() {
        this.tqc.ativar(this);
        return this;
    }

    public void encerrar() {
        this.lista.clear();
        this.tqc.remover(this);
        this.tqc = null;
        this.lista = null;
        this.alerta = null;
    }

    public boolean isEncerrada() {
        return this.tqc == null;
    }

    public TomaraQueCaia getTomaraQueCaia() {
        return this.tqc;
    }

    public String getNome() {
        return this.nome;
    }

    public long getPasso() {
        return this.passo;
    }

    public Viagem novaViagem() {
        return this.tqc.novaViagem();
    }
}

