/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc;

import com.joseflavio.modelo.JFValidacaoNaoNulo;
import com.joseflavio.modelo.JFValidacaoPrimitiva;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Identificacao;
import com.joseflavio.tqc.SimplesDado;
import com.joseflavio.tqc.ValidacaoDeConteudo;
import com.joseflavio.validacao.MultiplaValidacao;
import com.joseflavio.validacao.NaoNuloValidacao;
import com.joseflavio.validacao.Validacao;
import java.lang.reflect.Field;

public abstract class ValidavelDado
extends SimplesDado
implements ValidacaoDeConteudo {
    private Validacao validacao;
    private Object conteudoInvalido;
    private String mensagemValidacaoPrimitiva;

    @Override
    public Validacao getValidacao() {
        return this.validacao;
    }

    @Override
    public Dado setValidacao(Validacao validacao) {
        this.validacao = validacao;
        return this;
    }

    @Override
    public Object getConteudoInvalido() {
        return this.conteudoInvalido;
    }

    @Override
    public Dado setConteudoInvalido(Object conteudo) {
        this.conteudoInvalido = conteudo;
        return this;
    }

    @Override
    public String getMensagemValidacaoPrimitiva() {
        return this.mensagemValidacaoPrimitiva;
    }

    @Override
    public Dado setMensagemValidacaoPrimitiva(String mensagem) {
        this.mensagemValidacaoPrimitiva = mensagem;
        return this;
    }

    public Validacao getValidacao(Class<? extends Validacao> classe) {
        Validacao v = this.validacao;
        if (v == null) {
            return null;
        }
        if (v instanceof MultiplaValidacao) {
            MultiplaValidacao mv = (MultiplaValidacao)v;
            int total = mv.getTotal();
            for (int i = 0; i < total; ++i) {
                v = mv.getValidacao(i);
                if (!classe.isAssignableFrom(v.getClass())) continue;
                return v;
            }
        } else if (classe.isAssignableFrom(v.getClass())) {
            return v;
        }
        return null;
    }

    public boolean isVazio() {
        return this.getConteudo() == null && this.getConteudoInvalido() == null;
    }

    @Override
    protected Dado configurarPor(Field atributo) {
        super.configurarPor(atributo);
        String nome = this instanceof Identificacao ? ((Identificacao)((Object)this)).getNome() : atributo.getName();
        JFValidacaoPrimitiva jfValidacaoPrimitiva = atributo.getAnnotation(JFValidacaoPrimitiva.class);
        JFValidacaoNaoNulo jfValidacaoNaoNulo = atributo.getAnnotation(JFValidacaoNaoNulo.class);
        if (jfValidacaoPrimitiva != null) {
            this.setMensagemValidacaoPrimitiva(jfValidacaoPrimitiva.erro());
        }
        if (jfValidacaoNaoNulo != null) {
            this.mais(new NaoNuloValidacao(nome, 3, jfValidacaoNaoNulo.erro()));
        }
        return this;
    }
}

