/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.cultura.DataTransformacao;
import com.joseflavio.cultura.NumeroTransformacao;
import com.joseflavio.tqc.EstiloFonte;
import com.joseflavio.tqc.Filtro;
import com.joseflavio.tqc.Informacao;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.util.Calendario;
import com.joseflavio.util.ListaUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public abstract class TomaraQueCaia {
    private Properties propriedades;
    private String titulo;
    private Cultura cultura = Cultura.getPadrao();
    private Map<String, FiltroMapa> filtros = new HashMap<String, FiltroMapa>();
    private List<EstiloFonte> estiloFontes = new ArrayList<EstiloFonte>();
    private List<Viagem> viagemLista = new ArrayList<Viagem>();
    private Map<String, Viagem> viagemMapa = new HashMap<String, Viagem>();
    private Viagem viagemAtiva = null;
    private int geradorNomeViagem = 1;
    private List<String> historicoDeAtivacao = new ArrayList<String>();
    private File raiz;
    private String direitosAutorais;
    private String pele = "padrao";
    private boolean autoEncerrarViagensVazias = true;
    public static final String ENDERECO_ICONE_PEQUENO = "img/iconep/";
    public static final String ICONE_PEQUENO_ABRIR = "img/iconep/abrir.png";
    public static final String ICONE_PEQUENO_ANEXO = "img/iconep/anexo.png";
    public static final String ICONE_PEQUENO_ATUALIZAR = "img/iconep/atualizar.png";
    public static final String ICONE_PEQUENO_AVANCAR = "img/iconep/avancar.png";
    public static final String ICONE_PEQUENO_CARTA = "img/iconep/carta.png";
    public static final String ICONE_PEQUENO_CHECADO = "img/iconep/checado.png";
    public static final String ICONE_PEQUENO_COLAR = "img/iconep/colar.png";
    public static final String ICONE_PEQUENO_COPIAR = "img/iconep/copiar.png";
    public static final String ICONE_PEQUENO_DESFAZER = "img/iconep/desfazer.png";
    public static final String ICONE_PEQUENO_DUVIDA = "img/iconep/duvida.png";
    public static final String ICONE_PEQUENO_EDITAR = "img/iconep/editar.png";
    public static final String ICONE_PEQUENO_IMPRIMIR = "img/iconep/imprimir.png";
    public static final String ICONE_PEQUENO_INFORMACAO = "img/iconep/informacao.png";
    public static final String ICONE_PEQUENO_MAIS = "img/iconep/mais.png";
    public static final String ICONE_PEQUENO_MENOS = "img/iconep/menos.png";
    public static final String ICONE_PEQUENO_NAO_CHECADO = "img/iconep/nao_checado.png";
    public static final String ICONE_PEQUENO_NOVO = "img/iconep/novo.png";
    public static final String ICONE_PEQUENO_RECORTAR = "img/iconep/recortar.png";
    public static final String ICONE_PEQUENO_RECUAR = "img/iconep/recuar.png";
    public static final String ICONE_PEQUENO_REMOVER = "img/iconep/remover.png";
    public static final String ICONE_PEQUENO_REPETIR = "img/iconep/repetir.png";
    public static final String ICONE_PEQUENO_SALVAR = "img/iconep/salvar.png";

    protected TomaraQueCaia() {
        try {
            this.propriedades = new Properties();
            this.propriedades.loadFromXML(TomaraQueCaia.class.getResourceAsStream("/META-INF/tqc.xml"));
        }
        catch (Exception e) {
            this.propriedades = null;
        }
        if (this.propriedades != null) {
            String tqc_titulo = this.propriedades.getProperty("tqc.titulo");
            String tqc_cultura = this.propriedades.getProperty("tqc.cultura");
            String tqc_pele = this.propriedades.getProperty("tqc.pele");
            if (tqc_titulo != null) {
                this.titulo = tqc_titulo;
            }
            if (tqc_cultura != null) {
                this.cultura = Cultura.getCultura(tqc_cultura);
            }
            if (tqc_pele != null) {
                this.pele = tqc_pele;
            }
        }
        this.direitosAutorais = "joseflavio.com &copy; 2009-" + new Calendario(this.cultura).getAno() + "\nSoftware Livre";
    }

    protected TomaraQueCaia(String titulo, Cultura cultura) {
        this();
        if (this.titulo == null && titulo != null) {
            this.titulo = titulo;
        }
        if (this.cultura == null && cultura != null) {
            this.cultura = cultura;
        }
    }

    public String getPropriedade(String chave) {
        return this.propriedades != null ? this.propriedades.getProperty(chave) : null;
    }

    public static Properties carregarPropriedades(String endereco) {
        try {
            Properties propriedades = new Properties();
            propriedades.loadFromXML(TomaraQueCaia.class.getResourceAsStream(endereco != null ? endereco : "/META-INF/tqc.xml"));
            return propriedades;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final Viagem novaViagem(String nome) {
        if (this.viagemMapa.containsKey(nome)) {
            throw new IllegalArgumentException(nome);
        }
        Viagem v = new Viagem(this, nome);
        this.viagemLista.add(v);
        this.viagemMapa.put(nome, v);
        if (this.viagemAtiva == null) {
            this.viagemAtiva = v;
        }
        return v;
    }

    public final Viagem novaViagem() {
        return this.novaViagem("tqc_viagem_" + this.geradorNomeViagem++);
    }

    public final void encerrarViagensVazias() {
        for (int total = this.viagemLista.size(); this.viagemLista.size() > 0 && total > 0; --total) {
            Viagem v = this.viagemLista.get(0);
            if (!v.isVazia()) continue;
            v.encerrar();
        }
    }

    public final Viagem getViagem(String nome) {
        return this.viagemMapa.get(nome);
    }

    public final Viagem getViagem(int index) {
        return this.viagemLista.get(index);
    }

    public final Viagem getViagemAtiva() {
        return this.viagemAtiva;
    }

    public final int getTotalViagens() {
        return this.viagemLista.size();
    }

    public Viagem[] getViagens() {
        return this.viagemLista.toArray(new Viagem[this.viagemLista.size()]);
    }

    final void ativar(Viagem viagem) {
        if (this.viagemLista.contains(viagem)) {
            if (this.viagemAtiva != null) {
                this.historicoDeAtivacao.add(this.viagemAtiva.getNome());
            }
            this.viagemAtiva = viagem;
        }
    }

    final void remover(Viagem viagem) {
        this.viagemLista.remove(viagem);
        this.viagemMapa.remove(viagem.getNome());
        if (this.viagemAtiva == viagem) {
            String nome;
            while ((nome = ListaUtil.menosUltimo(this.historicoDeAtivacao)) != null) {
                Viagem v = this.getViagem(nome);
                if (v == null) continue;
                this.viagemAtiva = v;
                return;
            }
            this.viagemAtiva = this.getTotalViagens() > 0 ? this.getViagem(0) : null;
        }
    }

    public final void encerrarViagens() {
        while (this.viagemLista.size() > 0) {
            this.viagemLista.get(this.viagemLista.size() - 1).encerrar();
        }
    }

    public final void encerrar() {
        this.fim();
        this.encerrarViagens();
        this.filtros = null;
        this.viagemLista = null;
        this.viagemMapa = null;
        this.viagemAtiva = null;
        this.historicoDeAtivacao = null;
    }

    public final boolean isEncerrada() {
        return this.viagemLista == null;
    }

    public abstract void inicio(Map<String, String> var1) throws TomaraQueCaiaException;

    public abstract void fim();

    public void mais(EstiloFonte fonte) {
        this.estiloFontes.add(fonte);
    }

    public EstiloFonte[] listarEstiloFontes() {
        int total = this.estiloFontes.size();
        EstiloFonte[] lista = new EstiloFonte[total];
        for (int i = 0; i < total; ++i) {
            lista[i] = this.estiloFontes.get(i);
        }
        return lista;
    }

    public void informacaoMostrada(Viagem viagem, Informacao informacao) throws TomaraQueCaiaException {
    }

    public abstract void permissaoNegada(Viagem var1, Informacao var2) throws TomaraQueCaiaException;

    public abstract boolean negarAcessoSemFiltro();

    public final boolean filtrar(Viagem viagem) throws TomaraQueCaiaException {
        Informacao informacao = viagem.getAtual();
        if (informacao == null) {
            return false;
        }
        FiltroMapa mapaClasse = this.filtros.get(informacao.getClass().getName());
        FiltroMapa mapaPacote = this.filtros.get(informacao.getClass().getPackage().getName());
        if (mapaClasse == null && mapaPacote == null) {
            return !this.negarAcessoSemFiltro();
        }
        return this.filtrar(informacao, mapaClasse) && this.filtrar(informacao, mapaPacote);
    }

    public final boolean filtrarRetroativo(Viagem viagem) throws TomaraQueCaiaException {
        Informacao informacaoAnterior = viagem.getAnterior();
        if (informacaoAnterior == null) {
            return false;
        }
        Informacao informacaoAtual = viagem.getAtual();
        FiltroMapa mapaClasse = this.filtros.get(informacaoAnterior.getClass().getName());
        FiltroMapa mapaPacote = this.filtros.get(informacaoAnterior.getClass().getPackage().getName());
        if (mapaClasse == null && mapaPacote == null) {
            return !this.negarAcessoSemFiltro();
        }
        return this.filtrar(informacaoAtual, mapaClasse) && this.filtrar(informacaoAtual, mapaPacote);
    }

    private boolean filtrar(Informacao informacao, FiltroMapa lista) throws TomaraQueCaiaException {
        while (lista != null) {
            lista.filtro.antesDeFiltrar();
            if (!lista.filtro.filtrar(this, this.viagemAtiva, informacao)) {
                return false;
            }
            lista = lista.proximo;
        }
        return true;
    }

    public TomaraQueCaia mais(Class<? extends Informacao> informacao, Filtro filtro) {
        return this.maisFiltroMapa(informacao.getName(), filtro);
    }

    public TomaraQueCaia mais(String pacote, Filtro filtro) {
        return this.maisFiltroMapa(pacote != null ? pacote : "", filtro);
    }

    private TomaraQueCaia maisFiltroMapa(String chave, Filtro filtro) {
        FiltroMapa atual = this.filtros.get(chave);
        FiltroMapa novo = new FiltroMapa(filtro);
        this.filtros.put(chave, atual == null ? novo : atual.maisUltimo(novo));
        return this;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public void setRaiz(File raiz) {
        this.raiz = raiz;
    }

    public File getRaiz() {
        return this.raiz;
    }

    public String getDireitosAutorais() {
        return this.direitosAutorais;
    }

    public void setDireitosAutorais(String direitosAutorais) {
        this.direitosAutorais = direitosAutorais;
    }

    public String getPele() {
        return this.pele;
    }

    public void setPele(String pele) {
        this.pele = pele != null ? pele : "padrao";
    }

    public Cultura getCultura() {
        return this.cultura;
    }

    public void setAutoEncerrarViagensVazias(boolean autoEncerrarViagensVazias) {
        this.autoEncerrarViagensVazias = autoEncerrarViagensVazias;
    }

    public boolean isAutoEncerrarViagensVazias() {
        return this.autoEncerrarViagensVazias;
    }

    public NumeroTransformacao novaRealTransformacao() {
        return this.cultura.novaRealTransformacao();
    }

    public NumeroTransformacao novaInteiroTransformacao() {
        return this.cultura.novaInteiroTransformacao();
    }

    public NumeroTransformacao novaMoedaTransformacao() {
        return this.cultura.novaMoedaTransformacao();
    }

    public DataTransformacao novaDataTransformacao() {
        return this.cultura.novaDataTransformacao();
    }

    private static class FiltroMapa {
        private Filtro filtro;
        private FiltroMapa proximo;

        public FiltroMapa(Filtro filtro) {
            this.filtro = filtro;
        }

        public FiltroMapa maisUltimo(FiltroMapa filtroMapa) {
            FiltroMapa fm = this;
            while (fm.proximo != null) {
                fm = fm.proximo;
            }
            fm.proximo = filtroMapa;
            return this;
        }
    }
}

