/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc;

import com.joseflavio.modelo.JFDica;
import com.joseflavio.modelo.JFMascara;
import com.joseflavio.modelo.JFTamanho;
import com.joseflavio.modelo.JFTamanhos;
import com.joseflavio.tqc.Anexo;
import com.joseflavio.tqc.AnexoDica;
import com.joseflavio.tqc.AnexoGrupo;
import com.joseflavio.tqc.AnexoMascara;
import com.joseflavio.tqc.AnexoTamanho;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Estilo;
import com.joseflavio.util.Lista;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class SimplesDado
extends Dado
implements Estilo {
    private String estilo;
    private Anexo anexo;

    public SimplesDado() {
    }

    public SimplesDado(String estilo) {
        this();
        this.estilo = estilo;
    }

    @Override
    public String getEstilo() {
        return this.estilo;
    }

    @Override
    public Dado setEstilo(String estilo) {
        this.estilo = estilo;
        return this;
    }

    public Dado maisEstilo(String estilo) {
        this.estilo = this.estilo == null ? estilo : this.estilo + " " + estilo;
        return this;
    }

    public Anexo getAnexo() {
        return this.anexo;
    }

    public void setAnexo(Anexo anexo) {
        this.anexo = anexo;
    }

    public SimplesDado mais(Anexo anexo) {
        if (this.anexo == null) {
            this.anexo = anexo;
        } else if (this.anexo instanceof AnexoGrupo) {
            ((AnexoGrupo)this.anexo).mais(anexo);
        } else {
            this.anexo = new AnexoGrupo(this.anexo).mais(anexo);
        }
        return this;
    }

    public <T extends Anexo> T getAnexo(Class<? extends T> tipo) {
        if (this.anexo == null) {
            return null;
        }
        if (this.anexo instanceof AnexoGrupo) {
            return ((AnexoGrupo)this.anexo).getAnexo(tipo);
        }
        return (T)(tipo.isAssignableFrom(this.anexo.getClass()) ? this.anexo : null);
    }

    public <T extends Anexo> List<T> getAnexos(Class<? extends T> tipo) {
        if (this.anexo == null) {
            return new ArrayList();
        }
        if (this.anexo instanceof AnexoGrupo) {
            return ((AnexoGrupo)this.anexo).getAnexos(tipo);
        }
        return tipo.isAssignableFrom(this.anexo.getClass()) ? new Lista<Anexo>(this.anexo, new Anexo[0]) : new ArrayList();
    }

    public <T extends Anexo> T getAnexo(Class<? extends T> tipo, boolean adicionar) throws InstantiationException, IllegalAccessException {
        Object anexo = this.getAnexo(tipo);
        if (anexo == null && adicionar) {
            anexo = (Anexo)tipo.newInstance();
            this.mais((Anexo)anexo);
        }
        return anexo;
    }

    public AnexoTamanho getTamanhoComLargura() {
        for (AnexoTamanho tam : this.getAnexos(AnexoTamanho.class)) {
            if (tam.getLargura() == -1) continue;
            return tam;
        }
        return null;
    }

    public AnexoTamanho getTamanhoComAltura() {
        for (AnexoTamanho tam : this.getAnexos(AnexoTamanho.class)) {
            if (tam.getAltura() == -1) continue;
            return tam;
        }
        return null;
    }

    public AnexoTamanho getTamanhoComLarguraMaxima() {
        for (AnexoTamanho tam : this.getAnexos(AnexoTamanho.class)) {
            if (tam.getLarguraMaxima() == -1) continue;
            return tam;
        }
        return null;
    }

    public AnexoTamanho getTamanhoComAlturaMaxima() {
        for (AnexoTamanho tam : this.getAnexos(AnexoTamanho.class)) {
            if (tam.getAlturaMaxima() == -1) continue;
            return tam;
        }
        return null;
    }

    public AnexoTamanho getTamanhoComLarguraMinima() {
        for (AnexoTamanho tam : this.getAnexos(AnexoTamanho.class)) {
            if (tam.getLarguraMinima() == -1) continue;
            return tam;
        }
        return null;
    }

    public AnexoTamanho getTamanhoComAlturaMinima() {
        for (AnexoTamanho tam : this.getAnexos(AnexoTamanho.class)) {
            if (tam.getAlturaMinima() == -1) continue;
            return tam;
        }
        return null;
    }

    public int getLargura() {
        AnexoTamanho tam = this.getTamanhoComLargura();
        return tam != null ? tam.getLargura() : -1;
    }

    public SimplesDado setLargura(int largura) {
        AnexoTamanho tam = this.getTamanhoComLargura();
        if (tam == null) {
            tam = this.getAnexo(AnexoTamanho.class);
        }
        if (tam == null) {
            return this.mais(new AnexoTamanho(largura));
        }
        tam.setLargura(largura);
        return this;
    }

    public int getAltura() {
        AnexoTamanho tam = this.getTamanhoComAltura();
        return tam != null ? tam.getAltura() : -1;
    }

    public SimplesDado setAltura(int altura) {
        AnexoTamanho tam = this.getTamanhoComAltura();
        if (tam == null) {
            tam = this.getAnexo(AnexoTamanho.class);
        }
        if (tam == null) {
            return this.mais(new AnexoTamanho(-1, altura));
        }
        tam.setAltura(altura);
        return this;
    }

    public SimplesDado setTamanho(int largura, int altura) {
        this.setLargura(largura);
        this.setAltura(altura);
        return this;
    }

    @Override
    protected Dado configurarPor(Field atributo) {
        super.configurarPor(atributo);
        JFDica jfDica = atributo.getAnnotation(JFDica.class);
        JFMascara jfMascara = atributo.getAnnotation(JFMascara.class);
        JFTamanho jfTamanho = atributo.getAnnotation(JFTamanho.class);
        JFTamanhos jfTamanhos = atributo.getAnnotation(JFTamanhos.class);
        if (jfDica != null) {
            this.mais(new AnexoDica(jfDica.value()));
        }
        if (jfMascara != null) {
            this.mais(new AnexoMascara(jfMascara.value()));
        }
        if (jfTamanho != null) {
            this.mais(jfTamanho);
        }
        if (jfTamanhos != null) {
            for (JFTamanho jft : jfTamanhos.value()) {
                this.mais(jft);
            }
        }
        return this;
    }

    private void mais(JFTamanho jfTamanho) {
        this.mais(new AnexoTamanho(jfTamanho.largura(), jfTamanho.altura(), jfTamanho.larguraMax(), jfTamanho.alturaMax(), jfTamanho.larguraMin(), jfTamanho.alturaMin(), jfTamanho.unidade()));
    }
}

