/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc;

import com.joseflavio.modelo.Combinacao;
import com.joseflavio.tqc.AcionamentoDeComando;
import com.joseflavio.tqc.Anexo;
import com.joseflavio.tqc.AnexoAtencao;
import com.joseflavio.tqc.AnexoErro;
import com.joseflavio.tqc.AnexoGrupo;
import com.joseflavio.tqc.AnexoInformacao;
import com.joseflavio.tqc.ComplexoDado;
import com.joseflavio.tqc.Dado;
import com.joseflavio.tqc.Edicao;
import com.joseflavio.tqc.EspacoTextual;
import com.joseflavio.tqc.Identificacao;
import com.joseflavio.tqc.Menu;
import com.joseflavio.tqc.TomaraQueCaia;
import com.joseflavio.tqc.TomaraQueCaiaException;
import com.joseflavio.tqc.ValidavelDado;
import com.joseflavio.tqc.Viagem;
import com.joseflavio.tqc.dado.Arquivo;
import com.joseflavio.tqc.dado.Binario;
import com.joseflavio.tqc.dado.Bruto;
import com.joseflavio.tqc.dado.Comando;
import com.joseflavio.tqc.dado.Data;
import com.joseflavio.tqc.dado.Inteiro;
import com.joseflavio.tqc.dado.Linha;
import com.joseflavio.tqc.dado.LinhaFim;
import com.joseflavio.tqc.dado.Marcador;
import com.joseflavio.tqc.dado.QuebraDeLinha;
import com.joseflavio.tqc.dado.Real;
import com.joseflavio.tqc.dado.Selecao;
import com.joseflavio.tqc.dado.SelecaoMultipla;
import com.joseflavio.tqc.dado.SelecionavelTexto;
import com.joseflavio.tqc.dado.Senha;
import com.joseflavio.tqc.dado.Texto;
import com.joseflavio.util.Lista;
import com.joseflavio.util.TipoUtil;
import com.joseflavio.validacao.ValidacaoException;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Informacao
implements AcionamentoDeComando {
    private String titulo;
    private List<Dado> dados = new ArrayList<Dado>(10);
    private Menu menu;
    private AnexoGrupo anexoGrupo = new AnexoGrupo();
    private boolean personalizada = true;
    private String personalizadaInterface;
    private String pele;
    private Map<String, Integer> indiceCache = new HashMap<String, Integer>(50);
    private int contadorDadosAnonimos = 0;

    protected Informacao(String titulo) throws TomaraQueCaiaException {
        this.setTitulo(titulo);
    }

    public abstract void antesDeMostrar(TomaraQueCaia var1, Viagem var2) throws TomaraQueCaiaException;

    public Informacao criarAjuda(TomaraQueCaia tqc) throws TomaraQueCaiaException {
        return null;
    }

    public boolean possuiAjuda() {
        return false;
    }

    public void validarTudo() throws ValidacaoException {
        int total = this.dados.size();
        for (int i = 0; i < total; ++i) {
            Dado dado = this.dados.get(i);
            if (!(dado instanceof ValidavelDado)) continue;
            ((ValidavelDado)dado).validar();
        }
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    public String getTitulo() {
        return this.titulo;
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
    }

    public void setPersonalizada(boolean personalizada) {
        this.personalizada = personalizada;
    }

    public boolean isPersonalizada() {
        return this.personalizada;
    }

    public String getPersonalizadaInterface() {
        return this.personalizadaInterface;
    }

    public void setPersonalizadaInterface(String personalizadaInterface) {
        this.personalizadaInterface = personalizadaInterface;
        this.setPersonalizada(true);
    }

    public String getPele() {
        return this.pele;
    }

    public void setPele(String pele) {
        this.pele = pele;
    }

    public List<String> getNomesDeDados() {
        ArrayList<String> nomes = new ArrayList<String>();
        for (Dado dado : this.dados) {
            String n;
            if (!(dado instanceof Identificacao) || (n = ((Identificacao)((Object)dado)).getNome()) == null || n.length() <= 0) continue;
            nomes.add(n);
        }
        return nomes;
    }

    public String gerarNome() {
        return "anonimo" + ++this.contadorDadosAnonimos;
    }

    public <T extends Dado> T mais(T dado) {
        String nome;
        if (dado instanceof Identificacao && ((nome = ((Identificacao)((Object)dado)).getNome()) == null || nome.length() == 0)) {
            ((Identificacao)((Object)dado)).setNome(this.gerarNome());
        }
        this.dados.add(dado);
        if (dado instanceof ComplexoDado) {
            ((ComplexoDado)dado).setInformacao(this);
        }
        this.atualizarIndiceCache();
        return dado;
    }

    public <T extends Dado> T mais(T dado, int indice) {
        String nome;
        if (dado instanceof Identificacao && ((nome = ((Identificacao)((Object)dado)).getNome()) == null || nome.length() == 0)) {
            ((Identificacao)((Object)dado)).setNome(this.gerarNome());
        }
        this.dados.add(indice, dado);
        if (dado instanceof ComplexoDado) {
            ((ComplexoDado)dado).setInformacao(this);
        }
        this.atualizarIndiceCache();
        return dado;
    }

    private <T extends Dado> T menos(T dado, int indice) {
        if (dado == null) {
            throw new IllegalArgumentException();
        }
        this.dados.remove(indice);
        if (dado instanceof ComplexoDado) {
            ((ComplexoDado)dado).setInformacao(null);
        }
        this.atualizarIndiceCache();
        return dado;
    }

    public <T extends Dado> T menos(T dado) {
        return this.menos(dado, this.getIndice(dado));
    }

    public Dado menos(int indice) {
        return this.menos(this.getDado(indice), indice);
    }

    public int menos(Dado inicio, Dado fim, boolean inclusive) {
        int i = this.getIndice(inicio);
        int f = this.getIndice(fim);
        this.menos(inclusive ? i : i + 1, inclusive ? f : f - 1);
        return i;
    }

    public int menos(Dado inicio, Dado fim) {
        return this.menos(inicio, fim, true);
    }

    public void menos(int inicio, int fim) {
        if (inicio < 0 || inicio >= this.dados.size()) {
            throw new IndexOutOfBoundsException("" + inicio);
        }
        if (fim < 0 || fim >= this.dados.size()) {
            throw new IndexOutOfBoundsException("" + fim);
        }
        for (int t = fim - inicio + 1; t > 0; --t) {
            this.menos(fim--);
        }
    }

    public void setVisivel(boolean visivel, Dado inicio, Dado fim) {
        int total = this.dados.size();
        block0: for (int i = 0; i < total; ++i) {
            if (this.dados.get(i) != inicio) continue;
            for (int f = i + 1; f < total; ++f) {
                if (this.dados.get(f) != fim) continue;
                for (int k = i; k <= f; ++k) {
                    this.dados.get(k).setVisivel(visivel);
                }
                i = f;
                continue block0;
            }
        }
    }

    public void setVisivel(boolean visivel, String inicio, String fim) {
        int total = this.dados.size();
        block0: for (int i = 0; i < total; ++i) {
            Dado dado = this.dados.get(i);
            if (!(dado instanceof Identificacao) || !Informacao.nomeIgual((Identificacao)((Object)dado), inicio)) continue;
            for (int f = i + 1; f < total; ++f) {
                dado = this.dados.get(f);
                if (!(dado instanceof Identificacao) || !Informacao.nomeIgual((Identificacao)((Object)dado), fim)) continue;
                for (int k = i; k <= f; ++k) {
                    this.dados.get(k).setVisivel(visivel);
                }
                i = f;
                continue block0;
            }
        }
    }

    public boolean isEditavel(String nome) {
        Object dado = this.getDado(nome);
        return dado != null && dado instanceof Edicao ? ((Edicao)dado).isEditavel() : false;
    }

    public void setEditavel(boolean editavel, Dado inicio, Dado fim) {
        int total = this.dados.size();
        block0: for (int i = 0; i < total; ++i) {
            if (this.dados.get(i) != inicio) continue;
            for (int f = i + 1; f < total; ++f) {
                if (this.dados.get(f) != fim) continue;
                for (int k = i; k <= f; ++k) {
                    Dado dado = this.dados.get(k);
                    if (!(dado instanceof Edicao)) continue;
                    ((Edicao)((Object)dado)).setEditavel(editavel);
                }
                i = f;
                continue block0;
            }
        }
    }

    public void setEditavel(boolean editavel, String inicio, String fim) {
        int total = this.dados.size();
        block0: for (int i = 0; i < total; ++i) {
            Dado dado = this.dados.get(i);
            if (!(dado instanceof Identificacao) || !Informacao.nomeIgual((Identificacao)((Object)dado), inicio)) continue;
            for (int f = i + 1; f < total; ++f) {
                dado = this.dados.get(f);
                if (!(dado instanceof Identificacao) || !Informacao.nomeIgual((Identificacao)((Object)dado), fim)) continue;
                for (int k = i; k <= f; ++k) {
                    dado = this.dados.get(k);
                    if (!(dado instanceof Edicao)) continue;
                    ((Edicao)((Object)dado)).setEditavel(editavel);
                }
                i = f;
                continue block0;
            }
        }
    }

    public void setEditavel(boolean editavel) {
        for (Dado dado : this.dados) {
            if (!(dado instanceof Edicao)) continue;
            ((Edicao)((Object)dado)).setEditavel(editavel);
        }
    }

    public void setEditavel(boolean editavel, Class<? extends Edicao> ... excecao) {
        for (Dado dado : this.dados) {
            Edicao edicao;
            if (!(dado instanceof Edicao) || (edicao = (Edicao)((Object)dado)).isEditavel() == editavel) continue;
            Class<?> classe = dado.getClass();
            boolean alterar = true;
            for (Class<? extends Edicao> ex : excecao) {
                if (classe != ex) continue;
                alterar = false;
                break;
            }
            if (!alterar) continue;
            edicao.setEditavel(editavel);
        }
    }

    public void setEditavel(String nomeDado, boolean editavel) {
        Object dado = this.getDado(nomeDado);
        if (!(dado instanceof Edicao)) {
            throw new IllegalArgumentException(nomeDado + " : n\u00e3o edit\u00e1vel");
        }
        ((Edicao)dado).setEditavel(editavel);
    }

    public Texto maisTexto(String texto) {
        Texto dado = new Texto(texto);
        this.mais(dado);
        return dado;
    }

    public QuebraDeLinha maisQuebraDeLinha() {
        QuebraDeLinha dado = new QuebraDeLinha();
        this.mais(dado);
        return dado;
    }

    public EspacoTextual maisEspacoTextual(int quantidade) {
        EspacoTextual dado = new EspacoTextual(quantidade);
        this.mais(dado);
        return dado;
    }

    public EspacoTextual maisEspacoTextual() {
        return this.maisEspacoTextual(1);
    }

    public Linha maisLinha() {
        Linha dado = new Linha();
        this.mais(dado);
        return dado;
    }

    public Linha maisLinha(String estilo) {
        Linha dado = new Linha(estilo);
        this.mais(dado);
        return dado;
    }

    public Linha maisLinhaCentral() {
        Linha dado = new Linha("centroH");
        this.mais(dado);
        return dado;
    }

    public LinhaFim maisLinhaFim() {
        LinhaFim dado = new LinhaFim();
        this.mais(dado);
        return dado;
    }

    public <T extends Dado> T maisDadoEmLinha(T dado) {
        this.maisLinha();
        this.mais(dado);
        this.maisLinhaFim();
        return dado;
    }

    public <T extends Dado> T maisDadoEmLinhaCentral(T dado) {
        this.maisLinhaCentral();
        this.mais(dado);
        this.maisLinhaFim();
        return dado;
    }

    public <T extends Dado> void maisDadosEmLinhaCentral(T ... dados) {
        this.maisLinhaCentral();
        for (T dado : dados) {
            this.mais(dado);
        }
        this.maisLinhaFim();
    }

    public Informacao maisMarcador(String nome) {
        this.mais(new Marcador(nome));
        return this;
    }

    public List<Dado> getDados() {
        return (List)((ArrayList)this.dados).clone();
    }

    protected List<Dado> getDadosPuros() {
        return this.dados;
    }

    public <T extends Dado> List<T> getDados(Class<? extends T> tipo) {
        ArrayList<Dado> lista = new ArrayList<Dado>();
        for (Dado dado : this.dados) {
            if (!tipo.isAssignableFrom(dado.getClass())) continue;
            lista.add(dado);
        }
        return lista;
    }

    public <T extends Dado> T getDado(String nome) {
        Integer i = this.indiceCache.get(nome);
        return (T)(i != null ? this.dados.get(i) : null);
    }

    public Dado getDado(int indice) {
        return this.dados.get(indice);
    }

    public Dado getDadoVirtual(String nome) {
        Object dado = this.getDado(nome);
        if (dado == null) {
            dado = this.getComando(nome);
        }
        return dado;
    }

    public int getIndice(Dado dado) {
        String nome;
        if (dado instanceof Identificacao && (nome = ((Identificacao)((Object)dado)).getNome()) != null) {
            return this.getIndice(nome);
        }
        return this.dados.indexOf(dado);
    }

    public int getIndice(String nome) {
        Integer i = this.indiceCache.get(nome);
        return i != null ? i : -1;
    }

    public int getIndice(String nome, int aPartir) {
        int total = this.dados.size();
        for (int i = aPartir; i < total; ++i) {
            Dado dado = this.dados.get(i);
            if (!(dado instanceof Identificacao) || !Informacao.nomeIgual((Identificacao)((Object)dado), nome)) continue;
            return i;
        }
        return -1;
    }

    public Comando getComando(String nome) {
        return Comando.getComando(this, nome);
    }

    public boolean contem(Dado dado) {
        return this.getIndice(dado) != -1;
    }

    public void substituir(Dado atual, Dado novo) {
        if (atual == null || novo == null) {
            throw new IllegalArgumentException();
        }
        int i = this.dados.indexOf(atual);
        this.dados.set(i, novo);
        if (novo instanceof ComplexoDado) {
            ((ComplexoDado)novo).setInformacao(this);
        }
        if (atual instanceof ComplexoDado) {
            ((ComplexoDado)atual).setInformacao(null);
        }
        this.atualizarIndiceCache();
    }

    public int getTotalDados() {
        return this.dados.size();
    }

    private static boolean nomeIgual(Identificacao identificacao, String nome) {
        String n = identificacao.getNome();
        return n == nome || n != null && nome != null && n.equals(nome);
    }

    public <O> O objeto(String dadoNome) {
        Object dado = this.getDado(dadoNome);
        if (dado != null) {
            return (O)((Dado)dado).getConteudo();
        }
        throw new IllegalArgumentException(dadoNome);
    }

    public <O> List<O> objetos(String dadoNome) {
        O o = this.objeto(dadoNome);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof Object[]) {
            return new Lista<Object>((Object[])o);
        }
        throw new IllegalArgumentException(dadoNome);
    }

    public String texto(String dadoNome) {
        Object o = this.objeto(dadoNome);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Long inteiro(String dadoNome) {
        Object dado = this.getDado(dadoNome);
        if (dado == null) {
            throw new IllegalArgumentException(dadoNome);
        }
        Object o = ((Dado)dado).getConteudo();
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return TipoUtil.converterParaLong((Number)o);
        }
        if (dado instanceof Selecao) {
            return new Long(((Selecao)dado).getIndiceSelecionado());
        }
        throw new IllegalArgumentException(dadoNome);
    }

    public Double real(String dadoNome) {
        Object o = this.objeto(dadoNome);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return TipoUtil.converterParaDouble((Number)o);
        }
        throw new IllegalArgumentException(dadoNome);
    }

    public Date data(String dadoNome) {
        Object o = this.objeto(dadoNome);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        throw new IllegalArgumentException(dadoNome);
    }

    public boolean binario(String dadoNome) {
        Object o = this.objeto(dadoNome);
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new IllegalArgumentException(dadoNome);
    }

    public Boolean binarioSelecao(String dadoNome, int indiceNulo, int indiceVerdadeiro) {
        Object dado = this.getDado(dadoNome);
        if (dado instanceof Selecao) {
            int indice = ((Selecao)dado).getIndiceSelecionado();
            return indice == indiceVerdadeiro ? true : (indice != indiceNulo ? Boolean.valueOf(false) : null);
        }
        throw new IllegalArgumentException(dadoNome);
    }

    public boolean binarioSelecao(String dadoNome, int indiceVerdadeiro) {
        Object dado = this.getDado(dadoNome);
        if (dado instanceof Selecao) {
            return ((Selecao)dado).getIndiceSelecionado() == indiceVerdadeiro;
        }
        throw new IllegalArgumentException(dadoNome);
    }

    public boolean binarioSelecao(String dadoNome) {
        return this.binarioSelecao(dadoNome, 0);
    }

    public Boolean binarioCombinacao(String dadoNome) {
        return this.combinacao(dadoNome, Boolean.class);
    }

    public <O> O combinacao(String dadoNome, Class<O> classe) {
        O obj = this.objeto(dadoNome);
        if (obj instanceof Combinacao) {
            Combinacao comb = (Combinacao)obj;
            Object o1 = comb.getObjeto1();
            if (o1 != null && o1.getClass() == classe) {
                return (O)o1;
            }
            Object o2 = comb.getObjeto2();
            if (o2 != null && o2.getClass() == classe) {
                return (O)o2;
            }
            return null;
        }
        throw new IllegalArgumentException(dadoNome);
    }

    public short primitivoShort(String dadoNome) {
        return this.inteiro(dadoNome).shortValue();
    }

    public int primitivoInt(String dadoNome) {
        return this.inteiro(dadoNome).intValue();
    }

    public long primitivoLong(String dadoNome) {
        return this.inteiro(dadoNome);
    }

    public float primitivoFloat(String dadoNome) {
        return this.real(dadoNome).floatValue();
    }

    public double primitivoDouble(String dadoNome) {
        return this.real(dadoNome);
    }

    public Byte inteiro8(String dadoNome) {
        return TipoUtil.converterParaByte(this.inteiro(dadoNome));
    }

    public Short inteiro16(String dadoNome) {
        return TipoUtil.converterParaShort(this.inteiro(dadoNome));
    }

    public Integer inteiro32(String dadoNome) {
        return TipoUtil.converterParaInteger(this.inteiro(dadoNome));
    }

    public Long inteiro64(String dadoNome) {
        return this.inteiro(dadoNome);
    }

    public Float real32(String dadoNome) {
        return TipoUtil.converterParaFloat(this.real(dadoNome));
    }

    public Double real64(String dadoNome) {
        return this.real(dadoNome);
    }

    public Boolean logico(String dadoNome) {
        Object o = this.objeto(dadoNome);
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new IllegalArgumentException(dadoNome);
    }

    public AnexoGrupo getAnexoGrupo() {
        return this.anexoGrupo;
    }

    public void setAnexoGrupo(AnexoGrupo anexoGrupo) {
        this.anexoGrupo = anexoGrupo;
    }

    public Informacao mais(Anexo anexo) {
        this.anexoGrupo.mais(anexo);
        return this;
    }

    public Informacao menos(Anexo anexo) {
        this.anexoGrupo.menos(anexo);
        return this;
    }

    public <T extends Anexo> Informacao menos(Class<? extends T> tipo) {
        this.anexoGrupo.menos(tipo);
        return this;
    }

    public <T extends Anexo> T getAnexo(Class<? extends T> tipo) {
        return this.anexoGrupo.getAnexo(tipo);
    }

    public <T extends Anexo> T getAnexo(Class<? extends T> tipo, boolean adicionar) throws InstantiationException, IllegalAccessException {
        return this.anexoGrupo.getAnexo(tipo, adicionar);
    }

    public <T extends Anexo> List<T> getAnexos(Class<? extends T> tipo) {
        return this.anexoGrupo.getAnexos(tipo);
    }

    public String getMensagemErro() {
        AnexoErro a = this.getAnexo(AnexoErro.class);
        return a != null ? a.getMensagem() : null;
    }

    public Informacao setMensagemErro(String mensagem) {
        AnexoErro a = this.getAnexo(AnexoErro.class);
        if (a == null) {
            return this.mais(new AnexoErro(mensagem));
        }
        a.setMensagem(mensagem);
        return this;
    }

    public String getMensagemAtencao() {
        AnexoAtencao a = this.getAnexo(AnexoAtencao.class);
        return a != null ? a.getMensagem() : null;
    }

    public Informacao setMensagemAtencao(String mensagem) {
        AnexoAtencao a = this.getAnexo(AnexoAtencao.class);
        if (a == null) {
            return this.mais(new AnexoAtencao(mensagem));
        }
        a.setMensagem(mensagem);
        return this;
    }

    public String getMensagemInformacao() {
        AnexoInformacao a = this.getAnexo(AnexoInformacao.class);
        return a != null ? a.getMensagem() : null;
    }

    public Informacao setMensagemInformacao(String mensagem) {
        AnexoInformacao a = this.getAnexo(AnexoInformacao.class);
        if (a == null) {
            return this.mais(new AnexoInformacao(mensagem));
        }
        a.setMensagem(mensagem);
        return this;
    }

    public void retirarMensagens() {
        this.setMensagemErro(null);
        this.setMensagemAtencao(null);
        this.setMensagemInformacao(null);
    }

    private void atualizarIndiceCache() {
        this.indiceCache.clear();
        int i = 0;
        for (Dado dado : this.dados) {
            String nome;
            if (dado instanceof Identificacao && (nome = ((Identificacao)((Object)dado)).getNome()) != null && nome.length() > 0 && this.indiceCache.get(nome) == null) {
                this.indiceCache.put(nome, i);
            }
            ++i;
        }
    }

    public Texto maisTexto(String nome, Class<? extends Object> classe, String atributo, String texto, Boolean editavel) {
        return this.mais(new Texto(nome, classe, atributo, texto, editavel));
    }

    public Texto maisTexto(String nome, Class<? extends Object> classe, String texto, Boolean editavel) {
        return this.maisTexto(nome, classe, nome, texto, editavel);
    }

    public Senha maisSenha(String nome, Class<? extends Object> classe, String atributo, String senha, Boolean editavel) {
        return this.mais(new Senha(nome, classe, atributo, senha, editavel));
    }

    public Senha maisSenha(String nome, Class<? extends Object> classe, String senha, Boolean editavel) {
        return this.maisSenha(nome, classe, nome, senha, editavel);
    }

    public Data maisData(String nome, Class<? extends Object> classe, String atributo, Date data, Boolean editavel) {
        return this.mais(new Data(nome, classe, atributo, data, editavel));
    }

    public Data maisData(String nome, Class<? extends Object> classe, Date data, Boolean editavel) {
        return this.maisData(nome, classe, nome, data, editavel);
    }

    public Real maisReal(String nome, Class<? extends Object> classe, String atributo, Double numero, Boolean editavel) {
        return this.mais(new Real(nome, classe, atributo, numero, editavel));
    }

    public Real maisReal(String nome, Class<? extends Object> classe, Double numero, Boolean editavel) {
        return this.maisReal(nome, classe, nome, numero, editavel);
    }

    public Inteiro maisInteiro(String nome, Class<? extends Object> classe, String atributo, Long numero, Boolean editavel) {
        return this.mais(new Inteiro(nome, classe, atributo, numero, editavel));
    }

    public Inteiro maisInteiro(String nome, Class<? extends Object> classe, Long numero, Boolean editavel) {
        return this.maisInteiro(nome, classe, nome, numero, editavel);
    }

    public Inteiro maisInteiro(String nome, Class<? extends Object> classe, Integer numero, Boolean editavel) {
        return this.maisInteiro(nome, classe, nome, numero != null ? new Long(numero.longValue()) : null, editavel);
    }

    public <T> Selecao<T> maisSelecao(String nome, Class<? extends Object> classe, String atributo, List<T> opcoes, T selecaoInicial, Boolean editavel) {
        return this.mais(new Selecao<T>(nome, classe, atributo, opcoes, selecaoInicial, editavel));
    }

    public <T> Selecao<T> maisSelecao(String nome, Class<? extends Object> classe, List<T> opcoes, T selecaoInicial, Boolean editavel) {
        return this.maisSelecao(nome, classe, nome, opcoes, selecaoInicial, editavel);
    }

    public <T> Selecao<T> maisSelecao(String nome, Class<? extends Object> classe, List<T> opcoes, Boolean editavel) {
        return this.maisSelecao(nome, classe, nome, opcoes, null, editavel);
    }

    public <T> Selecao<T> maisSelecao(String nome, Class<? extends Object> classe, Boolean editavel) {
        return this.maisSelecao(nome, classe, nome, (List)null, null, editavel);
    }

    public <T> Selecao<T> maisSelecao(String nome, Class<? extends Object> classe, T selecaoInicial, Boolean editavel) {
        return this.maisSelecao(nome, classe, nome, (List)null, selecaoInicial, editavel);
    }

    public <T> Selecao<T> maisSelecao(String nome, Class<? extends Object> classe, String atributo, T[] opcoes, T selecaoInicial, Boolean editavel) {
        return this.maisSelecao(nome, classe, atributo, new Lista<T>(opcoes), selecaoInicial, editavel);
    }

    public <T> Selecao<T> maisSelecao(String nome, Class<? extends Object> classe, T[] opcoes, T selecaoInicial, Boolean editavel) {
        return this.maisSelecao(nome, classe, nome, new Lista<T>(opcoes), selecaoInicial, editavel);
    }

    public <T> Selecao<T> maisSelecao(String nome, Class<? extends Object> classe, T[] opcoes, Boolean editavel) {
        return this.maisSelecao(nome, classe, nome, new Lista<T>(opcoes), null, editavel);
    }

    public <T> SelecaoMultipla<T> maisSelecaoMultipla(String nome, Class<? extends Object> classe, String atributo, List<T> opcoes, List<T> selecaoInicial, Boolean editavel) {
        return this.mais(new SelecaoMultipla<T>(nome, classe, atributo, opcoes, selecaoInicial, editavel));
    }

    public <T> SelecaoMultipla<T> maisSelecaoMultipla(String nome, Class<? extends Object> classe, List<T> opcoes, List<T> selecaoInicial, Boolean editavel) {
        return this.maisSelecaoMultipla(nome, classe, nome, opcoes, selecaoInicial, editavel);
    }

    public <T> SelecaoMultipla<T> maisSelecaoMultipla(String nome, Class<? extends Object> classe, T[] opcoes, T[] selecaoInicial, Boolean editavel) {
        return this.maisSelecaoMultipla(nome, classe, nome, new Lista<T>(opcoes), new Lista<T>(selecaoInicial), editavel);
    }

    public <T> SelecaoMultipla<T> maisSelecaoMultipla(String nome, Class<? extends Object> classe, Boolean editavel) {
        return this.maisSelecaoMultipla(nome, classe, nome, null, null, editavel);
    }

    public SelecionavelTexto maisSelecionavelTexto(String nome, Class<? extends Object> classe, String atributo, String texto, List<String> opcoes, Boolean editavel) {
        return this.mais(new SelecionavelTexto(nome, classe, atributo, texto, opcoes, editavel));
    }

    public SelecionavelTexto maisSelecionavelTexto(String nome, Class<? extends Object> classe, String atributo, String texto, String[] opcoes, Boolean editavel) {
        return this.maisSelecionavelTexto(nome, classe, atributo, texto, new Lista<String>(opcoes), editavel);
    }

    public SelecionavelTexto maisSelecionavelTexto(String nome, Class<? extends Object> classe, String texto, List<String> opcoes, Boolean editavel) {
        return this.maisSelecionavelTexto(nome, classe, nome, texto, opcoes, editavel);
    }

    public SelecionavelTexto maisSelecionavelTexto(String nome, Class<? extends Object> classe, String texto, String[] opcoes, Boolean editavel) {
        return this.maisSelecionavelTexto(nome, classe, nome, texto, new Lista<String>(opcoes), editavel);
    }

    public SelecionavelTexto maisSelecionavelTexto(String nome, Class<? extends Object> classe, String texto, Boolean editavel) {
        return this.maisSelecionavelTexto(nome, classe, nome, texto, (List<String>)null, editavel);
    }

    public Bruto maisBruto(String nome, Class<? extends Object> classe, String atributo, byte[] valor, String valorRotulo, Boolean editavel) {
        return this.mais(new Bruto(nome, classe, atributo, valor, valorRotulo, editavel));
    }

    public Bruto maisBruto(String nome, Class<? extends Object> classe, byte[] valor, String valorRotulo, Boolean editavel) {
        return this.maisBruto(nome, classe, nome, valor, valorRotulo, editavel);
    }

    public Arquivo maisArquivo(String nome, Class<? extends Object> classe, String atributo, File arquivo, File localPreferido, Boolean editavel) {
        return this.mais(new Arquivo(nome, classe, atributo, arquivo, localPreferido, editavel));
    }

    public Arquivo maisArquivo(String nome, Class<? extends Object> classe, File arquivo, File localPreferido, Boolean editavel) {
        return this.maisArquivo(nome, classe, nome, arquivo, localPreferido, editavel);
    }

    public Binario maisBinario(String nome, Class<? extends Object> classe, String atributo, Boolean valor, Boolean editavel) {
        return this.mais(new Binario(nome, classe, atributo, valor, editavel));
    }

    public Binario maisBinario(String nome, Class<? extends Object> classe, Boolean valor, Boolean editavel) {
        return this.maisBinario(nome, classe, nome, valor, editavel);
    }

    public void sair(Viagem viagem) {
        viagem.voltar();
    }
}

