/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.tqc;

import com.joseflavio.modelo.AssistenteDeAtributo;
import com.joseflavio.modelo.JFAcesso;
import com.joseflavio.tqc.Edicao;
import com.joseflavio.tqc.Identificacao;
import com.joseflavio.tqc.ValidacaoDeConteudo;
import com.joseflavio.tqc.ValidacaoPrimitiva;
import com.joseflavio.validacao.MultiplaValidacao;
import com.joseflavio.validacao.Validacao;
import com.joseflavio.validacao.ValidacaoException;
import java.lang.reflect.Field;

public abstract class Dado {
    private boolean visivel = true;

    public boolean equals(Object obj) {
        String n2;
        String n1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Dado)) {
            return false;
        }
        if (this instanceof Identificacao && obj instanceof Identificacao && ((n1 = ((Identificacao)((Object)this)).getNome()) == (n2 = ((Identificacao)obj).getNome()) || n1 != null && n2 != null && n1.equals(n2))) {
            return true;
        }
        return super.equals(obj);
    }

    public abstract Object getConteudo();

    public final Object getConteudoValidado() throws ValidacaoException {
        this.validar();
        return this.getConteudo();
    }

    public final void validar() throws ValidacaoException {
        Validacao validacao;
        ValidacaoPrimitiva vp;
        if (this instanceof ValidacaoPrimitiva && (vp = (ValidacaoPrimitiva)((Object)this)).getConteudoInvalido() != null) {
            String nome = this instanceof Identificacao ? ((Identificacao)((Object)this)).getNome() : null;
            throw ValidacaoException.novoErro(nome, vp.getConteudoInvalido(), vp.getMensagemValidacaoPrimitiva());
        }
        if (this instanceof ValidacaoDeConteudo && (validacao = ((ValidacaoDeConteudo)((Object)this)).getValidacao()) != null) {
            validacao.validar(this.getConteudo());
        }
    }

    public Dado mais(Validacao v) {
        if (!(this instanceof ValidacaoDeConteudo)) {
            throw new RuntimeException();
        }
        ValidacaoDeConteudo vc = (ValidacaoDeConteudo)((Object)this);
        Validacao validacao = vc.getValidacao();
        if (validacao == null) {
            validacao = v;
        } else if (validacao instanceof MultiplaValidacao) {
            ((MultiplaValidacao)validacao).mais(v);
        } else {
            validacao = new MultiplaValidacao(validacao).mais(v);
        }
        vc.setValidacao(validacao);
        return this;
    }

    public boolean isVisivel() {
        return this.visivel;
    }

    public Dado setVisivel(boolean visivel) {
        this.visivel = visivel;
        return this;
    }

    protected Dado configurarPor(Field atributo) {
        JFAcesso jfAcesso = atributo.getAnnotation(JFAcesso.class);
        if (jfAcesso != null) {
            this.setVisivel(jfAcesso.visivel());
            if (this instanceof Edicao) {
                ((Edicao)((Object)this)).setEditavel(jfAcesso.editavel());
            }
        }
        return this;
    }

    public final Dado configurarPor(Class<? extends Object> classe, String atributo) {
        try {
            return this.configurarPor(AssistenteDeAtributo.getCampo(classe, atributo));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Atributo " + classe.getName() + "." + atributo + " desconhecido.", e);
        }
    }
}

