/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.modelo;

public class Combinacao<A, B> {
    public static final Combinacao<Boolean, String>[] LOGICA = Combinacao.lista(true, new Object[]{true, "Verdadeiro", false, "Falso"});
    public static Combinacao<Boolean, String>[] LOGICA_SIM = Combinacao.lista(true, new Object[]{true, "Sim", false, "N\u00e3o"});
    public static Combinacao<Boolean, String>[] LOGICA_POSITIVO = Combinacao.lista(true, new Object[]{true, "Positivo", false, "Negativo"});
    private A objeto1;
    private B objeto2;
    private boolean estatica;

    private Combinacao(A objeto1, B objeto2, boolean estatica) {
        this.objeto1 = objeto1;
        this.objeto2 = objeto2;
        this.estatica = estatica;
    }

    public Combinacao(A objeto1, B objeto2) {
        this(objeto1, objeto2, false);
    }

    public String toString() {
        if (this.objeto1 instanceof String) {
            return (String)this.objeto1;
        }
        if (this.objeto2 instanceof String) {
            return (String)this.objeto2;
        }
        if (this.objeto1 instanceof StringBuffer) {
            return this.objeto1.toString();
        }
        if (this.objeto2 instanceof StringBuffer) {
            return this.objeto2.toString();
        }
        return this.objeto1.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Combinacao)) {
            return false;
        }
        Combinacao comb = (Combinacao)obj;
        if (this.objeto1 == comb.objeto1 && this.objeto2 == comb.objeto2) {
            return true;
        }
        if (this.objeto1 != null && comb.objeto1 != null && !this.objeto1.equals(comb.objeto1)) {
            return false;
        }
        if (this.objeto1 != comb.objeto1) {
            return false;
        }
        if (this.objeto2 != null && comb.objeto2 != null && !this.objeto2.equals(comb.objeto2)) {
            return false;
        }
        return this.objeto2 == comb.objeto2;
    }

    public int hashCode() {
        return (this.objeto1 != null ? this.objeto1.hashCode() : 0) + (this.objeto2 != null ? this.objeto2.hashCode() : 0);
    }

    public A getObjeto1() {
        return this.objeto1;
    }

    public void setObjeto1(A objeto1) {
        if (this.estatica) {
            throw new IllegalStateException();
        }
        this.objeto1 = objeto1;
    }

    public B getObjeto2() {
        return this.objeto2;
    }

    public void setObjeto2(B objeto2) {
        if (this.estatica) {
            throw new IllegalStateException();
        }
        this.objeto2 = objeto2;
    }

    public Object par(Object objeto) {
        if (objeto == this.objeto1) {
            return this.objeto2;
        }
        if (objeto == this.objeto2) {
            return this.objeto1;
        }
        if (objeto != null) {
            if (this.objeto1 != null && objeto.equals(this.objeto1)) {
                return this.objeto2;
            }
            if (this.objeto2 != null && objeto.equals(this.objeto2)) {
                return this.objeto1;
            }
        }
        throw new IllegalArgumentException();
    }

    private static <A, B> Combinacao<A, B>[] lista(boolean estatica, Object[] objetos) {
        if (objetos == null) {
            throw new IllegalArgumentException();
        }
        int total = objetos.length;
        if (total == 0 || total % 2 != 0) {
            throw new IllegalArgumentException();
        }
        Combinacao[] lista = new Combinacao[total /= 2];
        int i = 0;
        int o = 0;
        while (total > 0) {
            Object obj1 = objetos[o];
            Object obj2 = objetos[o + 1];
            lista[i] = new Combinacao<Object, Object>(obj1, obj2, estatica);
            ++i;
            o += 2;
            --total;
        }
        return lista;
    }

    public static <A, B> Combinacao<A, B>[] lista(Object ... objetos) {
        return Combinacao.lista(false, objetos);
    }

    public static <A> Combinacao<A, ?> buscar1(Combinacao<A, ?>[] combinacoes, A alvo) {
        for (Combinacao<A, ?> comb : combinacoes) {
            A obj = comb.getObjeto1();
            if (obj == alvo) {
                return comb;
            }
            if (obj == null || alvo == null || !obj.equals(alvo)) continue;
            return comb;
        }
        return null;
    }

    public static <B> Combinacao<?, B> buscar2(Combinacao<?, B>[] combinacoes, B alvo) {
        for (Combinacao<?, B> comb : combinacoes) {
            B obj = comb.getObjeto2();
            if (obj == alvo) {
                return comb;
            }
            if (obj == null || alvo == null || !obj.equals(alvo)) continue;
            return comb;
        }
        return null;
    }

    public static Combinacao<Boolean, String>[] listaLogica(String nulo, String verdadeiro, String falso) {
        return Combinacao.lista(null, nulo, true, verdadeiro, false, falso);
    }

    public static Combinacao<Boolean, String>[] listaLogica(String verdadeiro, String falso) {
        return Combinacao.lista(true, verdadeiro, false, falso);
    }
}

