/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.modelo;

import com.joseflavio.modelo.JFAcesso;
import com.joseflavio.modelo.JFApresentacao;
import com.joseflavio.modelo.JFData;
import com.joseflavio.modelo.JFInteiro;
import com.joseflavio.modelo.JFReal;
import com.joseflavio.modelo.JFTexto;
import com.joseflavio.modelo.JFValidacaoNaoNulo;
import com.joseflavio.modelo.JFValidacaoNaoVazio;
import com.joseflavio.modelo.JFValidacaoPrimitiva;
import com.joseflavio.modelo.JFValidacaoTamanhoLimite;
import com.joseflavio.modelo.JFValidacaoValorLimite;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class AssistenteDeAtributo {
    private Class<? extends Object> classe;
    private String atributo;
    private Field campo;
    private Method metodoGet;
    private Method metodoSet;

    public AssistenteDeAtributo(Class<? extends Object> classe, String atributo) {
        this.classe = classe;
        this.atributo = atributo;
    }

    public Class<? extends Object> getClasse() {
        return this.classe;
    }

    public String getAtributo() {
        return this.atributo;
    }

    public static Field getCampo(Class<? extends Object> classe, String nome) {
        Field f = null;
        for (Class<? extends Object> c = classe; c != null; c = c.getSuperclass()) {
            try {
                f = c.getDeclaredField(nome);
                if (f == null) continue;
                return f;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Atributo " + classe.getName() + "." + nome + " desconhecido.");
    }

    public Field getCampo() {
        if (this.campo == null) {
            this.campo = AssistenteDeAtributo.getCampo(this.classe, this.atributo);
        }
        return this.campo;
    }

    public static Field[] getCampos(Class<? extends Object> classe) {
        ArrayList<Field> campos = new ArrayList<Field>();
        for (Class<? extends Object> c = classe; c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                campos.add(f);
            }
        }
        return campos.toArray(new Field[campos.size()]);
    }

    public Method getMetodoGet() {
        if (this.metodoGet == null) {
            this.metodoGet = AssistenteDeAtributo.getMetodoGet(this.classe, this.atributo);
        }
        return this.metodoGet;
    }

    public Object invocarGet(Object objeto) {
        try {
            return this.getMetodoGet().invoke(objeto, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("M\u00e9todo GET para " + this.classe.getName() + "." + this.atributo + " desconhecido.");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("M\u00e9todo GET para " + this.classe.getName() + "." + this.atributo + " desconhecido.");
        }
    }

    public static Method getMetodoGet(Class<? extends Object> classe, String atributo) {
        Class<?> tipo = AssistenteDeAtributo.getCampo(classe, atributo).getType();
        String prefixo = tipo == Boolean.TYPE || tipo == Boolean.class ? "is" : "get";
        String metodoNome = prefixo + Character.toUpperCase(atributo.charAt(0)) + atributo.substring(1);
        Method m = null;
        for (Class<? extends Object> c = classe; c != null; c = c.getSuperclass()) {
            try {
                m = c.getDeclaredMethod(metodoNome, new Class[0]);
                if (m == null) continue;
                return m;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("M\u00e9todo GET para " + classe.getName() + "." + atributo + " desconhecido.");
    }

    public static Object invocarGet(Object objeto, String atributo) {
        Class<?> classe = objeto.getClass();
        try {
            return AssistenteDeAtributo.getMetodoGet(classe, atributo).invoke(objeto, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("M\u00e9todo GET para " + classe.getName() + "." + atributo + " desconhecido.");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("M\u00e9todo GET para " + classe.getName() + "." + atributo + " desconhecido.");
        }
    }

    public Method getMetodoSet() {
        if (this.metodoSet == null) {
            this.metodoSet = AssistenteDeAtributo.getMetodoSet(this.classe, this.atributo);
        }
        return this.metodoSet;
    }

    public Object invocarSet(Object objeto, Object valor) {
        try {
            return this.getMetodoSet().invoke(objeto, valor);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("M\u00e9todo SET para " + this.classe.getName() + "." + this.atributo + " desconhecido.");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("M\u00e9todo SET para " + this.classe.getName() + "." + this.atributo + " desconhecido.");
        }
    }

    public static Method getMetodoSet(Class<? extends Object> classe, String atributo) {
        Class<?> tipo = AssistenteDeAtributo.getCampo(classe, atributo).getType();
        String metodoNome = "set" + Character.toUpperCase(atributo.charAt(0)) + atributo.substring(1);
        Method m = null;
        for (Class<? extends Object> c = classe; c != null; c = c.getSuperclass()) {
            try {
                m = c.getDeclaredMethod(metodoNome, tipo);
                if (m == null) continue;
                return m;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("M\u00e9todo SET para " + classe.getName() + "." + atributo + " desconhecido.");
    }

    public static Object invocarSet(Object objeto, String atributo, Object valor) {
        Class<?> classe = objeto.getClass();
        try {
            return AssistenteDeAtributo.getMetodoSet(classe, atributo).invoke(objeto, valor);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("M\u00e9todo SET para " + classe.getName() + "." + atributo + " desconhecido.");
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("M\u00e9todo SET para " + classe.getName() + "." + atributo + " desconhecido.");
        }
    }

    public static <T extends Annotation> T getAnotacao(Class<? extends Object> classe, String atributo, Class<T> tipo, boolean obrigatorio) {
        T jf = AssistenteDeAtributo.getCampo(classe, atributo).getAnnotation(tipo);
        if (obrigatorio && jf == null) {
            throw new IllegalArgumentException(tipo.getName() + " desconhecido.");
        }
        return jf;
    }

    public static JFApresentacao getJFApresentacao(Class<? extends Object> classe, String atributo, boolean obrigatorio) {
        Class<JFApresentacao> tipo = JFApresentacao.class;
        JFApresentacao jf = AssistenteDeAtributo.getCampo(classe, atributo).getAnnotation(tipo);
        if (obrigatorio && jf == null) {
            throw new IllegalArgumentException(tipo.getName() + " desconhecido.");
        }
        return jf;
    }

    public <T extends Annotation> T getAnotacao(Class<T> tipo, boolean obrigatorio) {
        T jf = this.getCampo().getAnnotation(tipo);
        if (obrigatorio && jf == null) {
            throw new IllegalArgumentException(tipo.getName() + " desconhecido.");
        }
        return jf;
    }

    public JFAcesso getJFAcesso(boolean obrigatorio) {
        return this.getAnotacao(JFAcesso.class, obrigatorio);
    }

    public JFApresentacao getJFApresentacao(boolean obrigatorio) {
        return this.getAnotacao(JFApresentacao.class, obrigatorio);
    }

    public JFData getJFData(boolean obrigatorio) {
        return this.getAnotacao(JFData.class, obrigatorio);
    }

    public JFInteiro getJFInteiro(boolean obrigatorio) {
        return this.getAnotacao(JFInteiro.class, obrigatorio);
    }

    public JFReal getJFReal(boolean obrigatorio) {
        return this.getAnotacao(JFReal.class, obrigatorio);
    }

    public JFTexto getJFTexto(boolean obrigatorio) {
        return this.getAnotacao(JFTexto.class, obrigatorio);
    }

    public JFValidacaoNaoNulo getJFValidacaoNaoNulo(boolean obrigatorio) {
        return this.getAnotacao(JFValidacaoNaoNulo.class, obrigatorio);
    }

    public JFValidacaoNaoVazio getJFValidacaoNaoVazio(boolean obrigatorio) {
        return this.getAnotacao(JFValidacaoNaoVazio.class, obrigatorio);
    }

    public JFValidacaoPrimitiva getJFValidacaoPrimitiva(boolean obrigatorio) {
        return this.getAnotacao(JFValidacaoPrimitiva.class, obrigatorio);
    }

    public JFValidacaoTamanhoLimite getJFValidacaoTamanhoLimite(boolean obrigatorio) {
        return this.getAnotacao(JFValidacaoTamanhoLimite.class, obrigatorio);
    }

    public JFValidacaoValorLimite getJFValidacaoValorLimite(boolean obrigatorio) {
        return this.getAnotacao(JFValidacaoValorLimite.class, obrigatorio);
    }
}

