/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.memoria;

import com.joseflavio.memoria.Enumeracao;
import com.joseflavio.memoria.Objeto;
import java.util.Iterator;

public class EnumeracaoArray<T extends Objeto>
implements Enumeracao<T> {
    private T[] array;
    private int pos;
    private int total;

    public EnumeracaoArray(T[] array) {
        this.array = array;
        this.pos = 0;
        this.total = array.length;
    }

    public EnumeracaoArray(T[] array, int inicio, int total) {
        this.array = array;
        this.pos = inicio;
        this.total = total;
    }

    public EnumeracaoArray() {
        this.array = null;
        this.pos = 0;
        this.total = 0;
    }

    @Override
    public boolean temProximo() {
        return this.total > 0;
    }

    @Override
    public T proximo() {
        if (this.total == 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.total;
        return this.array[this.pos++];
    }

    @Override
    public long proximaIdentidade() {
        if (this.total == 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.total;
        return this.array[this.pos++].getIdentidade();
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl();
    }

    private class IteratorImpl
    implements Iterator<T> {
        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return EnumeracaoArray.this.total > 0;
        }

        @Override
        public T next() {
            return EnumeracaoArray.this.proximo();
        }

        @Override
        public void remove() {
        }
    }
}

