/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.jpa;

import com.joseflavio.jpa.PersistenceUnit;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PersistenceXML
implements ContentHandler {
    private Map<String, PersistenceUnit> units = new HashMap<String, PersistenceUnit>();
    private StringBuilder buffer;
    private PersistenceUnit ultimaUnit;

    public PersistenceXML() throws IOException {
        try {
            XMLReader xml = XMLReaderFactory.createXMLReader();
            xml.setContentHandler(this);
            xml.parse(new InputSource(PersistenceXML.class.getClassLoader().getResourceAsStream("META-INF/persistence.xml")));
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public PersistenceUnit getPersistenceUnit(String name) {
        return this.units.get(name);
    }

    @Override
    public void startDocument() throws SAXException {
        this.buffer = new StringBuilder(256);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.buffer.delete(0, this.buffer.length());
        if (localName.equals("persistence-unit")) {
            this.ultimaUnit = new PersistenceUnit(atts.getValue("name"));
            this.units.put(this.ultimaUnit.getName(), this.ultimaUnit);
        } else if (localName.equals("property")) {
            this.ultimaUnit.properties.put(atts.getValue("name"), atts.getValue("value"));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (localName.equals("class")) {
                this.ultimaUnit.classes.add(Class.forName(this.buffer.toString()));
            } else if (localName.equals("provider")) {
                this.ultimaUnit.provider = Class.forName(this.buffer.toString());
            }
        }
        catch (ClassNotFoundException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.ultimaUnit = null;
        this.buffer = null;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }
}

