/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.jpa;

import com.joseflavio.modelo.AssistenteDeAtributo;
import com.joseflavio.tqc.aplicacao.BancoDeDadosException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.spi.PersistenceProvider;

public class PersistenceUnit {
    private String name;
    Class<? extends PersistenceProvider> provider;
    List<Class<? extends Object>> classes = new ArrayList<Class<? extends Object>>();
    Map<String, String> properties = new HashMap<String, String>();

    PersistenceUnit(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends PersistenceProvider> getProvider() {
        return this.provider;
    }

    public List<Class<? extends Object>> getClasses() {
        return this.classes;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getPropriedade(String nome) {
        return this.properties != null ? this.properties.get(nome) : null;
    }

    private String nomeAtributoId(Class<? extends Object> c) {
        for (Field f : AssistenteDeAtributo.getCampos(c)) {
            if (f.getAnnotation(Id.class) == null) continue;
            return f.getName();
        }
        return null;
    }

    public boolean temReferencia(EntityManager em, Object alvo) throws BancoDeDadosException {
        try {
            Class<?> alvoClasse = alvo.getClass();
            String alvoNomeId = this.nomeAtributoId(alvoClasse);
            Object alvoValorId = AssistenteDeAtributo.getMetodoGet(alvoClasse, alvoNomeId).invoke(alvo, new Object[0]);
            for (Class<? extends Object> c : this.classes) {
                if (Modifier.isAbstract(c.getModifiers()) || Modifier.isInterface(c.getModifiers())) continue;
                for (Field f : AssistenteDeAtributo.getCampos(c)) {
                    int quant;
                    if (!f.getType().isAssignableFrom(alvoClasse) || (quant = ((Number)em.createQuery("select count(c) from " + c.getSimpleName() + " c where c." + f.getName() + "." + alvoNomeId + " = :id").setParameter("id", alvoValorId).getSingleResult()).intValue()) <= 0) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new BancoDeDadosException(e);
        }
        return false;
    }

    public int contarReferencias(EntityManager em, Object alvo) throws BancoDeDadosException {
        int total = 0;
        try {
            Class<?> alvoClasse = alvo.getClass();
            String alvoNomeId = this.nomeAtributoId(alvoClasse);
            Object alvoValorId = AssistenteDeAtributo.getMetodoGet(alvoClasse, alvoNomeId).invoke(alvo, new Object[0]);
            for (Class<? extends Object> c : this.classes) {
                if (Modifier.isAbstract(c.getModifiers()) || Modifier.isInterface(c.getModifiers())) continue;
                for (Field f : c.getDeclaredFields()) {
                    if (!f.getType().isAssignableFrom(alvoClasse)) continue;
                    total += ((Number)em.createQuery("select count(c) from " + c.getSimpleName() + " c where c." + f.getName() + "." + alvoNomeId + " = :id").setParameter("id", alvoValorId).getSingleResult()).intValue();
                }
            }
        }
        catch (Exception e) {
            throw new BancoDeDadosException(e);
        }
        return total;
    }

    public int contarObjetos(EntityManager em, Class<? extends Object> classe) throws BancoDeDadosException {
        try {
            return ((Number)em.createQuery("select count(c) from " + classe.getSimpleName() + " c").getSingleResult()).intValue();
        }
        catch (Exception e) {
            throw new BancoDeDadosException(e);
        }
    }
}

