/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.jpa;

import com.joseflavio.tqc.aplicacao.AplicacaoTQC_JPA;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class JPAUtil {
    private static Query prepararQuery(EntityManager em, String query, int resultadoInicial, int maximoResultados, Object ... parametros) {
        Query jpaQuery = em.createQuery(query);
        if (parametros != null) {
            int i = 0;
            for (Object p : parametros) {
                jpaQuery.setParameter("p" + i++, p);
            }
        }
        if (resultadoInicial > -1) {
            jpaQuery.setFirstResult(resultadoInicial);
        }
        if (maximoResultados > -1) {
            jpaQuery.setMaxResults(maximoResultados);
        }
        return jpaQuery;
    }

    public static <T> List<T> listarLimitada(EntityManager em, String query, int resultadoInicial, int maximoResultados, Object ... parametros) {
        return JPAUtil.prepararQuery(em, query, resultadoInicial, maximoResultados, parametros).getResultList();
    }

    public static <T> List<T> listar(EntityManager em, String query, int resultadoInicial, int maximoResultados, Object ... parametros) {
        return JPAUtil.listarLimitada(em, query, resultadoInicial, maximoResultados, parametros);
    }

    public static <T> List<T> listar(AplicacaoTQC_JPA aplicacao, String query, int resultadoInicial, int maximoResultados, Object ... parametros) {
        return JPAUtil.listarLimitada(aplicacao.getEntityManager(), query, resultadoInicial, maximoResultados, parametros);
    }

    public static <T> List<T> listarLimitada(AplicacaoTQC_JPA aplicacao, String query, int resultadoInicial, int maximoResultados, Object ... parametros) {
        return JPAUtil.listarLimitada(aplicacao.getEntityManager(), query, resultadoInicial, maximoResultados, parametros);
    }

    public static <T> List<T> listarLimitada(AplicacaoTQC_JPA aplicacao, String query, int resultadoInicial, int maximoResultados) {
        return JPAUtil.listarLimitada(aplicacao.getEntityManager(), query, resultadoInicial, maximoResultados, (Object[])null);
    }

    public static <T> List<T> listar(EntityManager em, String query, Object ... parametros) {
        return JPAUtil.listarLimitada(em, query, -1, -1, parametros);
    }

    public static <T> List<T> listar(AplicacaoTQC_JPA aplicacao, String query, Object ... parametros) {
        return JPAUtil.listarLimitada(aplicacao.getEntityManager(), query, -1, -1, parametros);
    }

    public static <T> T obter(EntityManager em, String query, Object ... parametros) {
        List<T> lista = JPAUtil.listarLimitada(em, query, -1, 1, parametros);
        return lista.size() > 0 ? (T)lista.get(0) : null;
    }

    public static <T> T obter(AplicacaoTQC_JPA aplicacao, String query, Object ... parametros) {
        List<T> lista = JPAUtil.listarLimitada(aplicacao.getEntityManager(), query, -1, 1, parametros);
        return lista.size() > 0 ? (T)lista.get(0) : null;
    }

    public static long obterQuantidade(EntityManager em, String query, Object ... parametros) {
        return ((Number)JPAUtil.prepararQuery(em, query, -1, -1, parametros).getSingleResult()).longValue();
    }

    public static long obterQuantidade(AplicacaoTQC_JPA aplicacao, String query, Object ... parametros) {
        return JPAUtil.obterQuantidade(aplicacao.getEntityManager(), query, parametros);
    }

    public static Number obterNumero(EntityManager em, String query, Object ... parametros) {
        return (Number)JPAUtil.prepararQuery(em, query, -1, -1, parametros).getSingleResult();
    }

    public static Number obterNumero(AplicacaoTQC_JPA aplicacao, String query, Object ... parametros) {
        return JPAUtil.obterNumero(aplicacao.getEntityManager(), query, parametros);
    }

    public static <T> T destacar(EntityManager em, T obj) {
        em.detach(obj);
        return obj;
    }

    public static <T> T destacar(AplicacaoTQC_JPA aplicacao, T obj) {
        return JPAUtil.destacar(aplicacao.getEntityManager(), obj);
    }

    public static <T> List<T> destacar(EntityManager em, List<T> lista) {
        for (T obj : lista) {
            em.detach(obj);
        }
        return lista;
    }

    public static <T> List<T> destacar(AplicacaoTQC_JPA aplicacao, List<T> lista) {
        return JPAUtil.destacar(aplicacao.getEntityManager(), lista);
    }

    public static <T> List<T> atualizar(EntityManager em, List<T> lista) {
        for (T obj : lista) {
            em.refresh(obj);
        }
        return lista;
    }
}

