/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.dominio.simulacao;

import com.joseflavio.dominio.Dominio;
import com.joseflavio.dominio.DominioException;
import com.joseflavio.dominio.DominioUsuario;
import com.joseflavio.dominio.simulacao.SimulacaoUsuario;
import java.util.HashMap;
import java.util.Map;

public class SimulacaoDominio
extends Dominio {
    private String nome;
    private String endereco;
    private SimulacaoUsuario usuario;
    private Map<String, SimulacaoUsuario> usuarios = new HashMap<String, SimulacaoUsuario>();

    public SimulacaoDominio(String nome, String endereco, SimulacaoUsuario usuario) throws DominioException {
        this.nome = nome;
        this.endereco = endereco;
        this.usuario = usuario;
        this.mais(usuario);
    }

    public SimulacaoDominio mais(SimulacaoUsuario usuario) {
        this.usuarios.put(usuario.getIdentificacao(), usuario);
        return this;
    }

    @Override
    public boolean isDisponivel() {
        return true;
    }

    @Override
    public DominioUsuario buscarUsuario(String identificacao, String baseBusca) throws DominioException {
        return this.buscarUsuario(identificacao);
    }

    @Override
    public DominioUsuario buscarUsuario(String identificacao) throws DominioException {
        SimulacaoUsuario u = this.usuarios.get(identificacao);
        if (u == null) {
            throw new DominioException();
        }
        return u;
    }

    @Override
    public DominioUsuario autenticarUsuario(String identificacao, String senha) throws DominioException {
        SimulacaoUsuario u = this.usuarios.get(identificacao);
        if (u == null) {
            throw new DominioException();
        }
        String s = u.getSenha();
        if (s == null || senha == null || !s.equals(senha)) {
            throw new DominioException();
        }
        return u;
    }

    @Override
    public String getEndereco() {
        return this.endereco;
    }

    @Override
    public String getNome() {
        return this.nome;
    }

    @Override
    public DominioUsuario getUsuario() {
        return this.usuario;
    }
}

