/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.dominio.activedirectory;

import com.joseflavio.dominio.Dominio;
import com.joseflavio.dominio.DominioException;
import com.joseflavio.dominio.DominioUsuario;
import com.joseflavio.dominio.activedirectory.ActiveDirectoryUsuario;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;

public class ActiveDirectory
extends Dominio {
    private String nome;
    private String endereco;
    private ActiveDirectoryUsuario usuario;
    private String senha;

    public ActiveDirectory(String nome, String endereco, String usuario, String senha) throws DominioException {
        this.nome = nome;
        this.endereco = endereco;
        this.usuario = ActiveDirectory.buscarUsuario(usuario, nome, endereco, usuario, senha);
        this.senha = senha;
    }

    @Override
    public boolean isDisponivel() {
        try {
            return this.buscarUsuario(this.usuario.getIdentificacao()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static ActiveDirectoryUsuario buscarUsuario(String usuario, String dominio, String endereco, String baseBusca, String administrador, String senha) throws DominioException {
        ActiveDirectoryUsuario adUsuario = null;
        try {
            Attributes attributes;
            SearchControls controles = new SearchControls();
            controles.setReturningAttributes(new String[]{"displayName", "mail"});
            controles.setSearchScope(2);
            Hashtable<String, String> ambiente = new Hashtable<String, String>(5);
            ambiente.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            ambiente.put("java.naming.provider.url", "ldap://" + endereco);
            ambiente.put("java.naming.security.authentication", "simple");
            ambiente.put("java.naming.security.principal", administrador + "@" + dominio);
            ambiente.put("java.naming.security.credentials", senha);
            InitialLdapContext ldapContext = new InitialLdapContext(ambiente, null);
            NamingEnumeration<SearchResult> answer = ldapContext.search(baseBusca, "(&(objectClass=user)(sAMAccountName=" + usuario + "))", controles);
            if (answer.hasMoreElements() && (attributes = answer.next().getAttributes()) != null) {
                String nomeCompleto = null;
                String email = null;
                NamingEnumeration<? extends Attribute> ne = attributes.getAll();
                while (ne.hasMore()) {
                    Attribute attr = ne.next();
                    String id = attr.getID();
                    if (id.equals("displayName")) {
                        nomeCompleto = (String)attr.get();
                        continue;
                    }
                    if (!id.equals("mail")) continue;
                    email = (String)attr.get();
                }
                ne.close();
                if (nomeCompleto != null && email != null) {
                    adUsuario = new ActiveDirectoryUsuario(usuario, nomeCompleto, email);
                }
            }
            answer.close();
        }
        catch (Exception e) {
            throw new DominioException(e);
        }
        if (adUsuario == null) {
            throw new DominioException(usuario);
        }
        return adUsuario;
    }

    private static ActiveDirectoryUsuario buscarUsuario(String usuario, String dominio, String endereco, String administrador, String senha) throws DominioException {
        StringBuilder baseBusca = new StringBuilder();
        StringTokenizer st = new StringTokenizer(dominio, ".");
        boolean primeiro = true;
        while (st.hasMoreTokens()) {
            if (primeiro) {
                baseBusca.append("dc=" + st.nextToken());
                primeiro = false;
                continue;
            }
            baseBusca.append(", dc=" + st.nextToken());
        }
        return ActiveDirectory.buscarUsuario(usuario, dominio, endereco, baseBusca.toString(), administrador, senha);
    }

    @Override
    public DominioUsuario buscarUsuario(String identificacao, String baseBusca) throws DominioException {
        return ActiveDirectory.buscarUsuario(identificacao, this.nome, this.endereco, baseBusca, this.usuario.getIdentificacao(), this.senha);
    }

    @Override
    public DominioUsuario buscarUsuario(String identificacao) throws DominioException {
        return ActiveDirectory.buscarUsuario(identificacao, this.nome, this.endereco, this.usuario.getIdentificacao(), this.senha);
    }

    @Override
    public DominioUsuario autenticarUsuario(String identificacao, String senha) throws DominioException {
        return ActiveDirectory.buscarUsuario(identificacao, this.nome, this.endereco, identificacao, senha);
    }

    @Override
    public String getEndereco() {
        return this.endereco;
    }

    @Override
    public String getNome() {
        return this.nome;
    }

    @Override
    public DominioUsuario getUsuario() {
        return this.usuario;
    }
}

