/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.dominio;

import com.joseflavio.dominio.Dominio;
import com.joseflavio.dominio.DominioException;
import com.joseflavio.dominio.DominioUsuario;
import java.util.HashMap;
import java.util.Map;

public class CacheDominio
extends Dominio {
    private Dominio dominio;
    private Map<String, DominioUsuario> cache = new HashMap<String, DominioUsuario>();

    public CacheDominio(Dominio dominio) throws DominioException {
        this.dominio = dominio;
    }

    @Override
    public boolean isDisponivel() {
        return this.dominio.isDisponivel();
    }

    @Override
    public DominioUsuario buscarUsuario(String identificacao, String baseBusca) throws DominioException {
        DominioUsuario u = this.cache.get(identificacao);
        if (u == null && (u = this.dominio.buscarUsuario(identificacao, baseBusca)) != null) {
            this.cache.put(u.getIdentificacao(), u);
        }
        return u;
    }

    @Override
    public DominioUsuario buscarUsuario(String identificacao) throws DominioException {
        DominioUsuario u = this.cache.get(identificacao);
        if (u == null && (u = this.dominio.buscarUsuario(identificacao)) != null) {
            this.cache.put(u.getIdentificacao(), u);
        }
        return u;
    }

    @Override
    public DominioUsuario autenticarUsuario(String identificacao, String senha) throws DominioException {
        DominioUsuario u = this.dominio.autenticarUsuario(identificacao, senha);
        if (u != null) {
            this.cache.put(u.getIdentificacao(), u);
        }
        return u;
    }

    @Override
    public String getEndereco() {
        return this.dominio.getEndereco();
    }

    @Override
    public String getNome() {
        return this.dominio.getNome();
    }

    @Override
    public DominioUsuario getUsuario() {
        return this.dominio.getUsuario();
    }
}

