/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.cultura;

import com.joseflavio.cultura.Sintaxe;

class Sintaxe_pt_BR
extends Sintaxe {
    public static final Sintaxe_pt_BR instancia = new Sintaxe_pt_BR();
    public static final String[] MES_COMPLETO = new String[]{"Janeiro", "Fevereiro", "Mar\u00e7o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"};
    public static final String[] MES_ABREVIADO = new String[]{"Jan", "Fev", "Mar", "Abr", "Mai", "Jun", "Jul", "Ago", "Set", "Out", "Nov", "Dez"};
    public static final String[] DIA_SEMANA_COMPLETO = new String[]{"Domingo", "Segunda-feira", "Ter\u00e7a-feira", "Quarta-feira", "Quinta-feira", "Sexta-feira", "S\u00e1bado"};

    private Sintaxe_pt_BR() {
    }

    @Override
    public String getMesNome(int mes) {
        return MES_COMPLETO[mes];
    }

    @Override
    public int getMes(String nome) throws IllegalArgumentException {
        int total = MES_COMPLETO.length;
        for (int i = 0; i < total; ++i) {
            if (!MES_COMPLETO[i].equals(nome)) continue;
            return i;
        }
        throw new IllegalArgumentException(nome);
    }

    @Override
    public String getMesNomeAbreviado(int mes) {
        return MES_ABREVIADO[mes];
    }

    @Override
    public int getMesAbreviado(String abreviado) throws IllegalArgumentException {
        int total = MES_ABREVIADO.length;
        for (int i = 0; i < total; ++i) {
            if (!MES_ABREVIADO[i].equals(abreviado)) continue;
            return i;
        }
        throw new IllegalArgumentException(abreviado);
    }

    @Override
    public String getDiaDaSemanaNome(int diaDaSemana) {
        return DIA_SEMANA_COMPLETO[diaDaSemana - 1];
    }

    @Override
    public int getDiaDaSemana(String nome) throws IllegalArgumentException {
        int total = DIA_SEMANA_COMPLETO.length;
        for (int i = 0; i < total; ++i) {
            if (!DIA_SEMANA_COMPLETO[i].equals(nome)) continue;
            return i + 1;
        }
        throw new IllegalArgumentException(nome);
    }

    @Override
    public String[] getMesesNomes() {
        return MES_COMPLETO;
    }

    @Override
    public String[] getMesesNomesAbreviados() {
        return MES_ABREVIADO;
    }

    @Override
    public String[] getDiasDaSemanaNomes() {
        return DIA_SEMANA_COMPLETO;
    }

    @Override
    public String getEscrita(int palavra, boolean genero) throws IllegalArgumentException {
        switch (palavra) {
            case 1: {
                return "Ok";
            }
            case 2: {
                return "Cancelar";
            }
            case 3: {
                return "Sim";
            }
            case 4: {
                return "N\u00e3o";
            }
            case 5: {
                return "Aten\u00e7\u00e3o";
            }
            case 6: {
                return "Informa\u00e7\u00e3o";
            }
            case 7: {
                return "Erro";
            }
            case 8: {
                return "Ajuda";
            }
            case 9: {
                return "A\u00e7\u00e3o";
            }
            case 10: {
                return "P\u00e1gina";
            }
            case 11: {
                return genero ? "Primeiro" : "Primeira";
            }
            case 12: {
                return genero ? "\u00daltimo" : "\u00daltima";
            }
            case 13: {
                return genero ? "\u00danico" : "\u00danica";
            }
        }
        throw new IllegalArgumentException("Palavra desconhecida!");
    }

    @Override
    public char getSeparadorMilha() {
        return '.';
    }

    @Override
    public char getSeparadorDecimal() {
        return ',';
    }
}

