/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.cultura;

import com.joseflavio.cultura.Sintaxe;

class Sintaxe_en_US
extends Sintaxe {
    public static final Sintaxe_en_US instancia = new Sintaxe_en_US();
    public static final String[] MES_COMPLETO = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final String[] MES_ABREVIADO = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String[] DIA_SEMANA_COMPLETO = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

    private Sintaxe_en_US() {
    }

    @Override
    public String getMesNome(int mes) {
        return MES_COMPLETO[mes];
    }

    @Override
    public int getMes(String nome) throws IllegalArgumentException {
        int total = MES_COMPLETO.length;
        for (int i = 0; i < total; ++i) {
            if (!MES_COMPLETO[i].equals(nome)) continue;
            return i;
        }
        throw new IllegalArgumentException(nome);
    }

    @Override
    public String getMesNomeAbreviado(int mes) {
        return MES_ABREVIADO[mes];
    }

    @Override
    public int getMesAbreviado(String abreviado) throws IllegalArgumentException {
        int total = MES_ABREVIADO.length;
        for (int i = 0; i < total; ++i) {
            if (!MES_ABREVIADO[i].equals(abreviado)) continue;
            return i;
        }
        throw new IllegalArgumentException(abreviado);
    }

    @Override
    public String getDiaDaSemanaNome(int diaDaSemana) {
        return DIA_SEMANA_COMPLETO[diaDaSemana - 1];
    }

    @Override
    public int getDiaDaSemana(String nome) throws IllegalArgumentException {
        int total = DIA_SEMANA_COMPLETO.length;
        for (int i = 0; i < total; ++i) {
            if (!DIA_SEMANA_COMPLETO[i].equals(nome)) continue;
            return i + 1;
        }
        throw new IllegalArgumentException(nome);
    }

    @Override
    public String[] getMesesNomes() {
        return MES_COMPLETO;
    }

    @Override
    public String[] getMesesNomesAbreviados() {
        return MES_ABREVIADO;
    }

    @Override
    public String[] getDiasDaSemanaNomes() {
        return DIA_SEMANA_COMPLETO;
    }

    @Override
    public String getEscrita(int palavra, boolean genero) throws IllegalArgumentException {
        switch (palavra) {
            case 1: {
                return "Ok";
            }
            case 2: {
                return "Cancel";
            }
            case 3: {
                return "Yes";
            }
            case 4: {
                return "No";
            }
            case 5: {
                return "Warning";
            }
            case 6: {
                return "Information";
            }
            case 7: {
                return "Error";
            }
            case 8: {
                return "Help";
            }
            case 9: {
                return "Action";
            }
            case 10: {
                return "Page";
            }
            case 11: {
                return "First";
            }
            case 12: {
                return "Last";
            }
            case 13: {
                return "Single";
            }
        }
        throw new IllegalArgumentException("Unknown word!");
    }

    @Override
    public char getSeparadorMilha() {
        return ',';
    }

    @Override
    public char getSeparadorDecimal() {
        return '.';
    }
}

