/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.cultura;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.cultura.Sintaxe;
import com.joseflavio.cultura.Transformacao;
import com.joseflavio.cultura.TransformacaoException;

public final class NumeroTransformacao
extends Transformacao {
    private Cultura cultura;
    private StringBuffer buffer = new StringBuffer(60);
    private int maximoDigitosNaFracao = 10;
    private int maximoDigitosNoInteiro = 1000;
    private int minimoDigitosNaFracao = 0;
    private int minimoDigitosNoInteiro = 0;
    private boolean usarMilha = true;
    private char separadorMilha;
    private char separadorDecimal;
    private boolean preferenciaReal;

    NumeroTransformacao(Cultura cultura, boolean preferenciaReal) {
        this.cultura = cultura;
        this.preferenciaReal = preferenciaReal;
        Sintaxe sintaxe = cultura.getSintaxe();
        this.separadorMilha = sintaxe.getSeparadorMilha();
        this.separadorDecimal = sintaxe.getSeparadorDecimal();
    }

    public String transcrever(double numero) throws TransformacaoException {
        return this.transcrever(numero, new StringBuffer(20)).toString();
    }

    public String transcreverConfiante(double numero) {
        try {
            return this.transcrever(numero);
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    public String transcrever(float numero) throws TransformacaoException {
        return this.transcrever(numero, new StringBuffer(20)).toString();
    }

    public String transcreverConfiante(float numero) {
        try {
            return this.transcrever(numero);
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    public String transcrever(double numero, int maximoDigitosNaFracao, boolean usarMilha) throws TransformacaoException {
        return this.transcreverReal(numero, new StringBuffer(20), maximoDigitosNaFracao, 1000, 0, 0, usarMilha).toString();
    }

    public String transcrever(float numero, int maximoDigitosNaFracao, boolean usarMilha) throws TransformacaoException {
        return this.transcreverReal(numero, new StringBuffer(20), maximoDigitosNaFracao, 1000, 0, 0, usarMilha).toString();
    }

    public String transcrever(long numero) throws TransformacaoException {
        return this.transcrever(numero, new StringBuffer(20)).toString();
    }

    public String transcreverConfiante(long numero) {
        try {
            return this.transcrever(numero);
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    public StringBuffer transcrever(double numero, StringBuffer receptor) throws TransformacaoException {
        return this.transcreverReal(numero, receptor, this.maximoDigitosNaFracao, this.maximoDigitosNoInteiro, this.minimoDigitosNaFracao, this.minimoDigitosNoInteiro, this.usarMilha);
    }

    public StringBuffer transcrever(float numero, StringBuffer receptor) throws TransformacaoException {
        return this.transcreverReal(numero, receptor, this.maximoDigitosNaFracao, this.maximoDigitosNoInteiro, this.minimoDigitosNaFracao, this.minimoDigitosNoInteiro, this.usarMilha);
    }

    private StringBuffer transcreverReal(double numero, StringBuffer receptor, int maxFracao, int maxInteiro, int minFracao, int minInteiro, boolean milha) throws TransformacaoException {
        return this.transcreverReal(String.valueOf(numero), receptor, maxFracao, maxInteiro, minFracao, minInteiro, milha);
    }

    private StringBuffer transcreverReal(float numero, StringBuffer receptor, int maxFracao, int maxInteiro, int minFracao, int minInteiro, boolean milha) throws TransformacaoException {
        return this.transcreverReal(String.valueOf(numero), receptor, maxFracao, maxInteiro, minFracao, minInteiro, milha);
    }

    private StringBuffer transcreverReal(String numeroStr, StringBuffer receptor, int maxFracao, int maxInteiro, int minFracao, int minInteiro, boolean milha) throws TransformacaoException {
        try {
            this.buffer.delete(0, this.buffer.length());
            if (numeroStr.endsWith(".0")) {
                numeroStr = numeroStr.substring(0, numeroStr.length() - 2);
            }
            int decimal = -1;
            int E = numeroStr.indexOf(69);
            if (E != -1) {
                int exp = Integer.parseInt(numeroStr.substring(E + 1, numeroStr.length()));
                this.buffer.append(numeroStr.substring(0, E));
                this.buffer.deleteCharAt(1);
                if (exp >= this.buffer.length() - 1) {
                    this.inserirZeros(this.buffer, this.buffer.length(), exp - this.buffer.length() + 1);
                }
                decimal = exp + 1;
            } else {
                this.buffer.append(numeroStr);
                decimal = numeroStr.indexOf(46);
                if (decimal != -1) {
                    this.buffer.deleteCharAt(decimal);
                } else {
                    decimal = this.buffer.length();
                }
            }
            int tamanho = decimal;
            if (tamanho < minInteiro) {
                this.inserirZeros(this.buffer, 0, minInteiro - tamanho);
                decimal += minInteiro - tamanho;
            } else if (tamanho > maxInteiro) {
                this.buffer.delete(0, decimal - maxInteiro);
                decimal = maxInteiro;
            }
            tamanho = this.buffer.length() - decimal;
            if (tamanho < minFracao) {
                this.inserirZeros(this.buffer, this.buffer.length(), minFracao - tamanho);
            } else if (tamanho > maxFracao) {
                this.buffer.delete(decimal + maxFracao, this.buffer.length());
            }
            if (decimal < this.buffer.length()) {
                this.buffer.insert(decimal, this.separadorDecimal);
            }
            if (milha) {
                int fim = 0;
                char sinal = this.buffer.charAt(0);
                if (sinal == '-' || sinal == '+') {
                    ++fim;
                }
                for (int i = decimal - 3; i > fim; i -= 3) {
                    this.buffer.insert(i, this.separadorMilha);
                }
            }
            tamanho = this.buffer.length();
            for (E = 0; E < tamanho; ++E) {
                receptor.append(this.buffer.charAt(E));
            }
            return receptor;
        }
        catch (Exception e) {
            throw new TransformacaoException(e.getMessage());
        }
    }

    public StringBuffer transcrever(long numero, StringBuffer receptor) throws TransformacaoException {
        return this.transcreverReal((double)numero, receptor, 0, this.maximoDigitosNoInteiro, 0, this.minimoDigitosNoInteiro, this.usarMilha);
    }

    @Override
    public StringBuffer transcrever(Object numero, StringBuffer receptor) throws TransformacaoException {
        if (numero instanceof Double) {
            return this.transcrever((Double)numero, receptor);
        }
        if (numero instanceof Float) {
            return this.transcrever(((Float)numero).doubleValue(), receptor);
        }
        if (numero instanceof Long) {
            return this.transcrever((Long)numero, receptor);
        }
        if (numero instanceof Integer) {
            return this.transcrever(((Integer)numero).longValue(), receptor);
        }
        if (numero instanceof Short) {
            return this.transcrever(((Short)numero).longValue(), receptor);
        }
        if (numero instanceof Byte) {
            return this.transcrever(((Byte)numero).longValue(), receptor);
        }
        throw new TransformacaoException("O objeto n\u00e3o corresponde a um n\u00famero.");
    }

    private void inserirZeros(StringBuffer sb, int indice, int n) {
        while (n > 0) {
            sb.insert(indice, '0');
            --n;
        }
    }

    @Override
    public Object transformar(Object obj) throws TransformacaoException {
        if (!(obj instanceof String)) {
            throw new TransformacaoException("Objeto incompat\u00edvel.");
        }
        try {
            if (this.preferenciaReal) {
                return Double.valueOf(this.enxugar((String)obj));
            }
            return Long.valueOf(this.enxugar((String)obj));
        }
        catch (Exception e) {
            throw new TransformacaoException(e.getMessage());
        }
    }

    public double transformarReal(String str) throws TransformacaoException {
        try {
            return Double.parseDouble(this.enxugar(str));
        }
        catch (Exception e) {
            throw new TransformacaoException(e.getMessage());
        }
    }

    public double transformarRealConfiante(String str) {
        try {
            return this.transformarReal(str);
        }
        catch (TransformacaoException e) {
            return 0.0;
        }
    }

    public long transformarInteiro(String str) throws TransformacaoException {
        try {
            return Long.parseLong(this.enxugar(str));
        }
        catch (Exception e) {
            throw new TransformacaoException(e.getMessage());
        }
    }

    public long transformarInteiroConfiante(String str) {
        try {
            return this.transformarInteiro(str);
        }
        catch (TransformacaoException e) {
            return 0L;
        }
    }

    private String enxugar(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == this.separadorDecimal) {
                sb.append('.');
                continue;
            }
            if (ch == this.separadorMilha) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public Cultura getCultura() {
        return this.cultura;
    }

    public void setUsarMilha(boolean usarMilha) {
        this.usarMilha = usarMilha;
    }

    public boolean isUsarMilha() {
        return this.usarMilha;
    }

    public int getMaximoDigitosNaFracao() {
        return this.maximoDigitosNaFracao;
    }

    public void setMaximoDigitosNaFracao(int digitos) {
        this.maximoDigitosNaFracao = digitos;
        if (digitos < this.minimoDigitosNaFracao) {
            this.minimoDigitosNaFracao = digitos;
        }
    }

    public int getMaximoDigitosNoInteiro() {
        return this.maximoDigitosNoInteiro;
    }

    public void setMaximoDigitosNoInteiro(int digitos) {
        this.maximoDigitosNoInteiro = digitos;
        if (digitos < this.minimoDigitosNoInteiro) {
            this.minimoDigitosNoInteiro = digitos;
        }
    }

    public int getMinimoDigitosNaFracao() {
        return this.minimoDigitosNaFracao;
    }

    public void setMinimoDigitosNaFracao(int digitos) {
        this.minimoDigitosNaFracao = digitos;
        if (digitos > this.maximoDigitosNaFracao) {
            this.maximoDigitosNaFracao = digitos;
        }
    }

    public int getMinimoDigitosNoInteiro() {
        return this.minimoDigitosNoInteiro;
    }

    public void setMinimoDigitosNoInteiro(int digitos) {
        this.minimoDigitosNoInteiro = digitos;
        if (digitos > this.maximoDigitosNoInteiro) {
            this.maximoDigitosNoInteiro = digitos;
        }
    }

    public boolean isPreferenciaReal() {
        return this.preferenciaReal;
    }
}

