/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.cultura;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.cultura.DataTransformacao;
import com.joseflavio.cultura.Sintaxe;
import com.joseflavio.cultura.TransformacaoException;
import com.joseflavio.util.SeparadorTextual;
import java.util.Calendar;

class DataTransformacao_pt_BR
extends DataTransformacao {
    private SeparadorTextual separadorDataResumida = new SeparadorTextual(new char[]{'/', '/'});
    private SeparadorTextual separadorDataExtensa = new SeparadorTextual(new String[]{" de ", " de "});
    private SeparadorTextual separadorDataCompleta = new SeparadorTextual(new String[]{", ", " de ", " de "});
    private SeparadorTextual separadorDataNormal = new SeparadorTextual(new char[]{'/', '/'});
    private SeparadorTextual separadorDataNumerica = new SeparadorTextual(new char[]{'/', '/'});
    private SeparadorTextual separadorHoraResumida = new SeparadorTextual(new char[]{':'});
    private SeparadorTextual separadorHoraExtensa = new SeparadorTextual(new String[]{"h", "min", "s"});
    private SeparadorTextual separadorHoraCompleta = new SeparadorTextual(new String[]{"h", "min", "s"});
    private SeparadorTextual separadorHoraNormal = new SeparadorTextual(new char[]{':', ':'});
    private SeparadorTextual separadorHoraNumerica = new SeparadorTextual(new char[]{':'});
    private SeparadorTextual separadorDataHoraResumida = new SeparadorTextual(new char[]{'/', '/', ' ', ':'});
    private SeparadorTextual separadorDataHoraExtensa = new SeparadorTextual(new String[]{" de ", " de ", " ", "h", "min", "s"});
    private SeparadorTextual separadorDataHoraCompleta = new SeparadorTextual(new String[]{", ", " de ", " de ", " ", "h", "min", "s"});
    private SeparadorTextual separadorDataHoraNormal = new SeparadorTextual(new char[]{'/', '/', ' ', ':', ':'});
    private SeparadorTextual separadorDataHoraNumerica = new SeparadorTextual(new char[]{'/', '/', ' ', ':'});

    DataTransformacao_pt_BR(Cultura cultura, int estilo) {
        super(cultura, estilo);
    }

    @Override
    protected StringBuffer transcreverData(Calendar data, Sintaxe sintaxe, int estilo, StringBuffer receptor) throws TransformacaoException {
        try {
            int dia = data.get(5);
            int mes = data.get(2) + 1;
            int ano = data.get(1);
            switch (estilo) {
                case 4: {
                    return receptor.append(this.doisDigitos(dia) + "/" + this.doisDigitos(mes) + "/" + this.quatroDigitos(ano));
                }
                case 3: {
                    return receptor.append(this.doisDigitos(dia) + "/" + this.doisDigitos(mes) + "/" + this.quatroDigitos(ano).substring(2, 4));
                }
                case 1: {
                    return receptor.append(dia + " de " + sintaxe.getMesNome(mes - 1) + " de " + ano);
                }
                case 0: {
                    return receptor.append(sintaxe.getDiaDaSemanaNome(data.get(7)) + ", " + dia + " de " + sintaxe.getMesNome(mes - 1) + " de " + ano);
                }
            }
            return receptor.append(this.doisDigitos(dia) + "/" + this.doisDigitos(mes) + "/" + this.quatroDigitos(ano));
        }
        catch (Exception e) {
            throw new TransformacaoException(e.getMessage());
        }
    }

    @Override
    protected StringBuffer transcreverHora(Calendar hora, Sintaxe sintaxe, int estilo, StringBuffer receptor) throws TransformacaoException {
        try {
            int h = hora.get(11);
            int m = hora.get(12);
            int s = hora.get(13);
            switch (estilo) {
                case 4: {
                    return receptor.append(this.doisDigitos(h) + ":" + this.doisDigitos(m));
                }
                case 3: {
                    return receptor.append(this.doisDigitos(h) + ":" + this.doisDigitos(m));
                }
                case 1: {
                    return receptor.append(h + "h" + m + "min" + s + "s");
                }
                case 0: {
                    return receptor.append(this.doisDigitos(h) + "h" + this.doisDigitos(m) + "min" + this.doisDigitos(s) + "s");
                }
            }
            return receptor.append(this.doisDigitos(h) + ":" + this.doisDigitos(m) + ":" + this.doisDigitos(s));
        }
        catch (Exception e) {
            throw new TransformacaoException(e.getMessage());
        }
    }

    @Override
    protected StringBuffer transcreverDataHora(Calendar dataHora, Sintaxe sintaxe, int estilo, StringBuffer receptor) throws TransformacaoException {
        this.transcreverData(dataHora, sintaxe, estilo, receptor);
        receptor.append(" ");
        this.transcreverHora(dataHora, sintaxe, estilo, receptor);
        return receptor;
    }

    @Override
    protected void transformarData(String data, Sintaxe sintaxe, int estilo, Calendar receptor) throws TransformacaoException {
        try {
            int dia = 0;
            int mes = 0;
            int ano = 0;
            int semana = 0;
            switch (estilo) {
                case 4: {
                    SeparadorTextual sp = this.separadorDataNumerica;
                    sp.executar(data);
                    dia = Integer.parseInt(sp.getParte(0));
                    mes = Integer.parseInt(sp.getParte(1)) - 1;
                    ano = Integer.parseInt(sp.getParte(2));
                    break;
                }
                case 3: {
                    SeparadorTextual sp = this.separadorDataResumida;
                    sp.executar(data);
                    dia = Integer.parseInt(sp.getParte(0));
                    mes = Integer.parseInt(sp.getParte(1)) - 1;
                    ano = Integer.parseInt(sp.getParte(2)) + this.seculoBase();
                    break;
                }
                case 1: {
                    SeparadorTextual sp = this.separadorDataExtensa;
                    sp.executar(data);
                    dia = Integer.parseInt(sp.getParte(0));
                    mes = sintaxe.getMes(sp.getParte(1));
                    ano = Integer.parseInt(sp.getParte(2));
                    break;
                }
                case 0: {
                    SeparadorTextual sp = this.separadorDataCompleta;
                    sp.executar(data);
                    semana = sintaxe.getDiaDaSemana(sp.getParte(0));
                    dia = Integer.parseInt(sp.getParte(1));
                    mes = sintaxe.getMes(sp.getParte(2));
                    ano = Integer.parseInt(sp.getParte(3));
                    break;
                }
                default: {
                    SeparadorTextual sp = this.separadorDataNormal;
                    sp.executar(data);
                    dia = Integer.parseInt(sp.getParte(0));
                    mes = Integer.parseInt(sp.getParte(1)) - 1;
                    ano = Integer.parseInt(sp.getParte(2));
                }
            }
            if (estilo == 0) {
                receptor.set(7, semana);
            }
            receptor.set(5, dia);
            receptor.set(2, mes);
            receptor.set(1, ano);
        }
        catch (Exception e) {
            throw new TransformacaoException(e.getMessage());
        }
    }

    @Override
    protected void transformarHora(String hora, Sintaxe sintaxe, int estilo, Calendar receptor) throws TransformacaoException {
        try {
            int h = 0;
            int m = 0;
            int s = 0;
            switch (estilo) {
                case 4: {
                    SeparadorTextual sp = this.separadorHoraNumerica;
                    sp.executar(hora);
                    h = Integer.parseInt(sp.getParte(0));
                    m = Integer.parseInt(sp.getParte(1));
                    break;
                }
                case 3: {
                    SeparadorTextual sp = this.separadorHoraResumida;
                    sp.executar(hora);
                    h = Integer.parseInt(sp.getParte(0));
                    m = Integer.parseInt(sp.getParte(1));
                    break;
                }
                case 1: {
                    SeparadorTextual sp = this.separadorHoraExtensa;
                    sp.executar(hora);
                    h = Integer.parseInt(sp.getParte(0));
                    m = Integer.parseInt(sp.getParte(1));
                    s = Integer.parseInt(sp.getParte(2));
                    break;
                }
                case 0: {
                    SeparadorTextual sp = this.separadorHoraCompleta;
                    sp.executar(hora);
                    h = Integer.parseInt(sp.getParte(0));
                    m = Integer.parseInt(sp.getParte(1));
                    s = Integer.parseInt(sp.getParte(2));
                    break;
                }
                default: {
                    SeparadorTextual sp = this.separadorHoraNormal;
                    sp.executar(hora);
                    h = Integer.parseInt(sp.getParte(0));
                    m = Integer.parseInt(sp.getParte(1));
                    s = Integer.parseInt(sp.getParte(2));
                }
            }
            receptor.set(11, h);
            receptor.set(12, m);
            receptor.set(13, s);
        }
        catch (Exception e) {
            throw new TransformacaoException(e.getMessage());
        }
    }

    @Override
    protected void transformarDataHora(String dataHora, Sintaxe sintaxe, int estilo, Calendar receptor) throws TransformacaoException {
        try {
            int dia = 0;
            int mes = 0;
            int ano = 0;
            int semana = 0;
            int h = 0;
            int m = 0;
            int s = 0;
            switch (estilo) {
                case 4: {
                    SeparadorTextual sp = this.separadorDataHoraNumerica;
                    sp.executar(dataHora);
                    dia = Integer.parseInt(sp.getParte(0));
                    mes = Integer.parseInt(sp.getParte(1)) - 1;
                    ano = Integer.parseInt(sp.getParte(2));
                    h = Integer.parseInt(sp.getParte(3));
                    m = Integer.parseInt(sp.getParte(4));
                    break;
                }
                case 3: {
                    SeparadorTextual sp = this.separadorDataHoraResumida;
                    sp.executar(dataHora);
                    dia = Integer.parseInt(sp.getParte(0));
                    mes = Integer.parseInt(sp.getParte(1)) - 1;
                    ano = Integer.parseInt(sp.getParte(2)) + this.seculoBase();
                    h = Integer.parseInt(sp.getParte(3));
                    m = Integer.parseInt(sp.getParte(4));
                    break;
                }
                case 1: {
                    SeparadorTextual sp = this.separadorDataHoraExtensa;
                    sp.executar(dataHora);
                    dia = Integer.parseInt(sp.getParte(0));
                    mes = sintaxe.getMes(sp.getParte(1));
                    ano = Integer.parseInt(sp.getParte(2));
                    h = Integer.parseInt(sp.getParte(3));
                    m = Integer.parseInt(sp.getParte(4));
                    s = Integer.parseInt(sp.getParte(5));
                    break;
                }
                case 0: {
                    SeparadorTextual sp = this.separadorDataHoraCompleta;
                    sp.executar(dataHora);
                    semana = sintaxe.getDiaDaSemana(sp.getParte(0));
                    dia = Integer.parseInt(sp.getParte(1));
                    mes = sintaxe.getMes(sp.getParte(2));
                    ano = Integer.parseInt(sp.getParte(3));
                    h = Integer.parseInt(sp.getParte(4));
                    m = Integer.parseInt(sp.getParte(5));
                    s = Integer.parseInt(sp.getParte(6));
                    break;
                }
                default: {
                    SeparadorTextual sp = this.separadorDataHoraNormal;
                    sp.executar(dataHora);
                    dia = Integer.parseInt(sp.getParte(0));
                    mes = Integer.parseInt(sp.getParte(1)) - 1;
                    ano = Integer.parseInt(sp.getParte(2));
                    h = Integer.parseInt(sp.getParte(3));
                    m = Integer.parseInt(sp.getParte(4));
                    s = Integer.parseInt(sp.getParte(5));
                }
            }
            if (estilo == 0) {
                receptor.set(7, semana);
            }
            receptor.set(5, dia);
            receptor.set(2, mes);
            receptor.set(1, ano);
            receptor.set(11, h);
            receptor.set(12, m);
            receptor.set(13, s);
        }
        catch (Exception e) {
            throw new TransformacaoException(e.getMessage());
        }
    }
}

