/*
 * Decompiled with CFR 0.152.
 */
package com.joseflavio.cultura;

import com.joseflavio.cultura.Cultura;
import com.joseflavio.cultura.Sintaxe;
import com.joseflavio.cultura.Transformacao;
import com.joseflavio.cultura.TransformacaoException;
import java.util.Calendar;
import java.util.Date;

public abstract class DataTransformacao
extends Transformacao {
    public static final int COMPLETA = 0;
    public static final int EXTENSA = 1;
    public static final int NORMAL = 2;
    public static final int RESUMIDA = 3;
    public static final int PADRAO = 2;
    public static final int NUMERICA = 4;
    private Cultura cultura;
    private int estilo;
    private Calendar calendario;
    private Sintaxe sintaxe;

    DataTransformacao(Cultura cultura, int estilo) {
        this.cultura = cultura;
        this.estilo = estilo;
        this.calendario = cultura.novoCalendar();
        this.sintaxe = cultura.getSintaxe();
    }

    @Override
    public StringBuffer transcrever(Object data, StringBuffer receptor) throws TransformacaoException {
        this.calendario.setTime((Date)data);
        return this.transcreverDataHora(this.calendario, this.sintaxe, this.estilo, receptor);
    }

    public final String transcreverDataHora(Date data) throws TransformacaoException {
        return this.transcreverDataHora(data, new StringBuffer(50)).toString();
    }

    public final String transcreverDataHoraConfiante(Date data) {
        try {
            return this.transcreverDataHora(data);
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    public final StringBuffer transcreverDataHora(Date data, StringBuffer receptor) throws TransformacaoException {
        this.calendario.setTime(data);
        return this.transcreverDataHora(this.calendario, this.sintaxe, this.estilo, receptor);
    }

    public final String transcreverData(Date data) throws TransformacaoException {
        return this.transcreverData(data, new StringBuffer(50)).toString();
    }

    public final String transcreverDataConfiante(Date data) {
        try {
            return this.transcreverData(data);
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    public final StringBuffer transcreverData(Date data, StringBuffer receptor) throws TransformacaoException {
        this.calendario.setTime(data);
        return this.transcreverData(this.calendario, this.sintaxe, this.estilo, receptor);
    }

    public final String transcreverHora(Date data) throws TransformacaoException {
        return this.transcreverHora(data, new StringBuffer(50)).toString();
    }

    public final String transcreverHoraConfiante(Date data) {
        try {
            return this.transcreverHora(data);
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    public final StringBuffer transcreverHora(Date data, StringBuffer receptor) throws TransformacaoException {
        this.calendario.setTime(data);
        return this.transcreverHora(this.calendario, this.sintaxe, this.estilo, receptor);
    }

    @Override
    public Object transformar(Object obj) throws TransformacaoException {
        if (!(obj instanceof String)) {
            throw new TransformacaoException("Objeto incompat\u00edvel.");
        }
        this.calendario.clear();
        this.transformarDataHora((String)obj, this.sintaxe, this.estilo, this.calendario);
        return this.calendario.getTime();
    }

    public Date transformarData(String data) throws TransformacaoException {
        this.calendario.clear();
        this.transformarData(data, this.sintaxe, this.estilo, this.calendario);
        return this.calendario.getTime();
    }

    public Date transformarDataConfiante(String data) {
        try {
            return this.transformarData(data);
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    public Date transformarHora(String hora) throws TransformacaoException {
        this.calendario.clear();
        this.transformarHora(hora, this.sintaxe, this.estilo, this.calendario);
        return this.calendario.getTime();
    }

    public Date transformarHoraConfiante(String hora) {
        try {
            return this.transformarHora(hora);
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    public Date transformarDataHora(String dataHora) throws TransformacaoException {
        this.calendario.clear();
        this.transformarDataHora(dataHora, this.sintaxe, this.estilo, this.calendario);
        return this.calendario.getTime();
    }

    public Date transformarDataHoraConfiante(String dataHora) {
        try {
            return this.transformarDataHora(dataHora);
        }
        catch (TransformacaoException e) {
            return null;
        }
    }

    protected abstract StringBuffer transcreverData(Calendar var1, Sintaxe var2, int var3, StringBuffer var4) throws TransformacaoException;

    protected abstract StringBuffer transcreverHora(Calendar var1, Sintaxe var2, int var3, StringBuffer var4) throws TransformacaoException;

    protected abstract StringBuffer transcreverDataHora(Calendar var1, Sintaxe var2, int var3, StringBuffer var4) throws TransformacaoException;

    protected abstract void transformarData(String var1, Sintaxe var2, int var3, Calendar var4) throws TransformacaoException;

    protected abstract void transformarHora(String var1, Sintaxe var2, int var3, Calendar var4) throws TransformacaoException;

    protected abstract void transformarDataHora(String var1, Sintaxe var2, int var3, Calendar var4) throws TransformacaoException;

    public Cultura getCultura() {
        return this.cultura;
    }

    public void setEstilo(int estilo) {
        this.estilo = estilo;
    }

    public int getEstilo() {
        return this.estilo;
    }

    protected String doisDigitos(int n) {
        return n < 10 ? "0" + n : "" + n;
    }

    protected String quatroDigitos(int n) {
        if (n < 10) {
            return "000" + n;
        }
        if (n < 100) {
            return "00" + n;
        }
        if (n < 1000) {
            return "0" + n;
        }
        return "" + n;
    }

    protected int seculoBase() {
        this.calendario.setTime(new Date());
        int seculoBase = this.calendario.get(1);
        while (seculoBase % 100 != 0) {
            --seculoBase;
        }
        return seculoBase;
    }
}

